/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools.pairs;

import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.pairs.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class Pairs<TValue1, TValue2>
extends ArrayList<Pair<TValue1, TValue2>> {
    public Pairs() {
    }

    public Pairs(Pair<TValue1, TValue2> ... pairs) {
        if (pairs == null) {
            return;
        }
        this.addAll(Arrays.asList(pairs));
    }

    public Pairs(List<Pair<TValue1, TValue2>> pairs) {
        if (pairs == null) {
            return;
        }
        this.addAll(pairs);
    }

    public Pairs(TValue1 value1, TValue2 value2, Collection<Pair<TValue1, TValue2>> pairs) {
        if (pairs != null) {
            this.addAll(pairs);
        }
        this.add(value1, value2);
    }

    public static <T, TValue1, TValue2> Pairs<TValue1, TValue2> toPairs(Iterable<T> list, Function<T, TValue1> selectorValue1, Function<T, TValue2> selectorValue2) {
        Pairs<TValue1, TValue2> pairs = new Pairs<TValue1, TValue2>();
        for (T element : list) {
            pairs.add(selectorValue1.apply(element), selectorValue2.apply(element));
        }
        return pairs;
    }

    public Pairs<TValue1, TValue2> add(TValue1 value1, TValue2 value2) {
        this.add(Pair.$(value1, value2));
        return this;
    }

    public Pairs<TValue1, TValue2> add(Pair<TValue1, TValue2> ... pairs) {
        this.addAll(Arrays.asList(pairs));
        return this;
    }

    public Pairs<TValue1, TValue2> add(Pairs<TValue1, TValue2> pairs) {
        this.addAll(pairs);
        return this;
    }

    public void addNew(TValue1 value1, TValue2 value2) {
        this.clear();
        this.add(Pair.$(value1, value2));
    }

    public Pairs<TValue1, TValue2> subList(int from) {
        return new Pairs<TValue1, TValue2>(this.subList(from, this.size()));
    }

    @Override
    public String toString() {
        return PrintUtils.print(this, pair -> pair.key + ":" + pair.value);
    }

    @Override
    public Pairs<TValue1, TValue2> clone() {
        return new Pairs<TValue1, TValue2>(this);
    }

    public Pairs<TValue1, TValue2> copy() {
        return this.clone();
    }
}

