/*
 * Decompiled with CFR 0.152.
 */
package com.jeequan.jeepay;

import com.jeequan.jeepay.Jeepay;
import com.jeequan.jeepay.exception.JeepayException;
import com.jeequan.jeepay.net.APIResource;
import com.jeequan.jeepay.net.RequestOptions;
import com.jeequan.jeepay.request.JeepayRequest;
import com.jeequan.jeepay.response.JeepayResponse;

public class JeepayClient
extends APIResource {
    private String signType = "MD5";
    private String apiKey = Jeepay.apiKey;
    private String apiBase = Jeepay.getApiBase();

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public JeepayClient(String apiBase, String signType, String apiKey) {
        this.apiBase = apiBase;
        this.signType = signType;
        this.apiKey = apiKey;
    }

    public JeepayClient(String apiBase, String apiKey) {
        this.apiBase = apiBase;
        this.apiKey = apiKey;
    }

    public JeepayClient(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiBase() {
        return this.apiBase;
    }

    public void setApiBase(String apiBase) {
        this.apiBase = apiBase;
    }

    public JeepayClient() {
    }

    public <T extends JeepayResponse> T execute(JeepayRequest<T> request) throws JeepayException {
        if (request.getRequestOptions() == null) {
            RequestOptions options = RequestOptions.builder().setVersion(request.getApiVersion()).setUri(request.getApiUri()).setApiKey(this.apiKey).build();
            request.setRequestOptions(options);
        }
        return this.execute(request, APIResource.RequestMethod.POST, this.apiBase);
    }
}

