/*
 * Decompiled with CFR 0.152.
 */
package com.jeequan.jeepay.util;

import com.jeequan.jeepay.util.Base64;
import com.jeequan.jeepay.util.JeepayKit;
import com.jeequan.jeepay.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;

public class JeepayRSA2Kit {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String SIGN_TYPE_RSA = "RSA";
    public static final String SIGN_SHA256RSA_ALGORITHMS = "SHA256WithRSA";

    private static void io(Reader in, Writer out) throws IOException {
        int amount;
        char[] buffer = new char[4096];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }

    private static String readText(InputStream ins) throws IOException {
        InputStreamReader reader = new InputStreamReader(ins);
        StringWriter writer = new StringWriter();
        JeepayRSA2Kit.io(reader, writer);
        return writer.toString();
    }

    private static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        JeepayRSA2Kit.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    private static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty(algorithm).booleanValue()) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = JeepayRSA2Kit.readText(ins).getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static String getSign(Map params, String privateKey) throws Exception {
        return JeepayRSA2Kit.getSign(JeepayKit.getStrSort(params), privateKey);
    }

    public static String getSign(String content, String privateKey) throws Exception {
        PrivateKey priKey = JeepayRSA2Kit.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, new ByteArrayInputStream(privateKey.getBytes()));
        Signature signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
        signature.initSign(priKey);
        signature.update(content.getBytes(CHARSET_UTF8));
        byte[] signed = signature.sign();
        return new String(Base64.encodeBase64(signed));
    }

    public static boolean verify(Map map, String publicKey, String sign) throws Exception {
        return JeepayRSA2Kit.verify(JeepayKit.getStrSort(map), publicKey, sign);
    }

    public static boolean verify(String content, String publicKey, String sign) throws Exception {
        PublicKey pubKey = JeepayRSA2Kit.getPublicKeyFromX509(SIGN_TYPE_RSA, new ByteArrayInputStream(publicKey.getBytes()));
        Signature signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
        signature.initVerify(pubKey);
        signature.update(content.getBytes(CHARSET_UTF8));
        return signature.verify(Base64.decodeBase64(sign.getBytes()));
    }
}

