/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic;

import com.jelastic.JelasticMojo;
import com.jelastic.model.Authentication;
import com.jelastic.model.CreateObject;
import com.jelastic.model.Deploy;
import com.jelastic.model.UpLoader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DeployMojo
extends JelasticMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Authentication authentication = this.authentication();
        if (authentication.getResult() == 0) {
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)"   Authentication : SUCCESS");
            this.getLog().info((CharSequence)("          Session : " + authentication.getSession()));
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            UpLoader upLoader = this.upload(authentication);
            if (upLoader.getResult() == 0) {
                this.getLog().info((CharSequence)"      File UpLoad : SUCCESS");
                this.getLog().info((CharSequence)("         File URL : " + upLoader.getFile()));
                this.getLog().info((CharSequence)("        File size : " + upLoader.getSize()));
                this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                CreateObject createObject = this.createObject(upLoader, authentication);
                if (createObject.getResult() == 0) {
                    this.getLog().info((CharSequence)"File registration : SUCCESS");
                    this.getLog().info((CharSequence)("  Registration ID : " + createObject.getResponse().getObject().getId()));
                    this.getLog().info((CharSequence)("     Developer ID : " + createObject.getResponse().getObject().getDeveloper()));
                    this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                    if (this.isUploadOnly()) {
                        return;
                    }
                    Deploy deploy = this.deploy(authentication, upLoader, createObject);
                    if (deploy.getResponse().getResult() == 0) {
                        this.getLog().info((CharSequence)"      Deploy file : SUCCESS");
                        this.getLog().info((CharSequence)"       Deploy log :");
                        this.getLog().info((CharSequence)deploy.getResponse().getResponses()[0].getOut());
                    } else {
                        this.getLog().error((CharSequence)"          Deploy : FAILED");
                        this.getLog().error((CharSequence)("           Error : " + deploy.getResponse().getError()));
                    }
                }
            } else {
                this.getLog().error((CharSequence)"File upload : FAILED");
                this.getLog().error((CharSequence)("      Error : " + upLoader.getError()));
            }
        } else {
            this.getLog().error((CharSequence)"Authentication : FAILED");
            this.getLog().error((CharSequence)("         Error : " + authentication.getError()));
        }
    }
}

