/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic;

import com.jelastic.CustomMultiPartEntity;
import com.jelastic.model.Authentication;
import com.jelastic.model.CreateObject;
import com.jelastic.model.Deploy;
import com.jelastic.model.UpLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicNameValuePair;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class JelasticMojo
extends AbstractMojo {
    private String shema = "https";
    private int port = -1;
    private String version = "1.0";
    private long totalSize;
    private int numSt;
    private CookieStore cookieStore = null;
    private String urlAuthentication = "/" + this.version + "/users/authentication/rest/signin";
    private String urlUploader = "/" + this.version + "/storage/uploader/rest/upload";
    private String urlCreateObject = "/deploy/createobject";
    private String urlDeploy = "/deploy/DeployArchive";
    private static ObjectMapper mapper = new ObjectMapper();
    private static Properties properties = new Properties();
    private MavenProject project;
    private MavenSession mavenSession;
    private Map<String, String> headers;
    private String email;
    private String password;
    private String context;
    private String api_hoster;
    private String environment;
    private String finalName;
    public File outputDirectory;

    public String getFinalName() {
        return this.finalName;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getShema() {
        return this.shema;
    }

    public String getApiJelastic() {
        if (System.getProperty("jelastic-hoster") != null && System.getProperty("jelastic-hoster").length() > 0) {
            this.api_hoster = System.getProperty("jelastic-hoster");
        }
        return this.api_hoster;
    }

    public int getPort() {
        return this.port;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public String getUrlAuthentication() {
        return this.urlAuthentication;
    }

    public String getUrlUploader() {
        return this.urlUploader;
    }

    public String getUrlCreateObject() {
        return this.urlCreateObject;
    }

    public String getUrlDeploy() {
        return this.urlDeploy;
    }

    public String getEmail() {
        if (this.isExternalParameterPassed()) {
            if (properties.getProperty("jelastic-email") != null && properties.getProperty("jelastic-email").length() > 0) {
                return properties.getProperty("jelastic-email");
            }
            return this.email;
        }
        return this.email;
    }

    public String getPassword() {
        if (this.isExternalParameterPassed()) {
            if (properties.getProperty("jelastic-password") != null && properties.getProperty("jelastic-password").length() > 0) {
                return properties.getProperty("jelastic-password");
            }
            return this.password;
        }
        return this.password;
    }

    public String getContext() {
        if (this.isExternalParameterPassed()) {
            if (properties.getProperty("context") != null && properties.getProperty("context").length() > 0) {
                return properties.getProperty("context");
            }
            return this.context;
        }
        return this.context;
    }

    public String getEnvironment() {
        if (this.isExternalParameterPassed()) {
            if (properties.getProperty("environment") != null && properties.getProperty("environment").length() > 0) {
                return properties.getProperty("environment");
            }
            return this.environment;
        }
        return this.environment;
    }

    public boolean isExternalParameterPassed() {
        if (System.getProperty("jelastic-properties") != null && System.getProperty("jelastic-properties").length() > 0) {
            try {
                properties.load(new FileInputStream(System.getProperty("jelastic-properties")));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isUploadOnly() {
        String uploadOnly = System.getProperty("jelastic-upload-only");
        return uploadOnly != null && (uploadOnly.equalsIgnoreCase("1") || uploadOnly.equalsIgnoreCase("true"));
    }

    public Authentication authentication() throws MojoExecutionException {
        Authentication authentication = new Authentication();
        String jelasticHeaders = System.getProperty("jelastic-headers");
        this.getLog().debug((CharSequence)("jelastic-headers=" + jelasticHeaders));
        if (jelasticHeaders != null && jelasticHeaders.length() > 0) {
            try {
                this.headers = (Map)mapper.readValue(URLDecoder.decode(jelasticHeaders, "UTF8"), Map.class);
                this.getLog().debug((CharSequence)("headers=" + this.headers));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        if (System.getProperty("jelastic-session") != null && System.getProperty("jelastic-session").length() > 0) {
            authentication.setSession(System.getProperty("jelastic-session"));
            authentication.setResult(0);
        } else {
            List proxyList = this.mavenSession.getSettings().getProxies();
            HttpHost http_proxy = null;
            for (Proxy proxy : proxyList) {
                if (proxy.getProtocol().equalsIgnoreCase("http") || proxy.isActive()) {
                    http_proxy = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
                    continue;
                }
                if (!proxy.getProtocol().equalsIgnoreCase("https") && !proxy.isActive()) continue;
                http_proxy = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
            }
            try {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                httpclient = JelasticMojo.wrapClient(httpclient);
                if (http_proxy != null) {
                    httpclient.getParams().setParameter("http.route.default-proxy", http_proxy);
                }
                httpclient.getParams().setParameter("http.route.default-proxy", http_proxy);
                ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
                qparams.add(new BasicNameValuePair("login", this.getEmail()));
                qparams.add(new BasicNameValuePair("password", this.getPassword()));
                URI uri = URIUtils.createURI((String)this.getShema(), (String)this.getApiJelastic(), (int)this.getPort(), (String)this.getUrlAuthentication(), (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
                this.getLog().debug((CharSequence)uri.toString());
                HttpGet httpGet = new HttpGet(uri);
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String responseBody = (String)httpclient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
                this.getLog().debug((CharSequence)responseBody);
                authentication = (Authentication)mapper.readValue(responseBody, Authentication.class);
                this.cookieStore = httpclient.getCookieStore();
            }
            catch (URISyntaxException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
            catch (ClientProtocolException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        return authentication;
    }

    public UpLoader upload(Authentication authentication) throws MojoExecutionException {
        UpLoader upLoader = null;
        List proxyList = this.mavenSession.getSettings().getProxies();
        HttpHost http_proxy = null;
        for (Proxy proxy : proxyList) {
            if (proxy.getProtocol().equalsIgnoreCase("http") || proxy.isActive()) {
                http_proxy = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
                continue;
            }
            if (!proxy.getProtocol().equalsIgnoreCase("https") && !proxy.isActive()) continue;
            http_proxy = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
        }
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient = JelasticMojo.wrapClient(httpclient);
            if (http_proxy != null) {
                httpclient.getParams().setParameter("http.route.default-proxy", http_proxy);
            }
            httpclient.getParams().setParameter("http.route.default-proxy", http_proxy);
            httpclient.setCookieStore(this.getCookieStore());
            File file = new File(this.getOutputDirectory() + File.separator + this.getFinalName() + "." + this.project.getModel().getPackaging());
            if (!file.exists()) {
                throw new MojoExecutionException("First build artifact and try again. Artifact not found " + this.getFinalName() + "." + this.project.getModel().getPackaging());
            }
            this.getLog().info((CharSequence)"File Uploading Progress :");
            CustomMultiPartEntity multipartEntity = new CustomMultiPartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, new CustomMultiPartEntity.ProgressListener(){

                public void transferred(long num) {
                    if ((int)((float)num / (float)JelasticMojo.this.totalSize * 100.0f) != JelasticMojo.this.numSt) {
                        JelasticMojo.this.getLog().info((CharSequence)("[" + (int)((float)num / (float)JelasticMojo.this.totalSize * 100.0f) + "%]"));
                        JelasticMojo.this.numSt = (int)((float)num / (float)JelasticMojo.this.totalSize * 100.0f);
                    }
                }
            });
            multipartEntity.addPart("fid", (ContentBody)new StringBody("123456"));
            multipartEntity.addPart("session", (ContentBody)new StringBody(authentication.getSession()));
            multipartEntity.addPart("file", (ContentBody)new FileBody(file));
            this.totalSize = multipartEntity.getContentLength();
            URI uri = URIUtils.createURI((String)this.getShema(), (String)this.getApiJelastic(), (int)this.getPort(), (String)this.getUrlUploader(), null, null);
            this.getLog().debug((CharSequence)uri.toString());
            HttpPost httpPost = new HttpPost(uri);
            this.addHeaders((AbstractHttpMessage)httpPost);
            httpPost.setEntity((HttpEntity)multipartEntity);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            this.getLog().debug((CharSequence)responseBody);
            upLoader = (UpLoader)mapper.readValue(responseBody, UpLoader.class);
        }
        catch (URISyntaxException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (ClientProtocolException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        return upLoader;
    }

    public CreateObject createObject(UpLoader upLoader, Authentication authentication) {
        CreateObject createObject = null;
        List proxyList = this.mavenSession.getSettings().getProxies();
        HttpHost http_proxy = null;
        for (Proxy proxy : proxyList) {
            if (proxy.getProtocol().equalsIgnoreCase("http") || proxy.isActive()) {
                http_proxy = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
                continue;
            }
            if (!proxy.getProtocol().equalsIgnoreCase("https") && !proxy.isActive()) continue;
            http_proxy = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
        }
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient = JelasticMojo.wrapClient(httpclient);
            if (http_proxy != null) {
                httpclient.getParams().setParameter("http.route.default-proxy", http_proxy);
            }
            httpclient.getParams().setParameter("http.route.default-proxy", http_proxy);
            httpclient.setCookieStore(this.getCookieStore());
            ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
            nameValuePairList.add(new BasicNameValuePair("charset", "UTF-8"));
            nameValuePairList.add(new BasicNameValuePair("session", authentication.getSession()));
            nameValuePairList.add(new BasicNameValuePair("type", "JDeploy"));
            nameValuePairList.add(new BasicNameValuePair("data", "{'name':'" + this.getFinalName() + "." + this.project.getModel().getPackaging() + "', 'archive':'" + upLoader.getFile() + "', 'link':0, 'size':" + upLoader.getSize() + ", 'comment':'" + this.getFinalName() + "." + this.project.getModel().getPackaging() + "'}"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairList, "UTF-8");
            for (NameValuePair nameValuePair : nameValuePairList) {
                this.getLog().debug((CharSequence)(nameValuePair.getName() + " : " + nameValuePair.getValue()));
            }
            URI uri = URIUtils.createURI((String)this.getShema(), (String)this.getApiJelastic(), (int)this.getPort(), (String)this.getUrlCreateObject(), null, null);
            this.getLog().debug((CharSequence)uri.toString());
            HttpPost httpPost = new HttpPost(uri);
            this.addHeaders((AbstractHttpMessage)httpPost);
            httpPost.setEntity((HttpEntity)entity);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            this.getLog().debug((CharSequence)responseBody);
            createObject = (CreateObject)mapper.readValue(responseBody, CreateObject.class);
        }
        catch (URISyntaxException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (ClientProtocolException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        return createObject;
    }

    public Deploy deploy(Authentication authentication, UpLoader upLoader, CreateObject createObject) {
        Deploy deploy = null;
        List proxyList = this.mavenSession.getSettings().getProxies();
        HttpHost http_proxy = null;
        for (Proxy proxy : proxyList) {
            if (proxy.getProtocol().equalsIgnoreCase("http") || proxy.isActive()) {
                http_proxy = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
                continue;
            }
            if (!proxy.getProtocol().equalsIgnoreCase("https") && !proxy.isActive()) continue;
            http_proxy = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
        }
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient = JelasticMojo.wrapClient(httpclient);
            if (http_proxy != null) {
                httpclient.getParams().setParameter("http.route.default-proxy", http_proxy);
            }
            httpclient.setCookieStore(this.getCookieStore());
            ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
            qparams.add(new BasicNameValuePair("charset", "UTF-8"));
            qparams.add(new BasicNameValuePair("session", authentication.getSession()));
            qparams.add(new BasicNameValuePair("archiveUri", upLoader.getFile()));
            qparams.add(new BasicNameValuePair("archiveName", upLoader.getName()));
            qparams.add(new BasicNameValuePair("newContext", this.getContext()));
            qparams.add(new BasicNameValuePair("domain", this.getEnvironment()));
            URI uri = URIUtils.createURI((String)this.getShema(), (String)this.getApiJelastic(), (int)this.getPort(), (String)this.getUrlDeploy(), (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
            this.getLog().debug((CharSequence)uri.toString());
            HttpGet httpPost = new HttpGet(uri);
            this.addHeaders((AbstractHttpMessage)httpPost);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            this.getLog().debug((CharSequence)responseBody);
            deploy = (Deploy)mapper.readValue(responseBody, Deploy.class);
        }
        catch (URISyntaxException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (ClientProtocolException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        return deploy;
    }

    private void addHeaders(AbstractHttpMessage message) {
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                String value = this.headers.get(key);
                this.getLog().debug((CharSequence)(key + "=" + value));
                message.addHeader(key, value);
            }
        }
    }

    public static DefaultHttpClient wrapClient(DefaultHttpClient base) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = base.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", (SocketFactory)ssf, 443));
            return new DefaultHttpClient(ccm, base.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

