/**
 * Copyright 2023 Jerónimo López Bezanilla
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jerolba.carpet.impl.read;

import java.util.Collection;
import java.util.function.Supplier;

class CollectionHolder {

    private final Supplier<Collection<Object>> collectionFactory;
    private Collection<Object> collection;

    public CollectionHolder(Supplier<Collection<Object>> collectionFactory) {
        this.collectionFactory = collectionFactory;
    }

    public void create() {
        collection = collectionFactory.get();
    }

    public void add(Object value) {
        collection.add(value);
    }

    public Collection<Object> getCollection() {
        return collection;
    }

}