/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.ColumnNamingStrategy;
import com.jerolba.carpet.TimeUnit;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.CarpetWriteSupport;
import com.jerolba.carpet.impl.write.DecimalConfig;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.OutputFile;

public class CarpetParquetWriter {
    private CarpetParquetWriter() {
    }

    public static <T> Builder<T> builder(OutputFile file, Class<T> recordClass) {
        return new Builder<T>(file, recordClass);
    }

    public static class Builder<T>
    extends ParquetWriter.Builder<T, Builder<T>> {
        private final Class<T> recordClass;
        private final Map<String, String> extraMetaData = new HashMap<String, String>();
        private AnnotatedLevels annotatedLevels = AnnotatedLevels.THREE;
        private ColumnNamingStrategy columnNamingStrategy = ColumnNamingStrategy.FIELD_NAME;
        private TimeUnit defaultTimeUnit = TimeUnit.MILLIS;
        private DecimalConfig decimalConfig = DecimalConfig.decimalConfig();

        private Builder(OutputFile file, Class<T> recordClass) {
            super(file);
            this.recordClass = recordClass;
        }

        public Builder<T> withExtraMetaData(Map<String, String> extraMetaData) {
            this.extraMetaData.putAll(extraMetaData);
            return this;
        }

        public Builder<T> withExtraMetaData(String key, String value) {
            this.extraMetaData.put(key, value);
            return this;
        }

        protected Builder<T> self() {
            return this;
        }

        public Builder<T> withLevelStructure(AnnotatedLevels annotatedLevels) {
            Objects.requireNonNull(annotatedLevels, "Annotated levels can not be null");
            this.annotatedLevels = annotatedLevels;
            return this.self();
        }

        public Builder<T> withColumnNamingStrategy(ColumnNamingStrategy columnNamingStrategy) {
            Objects.requireNonNull(columnNamingStrategy, "Column naming strategy can not be null");
            this.columnNamingStrategy = columnNamingStrategy;
            return this.self();
        }

        public Builder<T> withDefaultTimeUnit(TimeUnit defaultTimeUnit) {
            Objects.requireNonNull(defaultTimeUnit, "Default time unit can not be null");
            this.defaultTimeUnit = defaultTimeUnit;
            return this.self();
        }

        public Builder<T> withDefaultDecimal(int precision, int scale) {
            this.decimalConfig = this.decimalConfig.withPrecionAndScale(precision, scale);
            return this.self();
        }

        public Builder<T> withBigDecimalScaleAdjustment(RoundingMode roundingMode) {
            this.decimalConfig = this.decimalConfig.withRoundingMode(roundingMode);
            return this;
        }

        protected WriteSupport<T> getWriteSupport(ParquetConfiguration conf) {
            return this.getWriteSupport();
        }

        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return this.getWriteSupport();
        }

        protected WriteSupport<T> getWriteSupport() {
            CarpetWriteConfiguration carpetCfg = new CarpetWriteConfiguration(this.annotatedLevels, this.columnNamingStrategy, this.defaultTimeUnit, this.decimalConfig);
            return new CarpetWriteSupport<T>(this.recordClass, this.extraMetaData, carpetCfg);
        }
    }
}

