/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet;

import com.jerolba.carpet.CarpetParquetReader;
import com.jerolba.carpet.CloseableIterator;
import com.jerolba.carpet.FieldMatchingStrategy;
import com.jerolba.carpet.io.FileSystemInputFile;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.io.InputFile;

public class CarpetReader<T>
implements Iterable<T> {
    private final InputFile inputFile;
    private final Class<T> recordClass;
    private boolean failOnMissingColumn = true;
    private boolean failOnNullForPrimitives = false;
    private boolean failNarrowingPrimitiveConversion = false;
    private FieldMatchingStrategy fieldMatchingStrategy = CarpetParquetReader.DEFAULT_FIELD_MATCHING_STRATEGY;

    public CarpetReader(InputFile inputFile, Class<T> recordClass) {
        this.inputFile = inputFile;
        this.recordClass = recordClass;
    }

    public CarpetReader(File file, Class<T> recordClass) {
        this(new FileSystemInputFile(file), recordClass);
    }

    public CarpetReader<T> withFailOnMissingColumn(boolean value) {
        CarpetReader<T> newInstance = this.cloneInstance();
        newInstance.failOnMissingColumn = value;
        return newInstance;
    }

    public CarpetReader<T> withFailOnNullForPrimitives(boolean value) {
        CarpetReader<T> newInstance = this.cloneInstance();
        newInstance.failOnNullForPrimitives = value;
        return newInstance;
    }

    public CarpetReader<T> withFailNarrowingPrimitiveConversion(boolean value) {
        CarpetReader<T> newInstance = this.cloneInstance();
        newInstance.failNarrowingPrimitiveConversion = value;
        return newInstance;
    }

    public CarpetReader<T> withFieldMatchingStrategy(FieldMatchingStrategy value) {
        CarpetReader<T> newInstance = this.cloneInstance();
        newInstance.fieldMatchingStrategy = value;
        return newInstance;
    }

    private CarpetReader<T> cloneInstance() {
        CarpetReader<T> newInstace = new CarpetReader<T>(this.inputFile, this.recordClass);
        newInstace.failOnMissingColumn = this.failOnMissingColumn;
        newInstace.failOnNullForPrimitives = this.failOnNullForPrimitives;
        newInstace.failNarrowingPrimitiveConversion = this.failNarrowingPrimitiveConversion;
        newInstace.fieldMatchingStrategy = this.fieldMatchingStrategy;
        return newInstace;
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.buildIterator();
    }

    public Stream<T> stream() {
        RecordIterator<T> iterator = this.buildIterator();
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 1296);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(iterator::uncheckedCloseReader);
    }

    public List<T> toList() throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        try (RecordIterator<T> iterator = this.buildIterator();){
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
    }

    private RecordIterator<T> buildIterator() {
        try {
            ParquetReader reader = CarpetParquetReader.builder(this.inputFile, this.recordClass).failOnMissingColumn(this.failOnMissingColumn).failOnNullForPrimitives(this.failOnNullForPrimitives).failNarrowingPrimitiveConversion(this.failNarrowingPrimitiveConversion).fieldMatchingStrategy(this.fieldMatchingStrategy).build();
            return new RecordIterator<T>(this.recordClass, reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class RecordIterator<T>
    implements CloseableIterator<T> {
        private final ParquetReader<T> reader;
        private T nextRecord;

        RecordIterator(Class<T> recordClass, ParquetReader<T> reader) throws IOException {
            this.reader = reader;
            this.nextRecord = reader.read();
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T res = this.nextRecord;
            try {
                this.nextRecord = this.reader.read();
                if (this.nextRecord == null) {
                    this.uncheckedCloseReader();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return res;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.nextRecord = null;
        }

        private void uncheckedCloseReader() {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

