/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.Map;

public class JavaType {
    private final String typeName;
    private final Class<?> type;

    public JavaType(RecordComponent recordComponent) {
        this(recordComponent.getType());
    }

    public JavaType(Class<?> type) {
        this.type = type;
        this.typeName = type.getName();
    }

    public Class<?> getJavaType() {
        return this.type;
    }

    public boolean isString() {
        return this.typeName.equals("java.lang.String");
    }

    public boolean isInteger() {
        return this.typeName.equals("int") || this.typeName.equals("java.lang.Integer");
    }

    public boolean isLong() {
        return this.typeName.equals("long") || this.typeName.equals("java.lang.Long");
    }

    public boolean isShort() {
        return this.typeName.equals("short") || this.typeName.equals("java.lang.Short");
    }

    public boolean isByte() {
        return this.typeName.equals("byte") || this.typeName.equals("java.lang.Byte");
    }

    public boolean isDouble() {
        return this.typeName.equals("double") || this.typeName.equals("java.lang.Double");
    }

    public boolean isFloat() {
        return this.typeName.equals("float") || this.typeName.equals("java.lang.Float");
    }

    public boolean isBoolean() {
        return this.typeName.equals("boolean") || this.typeName.equals("java.lang.Boolean");
    }

    public boolean isUuid() {
        return this.typeName.equals("java.util.UUID");
    }

    public boolean isBigDecimal() {
        return this.typeName.equals("java.math.BigDecimal");
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public boolean isLocalDate() {
        return this.typeName.equals("java.time.LocalDate");
    }

    public boolean isLocalTime() {
        return this.typeName.equals("java.time.LocalTime");
    }

    public boolean isLocalDateTime() {
        return this.typeName.equals("java.time.LocalDateTime");
    }

    public boolean isInstant() {
        return this.typeName.equals("java.time.Instant");
    }

    public boolean isRecord() {
        return this.type.isRecord();
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.type);
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.type);
    }
}

