/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;

public class Parameterized {
    public static ParameterizedCollection getParameterizedCollection(RecordComponent attr) {
        return Parameterized.parametizeTo(attr.getGenericType(), ParameterizedCollection::new);
    }

    public static ParameterizedCollection getParameterizedCollection(Field attr) {
        return Parameterized.parametizeTo(attr.getGenericType(), ParameterizedCollection::new);
    }

    public static boolean isCollection(Type type) {
        return Parameterized.typeIsAssignableFrom(type, Collection.class);
    }

    public static ParameterizedMap getParameterizedMap(RecordComponent attr) {
        return Parameterized.parametizeTo(attr.getGenericType(), ParameterizedMap::new);
    }

    public static ParameterizedMap getParameterizedMap(Field attr) {
        return Parameterized.parametizeTo(attr.getGenericType(), ParameterizedMap::new);
    }

    public static boolean isMap(Type type) {
        return Parameterized.typeIsAssignableFrom(type, Map.class);
    }

    public static Class<?> getClassFromType(Type type, String usageForError) {
        if (type instanceof Class) {
            Class finalType = (Class)type;
            return finalType;
        }
        if (type instanceof TypeVariable) {
            TypeVariable finalType = (TypeVariable)type;
            throw new RecordTypeConversionException(finalType.getName() + " generic type not supported " + usageForError);
        }
        throw new RecordTypeConversionException("Invalid type " + type + " " + usageForError);
    }

    private static boolean typeIsAssignableFrom(Type type, Class<?> toAssign) {
        ParameterizedType paramType;
        Type collectionActualType;
        if (type instanceof ParameterizedType && (collectionActualType = (paramType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class finalType = (Class)collectionActualType;
            return toAssign.isAssignableFrom(finalType);
        }
        return false;
    }

    private static <T> T parametizeTo(Type genericType, BiFunction<Type, ParameterizedType, T> constructor) {
        if (genericType instanceof TypeVariable) {
            throw new RecordTypeConversionException(genericType.toString() + " generic types not supported");
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type collection = paramType.getRawType();
            return constructor.apply(collection, paramType);
        }
        throw new RecordTypeConversionException("Unsuported type in collection");
    }
}

