/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ParameterizedCollection {
    private final Type collectionType;
    private final Type collectionElementType;

    public ParameterizedCollection(Type collectionType, ParameterizedType type) {
        this.collectionType = collectionType;
        this.collectionElementType = type.getActualTypeArguments()[0];
    }

    public Class<?> getActualType() {
        return Parameterized.getClassFromType(this.collectionElementType, "in Collection");
    }

    public Class<?> getCollectionType() {
        return (Class)this.collectionType;
    }

    public ParameterizedCollection getParametizedAsCollection() {
        Type type = this.collectionElementType;
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type collection = paramType.getRawType();
            return new ParameterizedCollection(collection, paramType);
        }
        return null;
    }

    public ParameterizedMap getParametizedAsMap() {
        Type type = this.collectionElementType;
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type map = paramType.getRawType();
            return new ParameterizedMap(map, paramType);
        }
        return null;
    }

    public boolean isCollection() {
        return Parameterized.isCollection(this.collectionElementType);
    }

    public boolean isMap() {
        return Parameterized.isMap(this.collectionElementType);
    }
}

