/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ParameterizedMap {
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public ParameterizedMap(Type mapType, ParameterizedType type) {
        this.mapType = mapType;
        this.keyType = type.getActualTypeArguments()[0];
        this.valueType = type.getActualTypeArguments()[1];
    }

    public Class<?> getMapType() {
        return (Class)this.mapType;
    }

    public Class<?> getValueActualType() {
        return Parameterized.getClassFromType(this.valueType, "in Map value");
    }

    public Class<?> getKeyActualType() {
        return Parameterized.getClassFromType(this.keyType, "in Map key");
    }

    public ParameterizedMap getValueTypeAsMap() {
        Type type = this.valueType;
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type map = paramType.getRawType();
            return new ParameterizedMap(map, paramType);
        }
        return null;
    }

    public ParameterizedCollection getValueTypeAsCollection() {
        Type type = this.valueType;
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type collection = paramType.getRawType();
            return new ParameterizedCollection(collection, paramType);
        }
        return null;
    }

    public boolean valueIsCollection() {
        return Parameterized.isCollection(this.valueType);
    }

    public boolean valueIsMap() {
        return Parameterized.isMap(this.valueType);
    }

    public boolean keyIsCollection() {
        return Parameterized.isCollection(this.keyType);
    }

    public boolean keyIsMap() {
        return Parameterized.isMap(this.keyType);
    }
}

