/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.read.CollectionHolder;
import com.jerolba.carpet.impl.read.LogicalTypeConverters;
import com.jerolba.carpet.impl.read.MapHolder;
import com.jerolba.carpet.impl.read.ReadReflection;
import com.jerolba.carpet.impl.read.SchemaValidation;
import com.jerolba.carpet.impl.read.converter.BooleanConverter;
import com.jerolba.carpet.impl.read.converter.ToDoubleConverter;
import com.jerolba.carpet.impl.read.converter.ToFloatConverter;
import com.jerolba.carpet.impl.read.converter.ToIntegerConverter;
import com.jerolba.carpet.impl.read.converter.ToLongConverter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class CarpetGroupAsMapConverter
extends GroupConverter {
    private final Converter[] converters;
    private final Consumer<Object> groupConsumer;
    private final Class<?> mapClass;
    private final GroupMapHolder mapHolder;

    public CarpetGroupAsMapConverter(Class<?> mapClass, GroupType schema, Consumer<Object> groupConsumer) {
        this.mapClass = mapClass;
        this.groupConsumer = groupConsumer;
        this.mapHolder = CarpetGroupAsMapConverter.crateGroupMapHolder(mapClass, schema);
        this.converters = new Converter[schema.getFields().size()];
        int cont = 0;
        for (Type schemaField : schema.getFields()) {
            this.converters[cont] = this.converterFor(cont, schemaField, this.mapHolder);
            ++cont;
        }
    }

    private Converter converterFor(int idx, Type schemaField, GroupMapHolder mapHolder) {
        String name = schemaField.getName();
        Consumer<Object> consumer = value -> mapHolder.add(idx, name, value);
        if (schemaField.isRepetition(Type.Repetition.REPEATED)) {
            return this.createSingleLevelConverter(idx, name, schemaField, mapHolder);
        }
        if (schemaField.isPrimitive()) {
            return CarpetGroupAsMapConverter.buildConverters(schemaField, consumer);
        }
        GroupType asGroupType = schemaField.asGroupType();
        LogicalTypeAnnotation logicalType = asGroupType.getLogicalTypeAnnotation();
        if (LogicalTypeAnnotation.listType().equals((Object)logicalType)) {
            return new CarpetListAsMapConverter(this.mapClass, asGroupType, consumer);
        }
        if (LogicalTypeAnnotation.mapType().equals((Object)logicalType)) {
            return new CarpetMapAsMapConverter(this.mapClass, asGroupType, consumer);
        }
        return new CarpetGroupAsMapConverter(this.mapClass, asGroupType, consumer);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
        this.mapHolder.create();
    }

    public void end() {
        this.groupConsumer.accept(this.mapHolder.getMap());
    }

    private static Converter buildConverters(Type parquetField, Consumer<Object> consumer) {
        Converter fromLogicalType = LogicalTypeConverters.buildFromLogicalTypeConverter(null, parquetField, consumer);
        if (fromLogicalType != null) {
            return fromLogicalType;
        }
        PrimitiveType.PrimitiveTypeName type = parquetField.asPrimitiveType().getPrimitiveTypeName();
        return switch (type) {
            case PrimitiveType.PrimitiveTypeName.INT32 -> new ToIntegerConverter(consumer);
            case PrimitiveType.PrimitiveTypeName.INT64 -> new ToLongConverter(consumer);
            case PrimitiveType.PrimitiveTypeName.FLOAT -> new ToFloatConverter(consumer);
            case PrimitiveType.PrimitiveTypeName.DOUBLE -> new ToDoubleConverter(consumer);
            case PrimitiveType.PrimitiveTypeName.BOOLEAN -> new BooleanConverter(consumer);
            default -> throw new RecordTypeConversionException(type + " deserialization not supported");
        };
    }

    private Converter createSingleLevelConverter(int idx, String name, Type parquetField, GroupMapHolder mapHolder) {
        Consumer<Object> consumer = v -> mapHolder.getList(idx, name).add(v);
        if (parquetField.isPrimitive()) {
            return CarpetGroupAsMapConverter.buildConverters(parquetField, consumer);
        }
        GroupType asGroupType = parquetField.asGroupType();
        if (LogicalTypeAnnotation.mapType().equals((Object)asGroupType.getLogicalTypeAnnotation())) {
            return new CarpetMapAsMapConverter(this.mapClass, asGroupType, consumer);
        }
        return new CarpetGroupAsMapConverter(this.mapClass, asGroupType, consumer);
    }

    private static Converter createCollectionConverter(Class<?> mapClass, Type listElement, Consumer<Object> consumer) {
        if (listElement.isPrimitive()) {
            return CarpetGroupAsMapConverter.buildConverters(listElement, consumer);
        }
        GroupType groupType = listElement.asGroupType();
        LogicalTypeAnnotation logicalType = listElement.getLogicalTypeAnnotation();
        if (logicalType != null) {
            if (LogicalTypeAnnotation.listType().equals((Object)logicalType)) {
                return new CarpetListAsMapConverter(mapClass, groupType, consumer);
            }
            if (LogicalTypeAnnotation.mapType().equals((Object)logicalType)) {
                return new CarpetMapAsMapConverter(mapClass, groupType, consumer);
            }
        }
        return new CarpetGroupAsMapConverter(mapClass, groupType, consumer);
    }

    private static GroupMapHolder crateGroupMapHolder(Class<?> mapClass, GroupType schema) {
        if (mapClass.equals(Map.class)) {
            Map<String, Integer> indexByName = CarpetGroupAsMapConverter.getSchemaFields(schema);
            return new CarpetGroupMapHolder(() -> new CarpetGroupMap(indexByName));
        }
        if (Map.class.isAssignableFrom(mapClass)) {
            Supplier<Map<String, Object>> constructor = null;
            constructor = mapClass.equals(HashMap.class) ? HashMap::new : (mapClass.equals(LinkedHashMap.class) ? LinkedHashMap::new : (mapClass.equals(TreeMap.class) ? TreeMap::new : ReadReflection.getDefaultConstructor(mapClass)));
            return new SimpleMapHolder(constructor);
        }
        Map<String, Integer> indexByName = CarpetGroupAsMapConverter.getSchemaFields(schema);
        return new CarpetGroupMapHolder(() -> new CarpetGroupMap(indexByName));
    }

    private static Map<String, Integer> getSchemaFields(GroupType schema) {
        List fields = schema.getFields();
        LinkedHashMap<String, Integer> indexByName = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < fields.size(); ++i) {
            indexByName.put(((Type)fields.get(i)).getName(), i);
        }
        return indexByName;
    }

    static interface GroupMapHolder {
        public void create();

        public void add(int var1, String var2, Object var3);

        public Map<String, Object> getMap();

        public Collection<Object> getList(int var1, String var2);
    }

    private static class CarpetListAsMapConverter
    extends GroupConverter {
        private final Consumer<Object> groupConsumer;
        private final CollectionHolder collectionHolder;
        private final Converter converter;

        CarpetListAsMapConverter(Class<?> mapClass, GroupType schema, Consumer<Object> consumer) {
            this.groupConsumer = consumer;
            this.collectionHolder = new CollectionHolder(ArrayList::new);
            Type listChild = (Type)schema.getFields().get(0);
            boolean threeLevel = SchemaValidation.isThreeLevel(listChild);
            this.converter = threeLevel ? new CarpetListAsMapIntermediateConverter(mapClass, listChild, this.collectionHolder) : CarpetGroupAsMapConverter.createCollectionConverter(mapClass, listChild, this.collectionHolder::add);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.collectionHolder.create();
        }

        public void end() {
            this.groupConsumer.accept(this.collectionHolder.getCollection());
        }
    }

    private static class CarpetMapAsMapConverter
    extends GroupConverter {
        private final Consumer<Object> consumer;
        private final Converter converter;
        private final MapHolder mapHolder;

        CarpetMapAsMapConverter(Class<?> mapClass, GroupType schema, Consumer<Object> consumer) {
            this.consumer = consumer;
            this.mapHolder = new MapHolder(HashMap::new);
            List fields = schema.getFields();
            if (fields.size() > 1) {
                throw new RecordTypeConversionException(schema.getName() + " MAP can not have more than one field");
            }
            GroupType mapChild = ((Type)fields.get(0)).asGroupType();
            this.converter = new CarpetMapAsMapIntermediateConverter(mapClass, mapChild, this.mapHolder);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.mapHolder.create();
        }

        public void end() {
            this.consumer.accept(this.mapHolder.getMap());
        }
    }

    private static class CarpetGroupMapHolder
    implements GroupMapHolder {
        private final Supplier<CarpetGroupMap<String, Object>> mapFactory;
        private CarpetGroupMap<String, Object> map;

        CarpetGroupMapHolder(Supplier<CarpetGroupMap<String, Object>> mapFactory) {
            this.mapFactory = mapFactory;
        }

        @Override
        public void create() {
            this.map = this.mapFactory.get();
        }

        @Override
        public void add(int idx, String name, Object value) {
            this.map.add(idx, value);
        }

        @Override
        public Map<String, Object> getMap() {
            return this.map;
        }

        @Override
        public Collection<Object> getList(int idx, String name) {
            ArrayList list = (ArrayList)this.map.getValue(idx);
            if (list == null) {
                list = new ArrayList();
                this.map.add(idx, list);
            }
            return list;
        }
    }

    private static class SimpleMapHolder
    implements GroupMapHolder {
        private final Supplier<Map<String, Object>> mapFactory;
        private Map<String, Object> map;

        SimpleMapHolder(Supplier<Map<String, Object>> mapFactory) {
            this.mapFactory = mapFactory;
        }

        @Override
        public void create() {
            this.map = this.mapFactory.get();
        }

        @Override
        public void add(int idx, String name, Object value) {
            this.map.put(name, value);
        }

        @Override
        public Map<String, Object> getMap() {
            return this.map;
        }

        @Override
        public Collection<Object> getList(int idx, String name) {
            return (Collection)this.map.computeIfAbsent(name, n -> new ArrayList());
        }
    }

    private static class CarpetGroupMap<K, V>
    implements Map<K, V> {
        private final Map<K, Integer> index;
        private final Object[] values;

        CarpetGroupMap(Map<K, Integer> index) {
            this.index = index;
            this.values = new Object[index.size()];
        }

        void add(int idx, Object value) {
            this.values[idx] = value;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.index.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            Objects.requireNonNull(value);
            for (int i = 0; i < this.values.length; ++i) {
                if (!value.equals(this.values[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public V get(Object key) {
            Integer idx = this.index.get(key);
            if (idx != null) {
                return this.getValue(idx);
            }
            return null;
        }

        public V getValue(int idx) {
            return (V)this.values[idx];
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            return this.index.keySet();
        }

        @Override
        public Collection<V> values() {
            return Arrays.asList(this.values);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.index.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), this.values[(Integer)e.getValue()])).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map m = (Map)o;
            if (m.size() != this.size()) {
                return false;
            }
            try {
                for (Map.Entry<K, Integer> e : this.index.entrySet()) {
                    K key = e.getKey();
                    Integer idx = e.getValue();
                    V value = this.getValue(idx);
                    if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                    return false;
                }
            }
            catch (ClassCastException | NullPointerException unused) {
                return false;
            }
            return true;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "{}";
            }
            Iterator<Map.Entry<K, Integer>> i = this.index.entrySet().iterator();
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            while (true) {
                Map.Entry<K, Integer> e = i.next();
                K key = e.getKey();
                Integer idx = e.getValue();
                V value = this.getValue(idx);
                sb.append((Object)(key == this ? "(this Map)" : key));
                sb.append('=');
                sb.append((Object)(value == this ? "(this Map)" : value));
                if (!i.hasNext()) {
                    return sb.append('}').toString();
                }
                sb.append(',').append(' ');
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry<K, V> entry : this.entrySet()) {
                h += entry.hashCode();
            }
            return h;
        }
    }

    private static class CarpetMapAsMapIntermediateConverter
    extends GroupConverter {
        private final Converter converterValue;
        private final Converter converterKey;
        private final MapHolder mapHolder;
        private Object elementValue;
        private Object elementKey;

        CarpetMapAsMapIntermediateConverter(Class<?> mapClass, GroupType schema, MapHolder mapHolder) {
            this.mapHolder = mapHolder;
            List fields = schema.getFields();
            if (fields.size() != 2) {
                throw new RecordTypeConversionException(schema.getName() + " MAP child element must have two fields");
            }
            Type mapKeyType = (Type)fields.get(0);
            this.converterKey = mapKeyType.isPrimitive() ? CarpetGroupAsMapConverter.buildConverters(mapKeyType, this::consumeKey) : new CarpetGroupAsMapConverter(mapClass, mapKeyType.asGroupType(), this::consumeKey);
            Type mapValueType = (Type)fields.get(1);
            if (mapValueType.isPrimitive()) {
                this.converterValue = CarpetGroupAsMapConverter.buildConverters(mapValueType, this::consumeValue);
            } else {
                LogicalTypeAnnotation logicalType = mapValueType.getLogicalTypeAnnotation();
                GroupType groupType = mapValueType.asGroupType();
                this.converterValue = LogicalTypeAnnotation.listType().equals((Object)logicalType) ? new CarpetListAsMapConverter(mapClass, groupType, this::consumeValue) : (LogicalTypeAnnotation.mapType().equals((Object)logicalType) ? new CarpetMapAsMapConverter(mapClass, groupType, this::consumeValue) : new CarpetGroupAsMapConverter(mapClass, groupType, this::consumeValue));
            }
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return this.converterKey;
            }
            return this.converterValue;
        }

        public void start() {
            this.elementKey = null;
            this.elementValue = null;
        }

        public void end() {
            this.mapHolder.put(this.elementKey, this.elementValue);
        }

        private void consumeKey(Object value) {
            this.elementKey = value;
        }

        private void consumeValue(Object value) {
            this.elementValue = value;
        }
    }

    private static class CarpetListAsMapIntermediateConverter
    extends GroupConverter {
        private final CollectionHolder collectionHolder;
        private final Converter converter;
        private Object elementValue;

        CarpetListAsMapIntermediateConverter(Class<?> mapClass, Type rootListType, CollectionHolder collectionHolder) {
            this.collectionHolder = collectionHolder;
            List fields = rootListType.asGroupType().getFields();
            this.converter = CarpetGroupAsMapConverter.createCollectionConverter(mapClass, (Type)fields.get(0), value -> {
                this.elementValue = value;
            });
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.elementValue = null;
        }

        public void end() {
            this.collectionHolder.add(this.elementValue);
        }
    }
}

