/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.read.converter.DecimalConverter;
import com.jerolba.carpet.impl.read.converter.EnumConverter;
import com.jerolba.carpet.impl.read.converter.InstantConverter;
import com.jerolba.carpet.impl.read.converter.LocalDateConverter;
import com.jerolba.carpet.impl.read.converter.LocalDateTimeConverter;
import com.jerolba.carpet.impl.read.converter.LocalTimeConverter;
import com.jerolba.carpet.impl.read.converter.StringConverter;
import com.jerolba.carpet.impl.read.converter.ToByteConverter;
import com.jerolba.carpet.impl.read.converter.ToShortConverter;
import com.jerolba.carpet.impl.read.converter.UuidToStringConverter;
import com.jerolba.carpet.impl.read.converter.UuidToUuidConverter;
import java.util.function.Consumer;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class LogicalTypeConverters {
    LogicalTypeConverters() {
    }

    public static Converter buildFromLogicalTypeConverter(JavaType type, Type parquetField, Consumer<Object> consumer) {
        LogicalTypeAnnotation logicalTypeAnnotation = parquetField.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation == null) {
            return null;
        }
        PrimitiveType primitiveType = parquetField.asPrimitiveType();
        PrimitiveType.PrimitiveTypeName primitiveTypeName = parquetField.asPrimitiveType().getPrimitiveTypeName();
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.stringType())) {
            if (type == null || type.isString()) {
                return new StringConverter(consumer);
            }
            if (type.isEnum()) {
                return new EnumConverter(consumer, type.getJavaType());
            }
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.enumType())) {
            if (type == null || type.isString()) {
                return new StringConverter(consumer);
            }
            if (type.isEnum()) {
                return new EnumConverter(consumer, type.getJavaType());
            }
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
            if (intType.getBitWidth() == 8 && (type == null || type.isByte())) {
                return new ToByteConverter(consumer);
            }
            if (intType.getBitWidth() == 16 && (type == null || type.isShort())) {
                return new ToShortConverter(consumer);
            }
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.uuidType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            if (type == null || type.isUuid()) {
                return new UuidToUuidConverter(consumer);
            }
            if (type.isString()) {
                return new UuidToStringConverter(consumer);
            }
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.dateType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 && (type == null || type.isLocalDate())) {
            return new LocalDateConverter(consumer);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimeLogicalTypeAnnotation time = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalTypeAnnotation;
            if (!(primitiveTypeName != PrimitiveType.PrimitiveTypeName.INT32 && primitiveTypeName != PrimitiveType.PrimitiveTypeName.INT64 || type != null && !type.isLocalTime())) {
                return new LocalTimeConverter(consumer, time.getUnit());
            }
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStamp = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
            if (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64) {
                if (type == null) {
                    if (timeStamp.isAdjustedToUTC()) {
                        return new InstantConverter(consumer, timeStamp.getUnit());
                    }
                    return new LocalDateTimeConverter(consumer, timeStamp.getUnit());
                }
                if (type.isLocalDateTime()) {
                    return new LocalDateTimeConverter(consumer, timeStamp.getUnit());
                }
                if (type.isInstant()) {
                    return new InstantConverter(consumer, timeStamp.getUnit());
                }
            }
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
            if (type == null || type.isBigDecimal()) {
                return new DecimalConverter(consumer, primitiveType.getPrimitiveTypeName(), decimalType.getScale());
            }
        }
        return null;
    }
}

