/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.read.LogicalTypeConverters;
import com.jerolba.carpet.impl.read.converter.BooleanConverter;
import com.jerolba.carpet.impl.read.converter.ToByteConverter;
import com.jerolba.carpet.impl.read.converter.ToDoubleConverter;
import com.jerolba.carpet.impl.read.converter.ToFloatConverter;
import com.jerolba.carpet.impl.read.converter.ToIntegerConverter;
import com.jerolba.carpet.impl.read.converter.ToLongConverter;
import com.jerolba.carpet.impl.read.converter.ToShortConverter;
import java.util.function.Consumer;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class PrimitiveConverterFactory {
    PrimitiveConverterFactory() {
    }

    public static Converter buildPrimitiveConverter(Type parquetField, Class<?> genericJavaType, Consumer<Object> consumer) {
        JavaType javaType = new JavaType(genericJavaType);
        Converter fromLogicalType = LogicalTypeConverters.buildFromLogicalTypeConverter(javaType, parquetField, consumer);
        if (fromLogicalType != null) {
            return fromLogicalType;
        }
        PrimitiveType.PrimitiveTypeName type = parquetField.asPrimitiveType().getPrimitiveTypeName();
        Converter converter = switch (type) {
            case PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64 -> PrimitiveConverterFactory.buildFromIntConverter(consumer, javaType);
            case PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE -> PrimitiveConverterFactory.buildFromDecimalConverter(consumer, javaType);
            case PrimitiveType.PrimitiveTypeName.BOOLEAN -> PrimitiveConverterFactory.buildFromBooleanConverter(consumer, javaType);
            default -> throw new RecordTypeConversionException(type + " deserialization not supported");
        };
        if (converter == null) {
            throw new RecordTypeConversionException(genericJavaType.getTypeName() + " not compatible with " + parquetField.getName());
        }
        return converter;
    }

    private static Converter buildFromIntConverter(Consumer<Object> consumer, JavaType type) {
        if (type.isInteger()) {
            return new ToIntegerConverter(consumer);
        }
        if (type.isLong()) {
            return new ToLongConverter(consumer);
        }
        if (type.isShort()) {
            return new ToShortConverter(consumer);
        }
        if (type.isByte()) {
            return new ToByteConverter(consumer);
        }
        if (type.isDouble()) {
            return new ToDoubleConverter(consumer);
        }
        if (type.isFloat()) {
            return new ToFloatConverter(consumer);
        }
        return null;
    }

    private static Converter buildFromDecimalConverter(Consumer<Object> consumer, JavaType type) {
        if (type.isFloat()) {
            return new ToFloatConverter(consumer);
        }
        if (type.isDouble()) {
            return new ToDoubleConverter(consumer);
        }
        return null;
    }

    private static Converter buildFromBooleanConverter(Consumer<Object> consumer, JavaType type) {
        if (type.isBoolean()) {
            return new BooleanConverter(consumer);
        }
        return null;
    }
}

