/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ReadReflection {
    public static Supplier<Collection<Object>> collectionFactory(Class<?> type) {
        if (Set.class.isAssignableFrom(type)) {
            if (type.equals(Set.class)) {
                return HashSet::new;
            }
            if (type.equals(HashSet.class)) {
                return HashSet::new;
            }
            if (type.equals(LinkedHashSet.class)) {
                return LinkedHashSet::new;
            }
            return ReadReflection.getDefaultConstructor(type);
        }
        if (List.class.isAssignableFrom(type)) {
            if (type.equals(List.class)) {
                return ArrayList::new;
            }
            if (type.equals(LinkedList.class)) {
                return LinkedList::new;
            }
            return ReadReflection.getDefaultConstructor(type);
        }
        return ArrayList::new;
    }

    public static Supplier<Map<Object, Object>> mapFactory(Class<?> type) {
        if (Map.class.isAssignableFrom(type)) {
            if (type.equals(Map.class)) {
                return HashMap::new;
            }
            if (type.equals(LinkedHashMap.class)) {
                return LinkedHashMap::new;
            }
            if (type.equals(TreeMap.class)) {
                return TreeMap::new;
            }
            return ReadReflection.getDefaultConstructor(type);
        }
        return HashMap::new;
    }

    public static <T> Supplier<T> getDefaultConstructor(Class<?> type) {
        try {
            Constructor<?> constructor = type.getConstructor(new Class[0]);
            return () -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(type + " class can not be instantiated", e);
                }
            };
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(type + " class doesn't have an empty constructor", e);
        }
    }

    public static class ConstructorParams {
        private final Constructor<?> constructor;
        private final Object[] defaultParamsValues;
        private final Object[] c;

        public ConstructorParams(Class<?> recordClass) {
            this.constructor = ConstructorParams.findConstructor(recordClass);
            RecordComponent[] components = recordClass.getRecordComponents();
            this.defaultParamsValues = this.createDefaultConstructorParams(components);
            this.c = new Object[components.length];
        }

        public Object create() {
            try {
                return this.constructor.newInstance(this.c);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public void set(int idx, Object value) {
            this.c[idx] = value;
        }

        public Object get(int idx) {
            return this.c[idx];
        }

        public void resetParams() {
            System.arraycopy(this.defaultParamsValues, 0, this.c, 0, this.defaultParamsValues.length);
        }

        private Object[] createDefaultConstructorParams(RecordComponent[] components) {
            Object[] defaultParams = new Object[components.length];
            for (int i = 0; i < components.length; ++i) {
                defaultParams[i] = null;
                Class<?> type = components[i].getType();
                if (!type.isPrimitive()) continue;
                defaultParams[i] = ConstructorParams.getMissingParquetAttr(type);
            }
            return defaultParams;
        }

        private static Object getMissingParquetAttr(Class<?> type) {
            return switch (type.getName()) {
                case "byte" -> (byte)0;
                case "short" -> (short)0;
                case "int" -> 0;
                case "long" -> 0L;
                case "double" -> 0.0;
                case "float" -> Float.valueOf(0.0f);
                case "boolean" -> Boolean.valueOf(false);
                default -> null;
            };
        }

        private static Constructor<?> findConstructor(Class<?> recordClass) {
            Constructor<?>[] declaredConstructors;
            Object[] componentsTypes = Stream.of(recordClass.getRecordComponents()).map(RecordComponent::getType).toArray();
            for (Constructor<?> c : declaredConstructors = recordClass.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = c.getParameterTypes();
                if (!Arrays.equals(componentsTypes, parameterTypes, (c1, c2) -> c1.equals(c2) ? 0 : 1)) continue;
                c.setAccessible(true);
                return c;
            }
            throw new RuntimeException(recordClass.getName() + " record has an invalid constructor");
        }
    }
}

