/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import com.jerolba.carpet.impl.read.ColumnPath;
import com.jerolba.carpet.impl.read.ColumnToFieldMapper;
import com.jerolba.carpet.impl.read.SchemaValidation;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class SchemaFilter {
    private final SchemaValidation validation;
    private final ColumnToFieldMapper columnToFieldMapper;

    public SchemaFilter(SchemaValidation validation, ColumnToFieldMapper columnToFieldMapper) {
        this.validation = validation;
        this.columnToFieldMapper = columnToFieldMapper;
    }

    public MessageType project(Class<?> readClass, GroupType schema) {
        if (Map.class.isAssignableFrom(readClass)) {
            return new MessageType(schema.getName(), schema.getFields());
        }
        ColumnPath path = new ColumnPath();
        GroupType projected = this.filter(readClass, path, schema);
        return new MessageType(projected.getName(), projected.getFields());
    }

    private GroupType filter(Class<?> readClass, ColumnPath path, GroupType schema) {
        if (!readClass.isRecord()) {
            throw new RecordTypeConversionException(readClass.getName() + " is not a Java Record");
        }
        Map<String, ColumnToFieldMapper.NameMap> mapFields = this.columnToFieldMapper.mapFields(schema, readClass.getRecordComponents());
        HashMap<String, Object> inProjection = new HashMap<String, Object>();
        for (RecordComponent recordComponent : readClass.getRecordComponents()) {
            Type type;
            Object parameterized;
            ColumnToFieldMapper.NameMap nameMap = mapFields.get(recordComponent.getName());
            if (nameMap == null) {
                this.validation.validateMissingColumn(readClass, recordComponent.getName());
                continue;
            }
            Type parquetType = nameMap.parquetType();
            String parquetFieldName = parquetType.getName();
            ColumnPath column = path.add(readClass, recordComponent.getName(), parquetFieldName);
            if (parquetType.isRepetition(Type.Repetition.REPEATED)) {
                Type type2 = this.analyzeOneLevelStructure(column, recordComponent, parquetType, parquetFieldName);
                inProjection.put(parquetFieldName, type2);
                continue;
            }
            if (parquetType.isPrimitive()) {
                PrimitiveType primitiveType = parquetType.asPrimitiveType();
                this.validation.validatePrimitiveCompatibility(primitiveType, recordComponent.getType());
                this.validation.validateNullability((Type)primitiveType, recordComponent);
                inProjection.put(parquetFieldName, parquetType);
                continue;
            }
            GroupType asGroupType = parquetType.asGroupType();
            LogicalTypeAnnotation typeAnnotation = parquetType.getLogicalTypeAnnotation();
            if (typeAnnotation == LogicalTypeAnnotation.listType()) {
                if (!Collection.class.isAssignableFrom(recordComponent.getType())) {
                    throw new RecordTypeConversionException("Field '" + parquetFieldName + "' is not a collection in '" + column.getClassName() + "' mapping column '" + column.path() + "'");
                }
                parameterized = Parameterized.getParameterizedCollection(recordComponent);
                type = this.analyzeMultipleLevelStructure(column, parquetFieldName, (ParameterizedCollection)parameterized, asGroupType);
                inProjection.put(parquetFieldName, type);
                continue;
            }
            if (typeAnnotation == LogicalTypeAnnotation.mapType()) {
                if (!Map.class.isAssignableFrom(recordComponent.getType())) {
                    throw new RecordTypeConversionException("Field '" + parquetFieldName + "' is not a map in '" + column.getClassName() + "' mapping column '" + column.path() + "'");
                }
                parameterized = Parameterized.getParameterizedMap(recordComponent);
                type = this.analizeMapStructure(column, parquetFieldName, (ParameterizedMap)parameterized, asGroupType);
                inProjection.put(parquetFieldName, type);
                continue;
            }
            if (recordComponent.getType().isRecord()) {
                this.validation.validateNullability(parquetType, recordComponent);
                GroupType recordSchema = this.filter(recordComponent.getType(), column, asGroupType);
                inProjection.put(parquetFieldName, recordSchema);
                continue;
            }
            if (Map.class.isAssignableFrom(recordComponent.getType())) {
                parameterized = Parameterized.getParameterizedMap(recordComponent);
                if (((ParameterizedMap)parameterized).getKeyActualType().equals(String.class)) {
                    if (((ParameterizedMap)parameterized).getValueActualType().equals(Object.class)) {
                        this.validation.validateNullability(parquetType, recordComponent);
                        inProjection.put(parquetFieldName, parquetType);
                        continue;
                    }
                    throw new RecordTypeConversionException("To map record to Map, values must be Object: Map<String, Object>");
                }
                throw new RecordTypeConversionException("To map record to Map, keys must be String: Map<String, Object>");
            }
            throw new RecordTypeConversionException(recordComponent.getType().getName() + " is not a Java Record");
        }
        List<Type> projection = schema.getFields().stream().filter(f -> inProjection.containsKey(f.getName())).map(f -> (Type)inProjection.get(f.getName())).toList();
        return new GroupType(schema.getRepetition(), schema.getName(), projection);
    }

    private Type analyzeOneLevelStructure(ColumnPath column, RecordComponent recordComponent, Type parquetType, String fieldName) {
        if (!Collection.class.isAssignableFrom(recordComponent.getType())) {
            throw new RecordTypeConversionException("Repeated field " + recordComponent.getName() + " of " + column.getClassName() + " is not a collection");
        }
        ParameterizedCollection parameterized = Parameterized.getParameterizedCollection(recordComponent);
        if (parameterized.isCollection()) {
            throw new RecordTypeConversionException("1-level collections can no embed nested collections (List<List<?>>)");
        }
        if (parameterized.isMap()) {
            ParameterizedMap parameterizedChild = parameterized.getParametizedAsMap();
            return this.analizeMapStructure(column, parquetType.getName(), parameterizedChild, parquetType.asGroupType());
        }
        if (parquetType.isPrimitive()) {
            PrimitiveType primitiveType = parquetType.asPrimitiveType();
            Class<?> actualCollectionType = parameterized.getActualType();
            this.validation.validatePrimitiveCompatibility(primitiveType, actualCollectionType);
            return parquetType;
        }
        GroupType asGroupType = parquetType.asGroupType();
        Class<?> actualCollectionType = parameterized.getActualType();
        if (actualCollectionType.isRecord()) {
            return this.filter(actualCollectionType, column, asGroupType);
        }
        throw new RecordTypeConversionException("Field " + fieldName + " of type " + actualCollectionType.getName() + " is not a basic type or a Java record");
    }

    private Type analyzeMultipleLevelStructure(ColumnPath column, String name, ParameterizedCollection parameterized, GroupType groupType) {
        if (groupType.getFieldCount() > 1) {
            throw new RecordTypeConversionException("Nestd list " + groupType.getName() + " must have only one item");
        }
        Type groupChild = (Type)groupType.getFields().get(0);
        if (!groupChild.isRepetition(Type.Repetition.REPEATED)) {
            throw new RecordTypeConversionException("Nestd list element " + groupChild.getName() + " must be REPEATED");
        }
        if (SchemaValidation.isThreeLevel(groupChild)) {
            GroupType listGroup = groupChild.asGroupType();
            Type childGroupChild = (Type)listGroup.getFields().get(0);
            return this.analyzeListLevelStructure(column, name, parameterized, groupType, listGroup, childGroupChild);
        }
        return this.analyzeListLevelStructure(column, name, parameterized, groupType, null, groupChild);
    }

    private Type analyzeListLevelStructure(ColumnPath column, String name, ParameterizedCollection parameterized, GroupType parentGroupType, GroupType listGroup, Type childElement) {
        if (parameterized.isCollection() || parameterized.isMap()) {
            LogicalTypeAnnotation typeAnnotation = childElement.getLogicalTypeAnnotation();
            if (typeAnnotation == LogicalTypeAnnotation.listType()) {
                if (!parameterized.isCollection()) {
                    throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a collection");
                }
                ParameterizedCollection parameterizedChild = parameterized.getParametizedAsCollection();
                Type type = this.analyzeMultipleLevelStructure(column, name, parameterizedChild, childElement.asGroupType());
                Type filtered = this.rewrapListIfExists(listGroup, type);
                return parentGroupType.withNewFields(new Type[]{filtered});
            }
            if (typeAnnotation == LogicalTypeAnnotation.mapType()) {
                if (!parameterized.isMap()) {
                    throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a Map");
                }
                ParameterizedMap parameterizedChild = parameterized.getParametizedAsMap();
                Type type = this.analizeMapStructure(column, name, parameterizedChild, childElement.asGroupType());
                Type filtered = this.rewrapListIfExists(listGroup, type);
                return parentGroupType.withNewFields(new Type[]{filtered});
            }
            throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a collection");
        }
        if (childElement.isPrimitive()) {
            PrimitiveType primitiveType = childElement.asPrimitiveType();
            Class<?> actualCollectionType = parameterized.getActualType();
            this.validation.validatePrimitiveCompatibility(primitiveType, actualCollectionType);
            return parentGroupType;
        }
        Class<?> actualCollectionType = parameterized.getActualType();
        if (actualCollectionType.isRecord()) {
            GroupType childMapped = this.filter(actualCollectionType, column, childElement.asGroupType());
            Type listGroupMapped = this.rewrapListIfExists(listGroup, (Type)childMapped);
            return parentGroupType.withNewFields(new Type[]{listGroupMapped});
        }
        if (SchemaValidation.isBasicSupportedType(new JavaType(actualCollectionType)) && !childElement.isPrimitive()) {
            throw new RecordTypeConversionException(childElement.getName() + " is not compatible with " + actualCollectionType.getName());
        }
        throw new RecordTypeConversionException("Field " + name + " of type " + actualCollectionType.getName() + " is not a basic type or a Java record");
    }

    private Type rewrapListIfExists(GroupType listGroupRepeated, Type type) {
        if (listGroupRepeated == null) {
            return type;
        }
        return listGroupRepeated.withNewFields(new Type[]{type});
    }

    private Type analizeMapStructure(ColumnPath column, String name, ParameterizedMap parameterized, GroupType mapType) {
        if (!SchemaValidation.hasMapShape(mapType)) {
            throw new RecordTypeConversionException("Field " + mapType.getName() + " is not a valid map");
        }
        GroupType keyValueType = ((Type)mapType.getFields().get(0)).asGroupType();
        Type key = (Type)keyValueType.getFields().get(0);
        if (parameterized.keyIsCollection() || parameterized.keyIsMap()) {
            throw new RecordTypeConversionException("Maps and Collections can not be key of a Map");
        }
        Class<?> keyActualType = parameterized.getKeyActualType();
        if (key.isPrimitive()) {
            PrimitiveType primitiveType = key.asPrimitiveType();
            this.validation.validatePrimitiveCompatibility(primitiveType, keyActualType);
        } else if (keyActualType.isRecord()) {
            key = this.filter(keyActualType, column, key.asGroupType());
        } else {
            throw new RecordTypeConversionException(keyActualType.getName() + " is not a valid key for a Map");
        }
        Type value = (Type)keyValueType.getFields().get(1);
        if (parameterized.valueIsCollection() || parameterized.valueIsMap()) {
            LogicalTypeAnnotation typeAnnotation = value.getLogicalTypeAnnotation();
            if (LogicalTypeAnnotation.listType().equals((Object)typeAnnotation)) {
                if (!parameterized.valueIsCollection()) {
                    throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a collection");
                }
                ParameterizedCollection parameterizedChild = parameterized.getValueTypeAsCollection();
                value = this.analyzeMultipleLevelStructure(column, name, parameterizedChild, value.asGroupType());
            } else if (LogicalTypeAnnotation.mapType().equals((Object)typeAnnotation)) {
                if (!parameterized.valueIsMap()) {
                    throw new RecordTypeConversionException("Field " + name + " of " + column.getClassName() + " is not a map");
                }
                ParameterizedMap parameterizedChild = parameterized.getValueTypeAsMap();
                value = this.analizeMapStructure(column, name, parameterizedChild, value.asGroupType());
            }
        } else {
            Class<?> valueActualType = parameterized.getValueActualType();
            if (value.isPrimitive()) {
                this.validation.validatePrimitiveCompatibility(value.asPrimitiveType(), valueActualType);
            } else if (valueActualType.isRecord()) {
                value = this.filter(valueActualType, column, value.asGroupType());
            } else {
                throw new RecordTypeConversionException(valueActualType.getName() + " is not a valid key for a Map");
            }
        }
        GroupType keyValueRebuild = keyValueType.withNewFields(new Type[]{key, value});
        return mapType.withNewFields(new Type[]{keyValueRebuild});
    }
}

