/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.CarpetMissingColumnException;
import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.NotNullField;
import java.lang.reflect.RecordComponent;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class SchemaValidation {
    private static final LogicalTypeAnnotation.IntLogicalTypeAnnotation INT8 = LogicalTypeAnnotation.intType((int)8, (boolean)true);
    private static final LogicalTypeAnnotation.IntLogicalTypeAnnotation INT16 = LogicalTypeAnnotation.intType((int)16, (boolean)true);
    private final boolean failNarrowingPrimitiveConversion;
    private final boolean failOnMissingColumn;
    private final boolean failOnNullForPrimitives;

    public SchemaValidation(boolean failOnMissingColumn, boolean failNarrowingPrimitiveConversion, boolean failOnNullForPrimitives) {
        this.failOnMissingColumn = failOnMissingColumn;
        this.failNarrowingPrimitiveConversion = failNarrowingPrimitiveConversion;
        this.failOnNullForPrimitives = failOnNullForPrimitives;
    }

    public boolean validateMissingColumn(Class<?> clazz, String fieldName) {
        if (this.failOnMissingColumn) {
            throw new CarpetMissingColumnException("Field '" + fieldName + "' from class '" + clazz.getName() + "' not present in parquet schema");
        }
        return true;
    }

    public boolean validatePrimitiveCompatibility(PrimitiveType primitiveType, Class<?> javaType) {
        boolean valid;
        JavaType type = new JavaType(javaType);
        LogicalTypeAnnotation logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation != null && this.validLogicalTypeAnnotation(primitiveType, type)) {
            return true;
        }
        switch (primitiveType.getPrimitiveTypeName()) {
            case INT32: {
                boolean bl = this.validInt32Source(type);
                break;
            }
            case INT64: {
                boolean bl = this.validInt64Source(type);
                break;
            }
            case FLOAT: {
                boolean bl = this.validFloatSource(type);
                break;
            }
            case DOUBLE: {
                boolean bl = this.validDoubleSource(type);
                break;
            }
            case BOOLEAN: {
                boolean bl = this.validBooleanSource(type);
                break;
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: 
            case INT96: {
                throw new RecordTypeConversionException(type + " deserialization not supported");
            }
            default: {
                boolean bl = valid = false;
            }
        }
        if (!valid) {
            return this.throwInvalidConversionException(primitiveType, type);
        }
        return valid;
    }

    public boolean validateNullability(Type parquetType, RecordComponent recordComponent) {
        boolean isNotNull;
        if (this.failOnNullForPrimitives && (isNotNull = NotNullField.isNotNull(recordComponent)) && parquetType.getRepetition() == Type.Repetition.OPTIONAL) {
            Class<?> type = recordComponent.getType();
            throw new RecordTypeConversionException("\"" + parquetType.getName() + "\" (" + type.getName() + ") on class \"" + recordComponent.getDeclaringRecord().getName() + "\" can not be null");
        }
        return true;
    }

    private boolean validInt32Source(JavaType type) {
        if (type.isInteger() || type.isLong() || type.isDouble()) {
            return true;
        }
        if (!this.failNarrowingPrimitiveConversion) {
            return type.isFloat() || type.isShort() || type.isByte();
        }
        return false;
    }

    private boolean validInt64Source(JavaType type) {
        if (type.isLong()) {
            return true;
        }
        if (!this.failNarrowingPrimitiveConversion) {
            return type.isInteger() || type.isDouble() || type.isFloat() || type.isShort() || type.isByte();
        }
        return false;
    }

    private boolean validFloatSource(JavaType type) {
        if (type.isDouble() || type.isFloat()) {
            return true;
        }
        if (!this.failNarrowingPrimitiveConversion) {
            // empty if block
        }
        return false;
    }

    private boolean validDoubleSource(JavaType type) {
        if (type.isDouble()) {
            return true;
        }
        if (!this.failNarrowingPrimitiveConversion) {
            return type.isFloat();
        }
        return false;
    }

    private boolean validBooleanSource(JavaType type) {
        return type.isBoolean();
    }

    public static boolean isBasicSupportedType(JavaType type) {
        return type.isInteger() || type.isLong() || type.isDouble() || type.isFloat() || type.isBoolean() || type.isShort() || type.isByte() || type.isEnum();
    }

    private boolean validLogicalTypeAnnotation(PrimitiveType primitiveType, JavaType type) {
        LogicalTypeAnnotation logicalType = primitiveType.getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName name = primitiveType.getPrimitiveTypeName();
        if (LogicalTypeAnnotation.stringType().equals((Object)logicalType) && (type.isString() || type.isEnum())) {
            return name == PrimitiveType.PrimitiveTypeName.BINARY;
        }
        if (LogicalTypeAnnotation.enumType().equals((Object)logicalType) && (type.isString() || type.isEnum())) {
            return name == PrimitiveType.PrimitiveTypeName.BINARY;
        }
        if (logicalType.equals(LogicalTypeAnnotation.uuidType()) && (type.isString() || type.isUuid())) {
            return name == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
        }
        if (logicalType.equals(INT16) && type.isShort()) {
            return name == PrimitiveType.PrimitiveTypeName.INT32;
        }
        if (type.isByte() && logicalType.equals(INT8)) {
            return name == PrimitiveType.PrimitiveTypeName.INT32;
        }
        if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && type.isBigDecimal()) {
            return name == PrimitiveType.PrimitiveTypeName.INT32 || name == PrimitiveType.PrimitiveTypeName.INT64 || name == PrimitiveType.PrimitiveTypeName.BINARY || name == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
        }
        if (type.isLocalDate() && logicalType.equals(LogicalTypeAnnotation.dateType())) {
            return name == PrimitiveType.PrimitiveTypeName.INT32;
        }
        if (type.isLocalTime() && logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimeLogicalTypeAnnotation time = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalType;
            if (time.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                return name == PrimitiveType.PrimitiveTypeName.INT32;
            }
            if (time.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS || time.getUnit() == LogicalTypeAnnotation.TimeUnit.NANOS) {
                return name == PrimitiveType.PrimitiveTypeName.INT64;
            }
        }
        if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStamp = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
            if (type.isLocalDateTime() || type.isInstant()) {
                return name == PrimitiveType.PrimitiveTypeName.INT64;
            }
        }
        return false;
    }

    private boolean throwInvalidConversionException(PrimitiveType primitiveType, JavaType type) {
        throw new RecordTypeConversionException(primitiveType.getPrimitiveTypeName().name() + " (" + primitiveType.getName() + ") can not be converted to " + type.getTypeName());
    }

    public static boolean isThreeLevel(Type child) {
        return SchemaValidation.isCompliantThreeLevelWith(child, "element") || SchemaValidation.isCompliantThreeLevelWith(child, "item");
    }

    public static boolean isCompliantThreeLevelWith(Type child, String elementName) {
        if (child.isPrimitive()) {
            return false;
        }
        GroupType asGroup = child.asGroupType();
        if (!asGroup.getName().equals("list")) {
            return false;
        }
        if (asGroup.getFieldCount() > 1) {
            return false;
        }
        Type grandChild = (Type)asGroup.getFields().get(0);
        return grandChild.getName().equals(elementName);
    }

    public static boolean hasMapShape(GroupType rootGroup) {
        if (rootGroup.getFieldCount() != 1) {
            return false;
        }
        Type keyValueType = (Type)rootGroup.getFields().get(0);
        if (!keyValueType.isRepetition(Type.Repetition.REPEATED)) {
            return false;
        }
        if (keyValueType.isPrimitive()) {
            return false;
        }
        GroupType keyValueGroup = keyValueType.asGroupType();
        if (keyValueGroup.getFieldCount() != 2) {
            return false;
        }
        Type key = (Type)keyValueGroup.getFields().get(0);
        return key.isRepetition(Type.Repetition.REQUIRED);
    }
}

