/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.AliasField;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.CollectionsWriters;
import com.jerolba.carpet.impl.write.FieldWriterConsumer;
import com.jerolba.carpet.impl.write.FieldsWriter;
import com.jerolba.carpet.impl.write.RecordField;
import com.jerolba.carpet.impl.write.ReflectionRecordField;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.parquet.io.api.RecordConsumer;

class CarpetRecordWriter {
    private final RecordConsumer recordConsumer;
    private final CarpetWriteConfiguration carpetConfiguration;
    private final List<Consumer<Object>> fieldWriters = new ArrayList<Consumer<Object>>();

    public CarpetRecordWriter(RecordConsumer recordConsumer, Class<?> recordClass, CarpetWriteConfiguration carpetConfiguration) {
        this.recordConsumer = recordConsumer;
        this.carpetConfiguration = carpetConfiguration;
        int idx = 0;
        for (RecordComponent attr : recordClass.getRecordComponents()) {
            ReflectionRecordField f = new ReflectionRecordField(recordClass, attr, AliasField.getFieldName(attr), idx);
            Class<?> type = attr.getType();
            Consumer<Object> writer = null;
            BiConsumer<RecordConsumer, Object> basicTypeWriter = FieldsWriter.buildSimpleElementConsumer(type, recordConsumer, carpetConfiguration);
            if (basicTypeWriter != null) {
                writer = new FieldWriterConsumer(recordConsumer, f, basicTypeWriter);
            } else if (Collection.class.isAssignableFrom(type)) {
                ParameterizedCollection collectionClass = Parameterized.getParameterizedCollection(attr);
                writer = this.createCollectionWriter(collectionClass, f);
            } else if (Map.class.isAssignableFrom(type)) {
                ParameterizedMap mapClass = Parameterized.getParameterizedMap(attr);
                writer = this.createMapStructureWriter(mapClass, f);
            } else {
                throw new RuntimeException(type.getName() + " can not be serialized");
            }
            this.fieldWriters.add(writer);
            ++idx;
        }
    }

    public void write(Object record) {
        for (Consumer<Object> fieldWriter : this.fieldWriters) {
            fieldWriter.accept(record);
        }
    }

    private Consumer<Object> createCollectionWriter(ParameterizedCollection collectionClass, RecordField f) {
        return switch (this.carpetConfiguration.annotatedLevels()) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotatedLevels.ONE -> this.createOneLevelStructureWriter(collectionClass, f);
            case AnnotatedLevels.TWO -> this.createTwoLevelStructureWriter(collectionClass, f);
            case AnnotatedLevels.THREE -> this.createThreeLevelStructureWriter(collectionClass, f);
        };
    }

    private Consumer<Object> createOneLevelStructureWriter(ParameterizedCollection parametized, RecordField field) {
        if (parametized.isCollection()) {
            throw new RecordTypeConversionException("Nested collection in a collection is not supported in single level structure codification");
        }
        BiConsumer<RecordConsumer, Object> elemConsumer = null;
        if (parametized.isMap()) {
            ParameterizedMap parametizedChild = parametized.getParametizedAsMap();
            Consumer<Object> childWriter = this.createMapStructureWriter(parametizedChild, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            Class<?> type = parametized.getActualType();
            elemConsumer = FieldsWriter.buildSimpleElementConsumer(type, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        return new CollectionsWriters.OneLevelCollectionFieldWriter(this.recordConsumer, field, elemConsumer);
    }

    private Consumer<Object> createTwoLevelStructureWriter(ParameterizedCollection parametized, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemConsumer = null;
        if (parametized.isCollection()) {
            parametizedChild = parametized.getParametizedAsCollection();
            Consumer<Object> childWriter = this.createTwoLevelStructureWriter((ParameterizedCollection)parametizedChild, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else if (parametized.isMap()) {
            parametizedChild = parametized.getParametizedAsMap();
            Consumer<Object> childWriter = this.createMapStructureWriter((ParameterizedMap)parametizedChild, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            Class<?> type = parametized.getActualType();
            elemConsumer = FieldsWriter.buildSimpleElementConsumer(type, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        if (recordField != null) {
            return new CollectionsWriters.TwoLevelCollectionRecordFieldWriter(this.recordConsumer, recordField, elemConsumer);
        }
        BiConsumer<RecordConsumer, Object> innerStructureWriter = elemConsumer;
        return value -> {
            Collection coll = (Collection)value;
            if (coll != null) {
                CollectionsWriters.TwoLevelCollectionRecordFieldWriter.writeGroupElementTwo(this.recordConsumer, innerStructureWriter, coll);
            }
        };
    }

    private Consumer<Object> createThreeLevelStructureWriter(ParameterizedCollection parametized, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemConsumer = null;
        if (parametized.isCollection()) {
            parametizedChild = parametized.getParametizedAsCollection();
            Consumer<Object> childWriter = this.createThreeLevelStructureWriter((ParameterizedCollection)parametizedChild, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else if (parametized.isMap()) {
            parametizedChild = parametized.getParametizedAsMap();
            Consumer<Object> childWriter = this.createMapStructureWriter((ParameterizedMap)parametizedChild, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            Class<?> type = parametized.getActualType();
            elemConsumer = FieldsWriter.buildSimpleElementConsumer(type, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        if (recordField != null) {
            return new CollectionsWriters.ThreeLevelCollectionRecordFieldWriter(this.recordConsumer, recordField, elemConsumer);
        }
        BiConsumer<RecordConsumer, Object> innerStructureWriter = elemConsumer;
        return value -> {
            Collection coll = (Collection)value;
            if (coll != null) {
                this.recordConsumer.startGroup();
                if (!coll.isEmpty()) {
                    CollectionsWriters.ThreeLevelCollectionRecordFieldWriter.writeGroupElementThree(this.recordConsumer, innerStructureWriter, coll);
                }
                this.recordConsumer.endGroup();
            }
        };
    }

    private Consumer<Object> createMapStructureWriter(ParameterizedMap parametized, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemKeyConsumer = null;
        Class<?> keyType = parametized.getKeyActualType();
        elemKeyConsumer = FieldsWriter.buildSimpleElementConsumer(keyType, this.recordConsumer, this.carpetConfiguration);
        BiConsumer<RecordConsumer, Object> elemValueConsumer = null;
        if (parametized.valueIsCollection()) {
            parametizedChild = parametized.getValueTypeAsCollection();
            childWriter = this.createCollectionWriter((ParameterizedCollection)parametizedChild, null);
            elemValueConsumer = (consumer, v) -> childWriter.accept(v);
        } else if (parametized.valueIsMap()) {
            parametizedChild = parametized.getValueTypeAsMap();
            childWriter = this.createMapStructureWriter((ParameterizedMap)parametizedChild, null);
            elemValueConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            Class<?> valueType = parametized.getValueActualType();
            elemValueConsumer = FieldsWriter.buildSimpleElementConsumer(valueType, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemValueConsumer == null || elemKeyConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in Map");
        }
        if (recordField != null) {
            return new CollectionsWriters.MapRecordFieldWriter(this.recordConsumer, recordField, elemKeyConsumer, elemValueConsumer);
        }
        BiConsumer<RecordConsumer, Object> innerKeyStructureWriter = elemKeyConsumer;
        BiConsumer<RecordConsumer, Object> innerValueStructureWriter = elemValueConsumer;
        return value -> {
            Map map = (Map)value;
            if (map != null) {
                this.recordConsumer.startGroup();
                if (!map.isEmpty()) {
                    CollectionsWriters.MapRecordFieldWriter.writeKeyalueGroup(this.recordConsumer, innerKeyStructureWriter, innerValueStructureWriter, map);
                }
                this.recordConsumer.endGroup();
            }
        };
    }
}

