/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.impl.write.CarpetRecordWriter;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.JavaRecord2Schema;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

public class CarpetWriteSupport<T>
extends WriteSupport<T> {
    private final Class<T> recordClass;
    private final Map<String, String> extraMetaData;
    private final CarpetWriteConfiguration carpetConfiguration;
    private CarpetMessageWriter<T> carpetWriter;

    public CarpetWriteSupport(Class<T> recordClass, Map<String, String> extraMetaData, CarpetWriteConfiguration carpetConfiguration) {
        this.recordClass = recordClass;
        this.extraMetaData = extraMetaData;
        this.carpetConfiguration = carpetConfiguration;
    }

    public String getName() {
        return this.recordClass.getName();
    }

    public WriteSupport.WriteContext init(ParquetConfiguration configuration) {
        JavaRecord2Schema javaRecord2Schema = new JavaRecord2Schema(this.carpetConfiguration);
        MessageType schema = javaRecord2Schema.createSchema(this.recordClass);
        return new WriteSupport.WriteContext(schema, this.extraMetaData);
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        JavaRecord2Schema javaRecord2Schema = new JavaRecord2Schema(this.carpetConfiguration);
        MessageType schema = javaRecord2Schema.createSchema(this.recordClass);
        return new WriteSupport.WriteContext(schema, this.extraMetaData);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        try {
            this.carpetWriter = new CarpetMessageWriter<T>(recordConsumer, this.recordClass, this.carpetConfiguration);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void write(T record) {
        this.carpetWriter.write(record);
    }

    private static class CarpetMessageWriter<T> {
        private final RecordConsumer recordConsumer;
        private final CarpetRecordWriter writer;

        CarpetMessageWriter(RecordConsumer recordConsumer, Class<T> recordClass, CarpetWriteConfiguration carpetConfiguration) {
            this.recordConsumer = recordConsumer;
            this.writer = new CarpetRecordWriter(recordConsumer, recordClass, carpetConfiguration);
        }

        void write(T record) {
            this.recordConsumer.startMessage();
            this.writer.write(record);
            this.recordConsumer.endMessage();
        }
    }
}

