/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.impl.write.RecordField;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.parquet.io.api.RecordConsumer;

class CollectionsWriters {
    CollectionsWriters() {
    }

    static class MapRecordFieldWriter
    implements Consumer<Object> {
        private final RecordConsumer recordConsumer;
        private final String fieldName;
        private final int idx;
        private final Function<Object, Object> accesor;
        private final BiConsumer<RecordConsumer, Object> innerKeyStructureWriter;
        private final BiConsumer<RecordConsumer, Object> innerValueStructureWriter;

        MapRecordFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> innerStructureWriter, BiConsumer<RecordConsumer, Object> innerValueStructureWriter) {
            this.recordConsumer = recordConsumer;
            this.fieldName = recordField.fieldName();
            this.idx = recordField.idx();
            this.accesor = recordField.getAccessor();
            this.innerKeyStructureWriter = innerStructureWriter;
            this.innerValueStructureWriter = innerValueStructureWriter;
        }

        @Override
        public void accept(Object object) {
            Map value = (Map)this.accesor.apply(object);
            if (value != null) {
                this.recordConsumer.startField(this.fieldName, this.idx);
                this.recordConsumer.startGroup();
                if (!value.isEmpty()) {
                    MapRecordFieldWriter.writeKeyalueGroup(this.recordConsumer, this.innerKeyStructureWriter, this.innerValueStructureWriter, value);
                }
                this.recordConsumer.endGroup();
                this.recordConsumer.endField(this.fieldName, this.idx);
            }
        }

        static void writeKeyalueGroup(RecordConsumer recordConsumer, BiConsumer<RecordConsumer, Object> keyStructureWriter, BiConsumer<RecordConsumer, Object> valueStructureWriter, Map<?, ?> map) {
            recordConsumer.startField("key_value", 0);
            for (Map.Entry<?, ?> v : map.entrySet()) {
                Object mapValue;
                recordConsumer.startGroup();
                if (v.getKey() != null) {
                    recordConsumer.startField("key", 0);
                    keyStructureWriter.accept(recordConsumer, v.getKey());
                    recordConsumer.endField("key", 0);
                }
                if ((mapValue = v.getValue()) != null) {
                    recordConsumer.startField("value", 1);
                    valueStructureWriter.accept(recordConsumer, mapValue);
                    recordConsumer.endField("value", 1);
                }
                recordConsumer.endGroup();
            }
            recordConsumer.endField("key_value", 0);
        }
    }

    static class ThreeLevelCollectionRecordFieldWriter
    implements Consumer<Object> {
        private final RecordConsumer recordConsumer;
        private final String fieldName;
        private final int idx;
        private final Function<Object, Object> accesor;
        private final BiConsumer<RecordConsumer, Object> innerStructureWriter;

        ThreeLevelCollectionRecordFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> innerStructureWriter) {
            this.recordConsumer = recordConsumer;
            this.fieldName = recordField.fieldName();
            this.idx = recordField.idx();
            this.accesor = recordField.getAccessor();
            this.innerStructureWriter = innerStructureWriter;
        }

        @Override
        public void accept(Object object) {
            Collection value = (Collection)this.accesor.apply(object);
            if (value != null) {
                this.recordConsumer.startField(this.fieldName, this.idx);
                this.recordConsumer.startGroup();
                if (!value.isEmpty()) {
                    ThreeLevelCollectionRecordFieldWriter.writeGroupElementThree(this.recordConsumer, this.innerStructureWriter, value);
                }
                this.recordConsumer.endGroup();
                this.recordConsumer.endField(this.fieldName, this.idx);
            }
        }

        public static void writeGroupElementThree(RecordConsumer recordConsumer, BiConsumer<RecordConsumer, Object> innerStructureWriter, Collection<?> coll) {
            recordConsumer.startField("list", 0);
            for (Object v : coll) {
                recordConsumer.startGroup();
                if (v != null) {
                    recordConsumer.startField("element", 0);
                    innerStructureWriter.accept(recordConsumer, v);
                    recordConsumer.endField("element", 0);
                }
                recordConsumer.endGroup();
            }
            recordConsumer.endField("list", 0);
        }
    }

    static class TwoLevelCollectionRecordFieldWriter
    implements Consumer<Object> {
        private final RecordConsumer recordConsumer;
        private final String fieldName;
        private final int idx;
        private final Function<Object, Object> accesor;
        private final BiConsumer<RecordConsumer, Object> innerStructureWriter;

        TwoLevelCollectionRecordFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> innerStructureWriter) {
            this.recordConsumer = recordConsumer;
            this.fieldName = recordField.fieldName();
            this.idx = recordField.idx();
            this.accesor = recordField.getAccessor();
            this.innerStructureWriter = innerStructureWriter;
        }

        @Override
        public void accept(Object object) {
            Object value = this.accesor.apply(object);
            Collection coll = (Collection)value;
            if (coll != null) {
                this.recordConsumer.startField(this.fieldName, this.idx);
                TwoLevelCollectionRecordFieldWriter.writeGroupElementTwo(this.recordConsumer, this.innerStructureWriter, coll);
                this.recordConsumer.endField(this.fieldName, this.idx);
            }
        }

        public static void writeGroupElementTwo(RecordConsumer recordConsumer, BiConsumer<RecordConsumer, Object> innerStructureWriter, Collection<?> coll) {
            recordConsumer.startGroup();
            if (!coll.isEmpty()) {
                recordConsumer.startField("element", 0);
                for (Object v : coll) {
                    if (v == null) {
                        throw new NullPointerException("2-level list structures doesn't support null values");
                    }
                    innerStructureWriter.accept(recordConsumer, v);
                }
                recordConsumer.endField("element", 0);
            }
            recordConsumer.endGroup();
        }
    }

    static class OneLevelCollectionFieldWriter
    implements Consumer<Object> {
        private final RecordConsumer recordConsumer;
        private final String fieldName;
        private final int idx;
        private final Function<Object, Object> accesor;
        private final BiConsumer<RecordConsumer, Object> consumer;

        OneLevelCollectionFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> consumer) {
            this.recordConsumer = recordConsumer;
            this.fieldName = recordField.fieldName();
            this.idx = recordField.idx();
            this.accesor = recordField.getAccessor();
            this.consumer = consumer;
        }

        @Override
        public void accept(Object object) {
            Collection coll = (Collection)this.accesor.apply(object);
            if (coll != null && !coll.isEmpty()) {
                this.recordConsumer.startField(this.fieldName, this.idx);
                for (Object v : coll) {
                    this.consumer.accept(this.recordConsumer, v);
                }
                this.recordConsumer.endField(this.fieldName, this.idx);
            }
        }
    }
}

