/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.TimeUnit;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.NotNullField;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.DecimalConfig;
import com.jerolba.carpet.impl.write.FieldToColumnMapper;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class JavaRecord2Schema {
    private final CarpetWriteConfiguration carpetConfiguration;
    private final FieldToColumnMapper fieldToColumnMapper;

    public JavaRecord2Schema(CarpetWriteConfiguration carpetConfiguration) {
        this.carpetConfiguration = carpetConfiguration;
        this.fieldToColumnMapper = new FieldToColumnMapper(carpetConfiguration.columnNamingStrategy());
    }

    public MessageType createSchema(Class<?> recordClass) {
        return this.build(recordClass, new HashSet());
    }

    private MessageType build(Class<?> recordClass, Set<Class<?>> visited) {
        this.validateNotVisitedRecord(recordClass, visited);
        String groupName = recordClass.getSimpleName();
        List<org.apache.parquet.schema.Type> fields = this.createGroupFields(recordClass, visited);
        return new MessageType(groupName, fields);
    }

    private List<org.apache.parquet.schema.Type> createGroupFields(Class<?> recordClass, Set<Class<?>> visited) {
        ArrayList<org.apache.parquet.schema.Type> fields = new ArrayList<org.apache.parquet.schema.Type>();
        for (RecordComponent attr : recordClass.getRecordComponents()) {
            Class<?> type = attr.getType();
            String fieldName = this.fieldToColumnMapper.getColumnName(attr);
            boolean notNull = type.isPrimitive() || NotNullField.isNotNull(attr);
            Type.Repetition repetition = notNull ? Type.Repetition.REQUIRED : Type.Repetition.OPTIONAL;
            JavaType javaType = new JavaType(type);
            org.apache.parquet.schema.Type parquetType = this.buildType(type, visited, repetition, fieldName);
            if (parquetType != null) {
                fields.add(parquetType);
                continue;
            }
            if (javaType.isCollection()) {
                ParameterizedCollection parameterizedCollection = Parameterized.getParameterizedCollection(attr);
                fields.add(this.createCollectionType(fieldName, parameterizedCollection, visited, repetition));
                continue;
            }
            if (javaType.isMap()) {
                ParameterizedMap parameterizedMap = Parameterized.getParameterizedMap(attr);
                fields.add(this.createMapType(fieldName, parameterizedMap, visited, repetition));
                continue;
            }
            Type genericType = attr.getGenericType();
            if (genericType instanceof TypeVariable) {
                throw new RecordTypeConversionException(genericType.toString() + " generic types not supported");
            }
            throw new RecordTypeConversionException("Field '" + attr.getName() + "' of type " + attr.getType() + " not supported");
        }
        return fields;
    }

    private List<org.apache.parquet.schema.Type> buildCompositeChild(Class<?> recordClass, Set<Class<?>> visited) {
        this.validateNotVisitedRecord(recordClass, visited);
        List<org.apache.parquet.schema.Type> fields = this.createGroupFields(recordClass, visited);
        visited.remove(recordClass);
        return fields;
    }

    private org.apache.parquet.schema.Type createCollectionType(String fieldName, ParameterizedCollection collectionClass, Set<Class<?>> visited, Type.Repetition repetition) {
        return switch (this.carpetConfiguration.annotatedLevels()) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotatedLevels.ONE -> this.createCollectionOneLevel(fieldName, collectionClass, visited);
            case AnnotatedLevels.TWO -> this.createCollectionTwoLevel(fieldName, collectionClass, visited, repetition);
            case AnnotatedLevels.THREE -> this.createCollectionThreeLevel(fieldName, collectionClass, visited, repetition);
        };
    }

    private org.apache.parquet.schema.Type createCollectionOneLevel(String fieldName, ParameterizedCollection parametized, Set<Class<?>> visited) {
        if (parametized.isCollection()) {
            throw new RecordTypeConversionException("Recursive collections not supported in annotated 1-level structures");
        }
        if (parametized.isMap()) {
            return this.createMapType(fieldName, parametized.getParametizedAsMap(), visited, Type.Repetition.REPEATED);
        }
        return this.buildTypeElement(parametized.getActualType(), visited, Type.Repetition.REPEATED, fieldName);
    }

    private org.apache.parquet.schema.Type createCollectionTwoLevel(String fieldName, ParameterizedCollection parametized, Set<Class<?>> visited, Type.Repetition repetition) {
        org.apache.parquet.schema.Type nested = this.createNestedCollection(parametized, visited, Type.Repetition.REPEATED);
        return ConversionPatterns.listType((Type.Repetition)repetition, (String)fieldName, (org.apache.parquet.schema.Type)nested);
    }

    private org.apache.parquet.schema.Type createCollectionThreeLevel(String fieldName, ParameterizedCollection parametized, Set<Class<?>> visited, Type.Repetition repetition) {
        org.apache.parquet.schema.Type nested = this.createNestedCollection(parametized, visited, Type.Repetition.OPTIONAL);
        return ConversionPatterns.listOfElements((Type.Repetition)repetition, (String)fieldName, (org.apache.parquet.schema.Type)nested);
    }

    private org.apache.parquet.schema.Type createNestedCollection(ParameterizedCollection parametized, Set<Class<?>> visited, Type.Repetition repetition) {
        if (parametized.isCollection()) {
            return this.createCollectionType("element", parametized.getParametizedAsCollection(), visited, repetition);
        }
        if (parametized.isMap()) {
            return this.createMapType("element", parametized.getParametizedAsMap(), visited, repetition);
        }
        return this.buildTypeElement(parametized.getActualType(), visited, repetition, "element");
    }

    private org.apache.parquet.schema.Type createMapType(String fieldName, ParameterizedMap parametized, Set<Class<?>> visited, Type.Repetition repetition) {
        Class<?> keyType = parametized.getKeyActualType();
        org.apache.parquet.schema.Type nestedKey = this.buildTypeElement(keyType, visited, Type.Repetition.REQUIRED, "key");
        if (parametized.valueIsCollection()) {
            org.apache.parquet.schema.Type childCollection = this.createCollectionType("value", parametized.getValueTypeAsCollection(), visited, Type.Repetition.OPTIONAL);
            return (org.apache.parquet.schema.Type)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)repetition).key(nestedKey)).value(childCollection)).named(fieldName);
        }
        if (parametized.valueIsMap()) {
            org.apache.parquet.schema.Type childMap = this.createMapType("value", parametized.getValueTypeAsMap(), visited, Type.Repetition.OPTIONAL);
            return (org.apache.parquet.schema.Type)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)repetition).key(nestedKey)).value(childMap)).named(fieldName);
        }
        Class<?> valueType = parametized.getValueActualType();
        org.apache.parquet.schema.Type nestedValue = this.buildTypeElement(valueType, visited, Type.Repetition.OPTIONAL, "value");
        if (nestedKey != null && nestedValue != null) {
            return (org.apache.parquet.schema.Type)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)repetition).key(nestedKey)).value(nestedValue)).named(fieldName);
        }
        throw new RecordTypeConversionException("Unsuported type in Map");
    }

    private org.apache.parquet.schema.Type buildTypeElement(Class<?> type, Set<Class<?>> visited, Type.Repetition repetition, String name) {
        org.apache.parquet.schema.Type parquetType = this.buildType(type, visited, repetition, name);
        if (parquetType == null) {
            throw new RecordTypeConversionException("Unsuported type " + type);
        }
        return parquetType;
    }

    private org.apache.parquet.schema.Type buildType(Class<?> type, Set<Class<?>> visited, Type.Repetition repetition, String name) {
        JavaType javaType = new JavaType(type);
        PrimitiveType primitiveType = this.simpleTypeItems(javaType, repetition, name);
        if (primitiveType != null) {
            return primitiveType;
        }
        if (javaType.isRecord()) {
            List<org.apache.parquet.schema.Type> childFields = this.buildCompositeChild(type, visited);
            return new GroupType(repetition, name, childFields);
        }
        if (javaType.isString()) {
            return (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
        }
        if (javaType.isEnum()) {
            return (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named(name);
        }
        if (javaType.isUuid()) {
            return (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType())).length(16)).named(name);
        }
        if (javaType.isBigDecimal()) {
            return this.decimalTypeItem(repetition, name);
        }
        PrimitiveType dateTypeItems = this.dateTypeItems(javaType, repetition, name);
        if (dateTypeItems != null) {
            return dateTypeItems;
        }
        return null;
    }

    private PrimitiveType simpleTypeItems(JavaType javaType, Type.Repetition repetition, String name) {
        if (javaType.isInteger()) {
            return (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isLong()) {
            return (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isFloat()) {
            return (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isDouble()) {
            return (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isBoolean()) {
            return (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isShort()) {
            return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named(name);
        }
        if (javaType.isByte()) {
            return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true))).named(name);
        }
        return null;
    }

    private PrimitiveType dateTypeItems(JavaType javaType, Type.Repetition repetition, String name) {
        if (javaType.isLocalDate()) {
            return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(name);
        }
        if (javaType.isLocalTime()) {
            TimeUnit timeUnit = this.carpetConfiguration.defaultTimeUnit();
            LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType = LogicalTypeAnnotation.timeType((boolean)this.carpetConfiguration.defaultTimeIsAdjustedToUTC(), (LogicalTypeAnnotation.TimeUnit)JavaRecord2Schema.toParquetTimeUnit(timeUnit));
            PrimitiveType.PrimitiveTypeName typeName = switch (timeUnit) {
                default -> throw new IncompatibleClassChangeError();
                case TimeUnit.MILLIS -> PrimitiveType.PrimitiveTypeName.INT32;
                case TimeUnit.MICROS, TimeUnit.NANOS -> PrimitiveType.PrimitiveTypeName.INT64;
            };
            return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)typeName, (Type.Repetition)repetition).as((LogicalTypeAnnotation)timeType)).named(name);
        }
        if (javaType.isLocalDateTime()) {
            TimeUnit timeUnit = this.carpetConfiguration.defaultTimeUnit();
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStampType = LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)JavaRecord2Schema.toParquetTimeUnit(timeUnit));
            return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)timeStampType)).named(name);
        }
        if (javaType.isInstant()) {
            TimeUnit timeUnit = this.carpetConfiguration.defaultTimeUnit();
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStampType = LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)JavaRecord2Schema.toParquetTimeUnit(timeUnit));
            return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)timeStampType)).named(name);
        }
        return null;
    }

    private static LogicalTypeAnnotation.TimeUnit toParquetTimeUnit(TimeUnit timeUnit) {
        return switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.MILLIS -> LogicalTypeAnnotation.TimeUnit.MILLIS;
            case TimeUnit.MICROS -> LogicalTypeAnnotation.TimeUnit.MICROS;
            case TimeUnit.NANOS -> LogicalTypeAnnotation.TimeUnit.NANOS;
        };
    }

    private org.apache.parquet.schema.Type decimalTypeItem(Type.Repetition repetition, String name) {
        DecimalConfig decimalConfig = this.carpetConfiguration.decimalConfig();
        if (!decimalConfig.arePrecisionAndScaleConfigured()) {
            throw new RecordTypeConversionException("If BigDecimall is used, a Default Decimal configuration must be provided in the setup of CarpetWriter builder");
        }
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = LogicalTypeAnnotation.decimalType((int)decimalConfig.scale(), (int)decimalConfig.precision());
        if (decimalConfig.precision() <= 9) {
            return (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalType)).named(name);
        }
        if (decimalConfig.precision() <= 18) {
            return (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalType)).named(name);
        }
        return (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalType)).named(name);
    }

    private void validateNotVisitedRecord(Class<?> recordClass, Set<Class<?>> visited) {
        if (!recordClass.isRecord()) {
            throw new RecordTypeConversionException(recordClass.getName() + " must be a java Record");
        }
        if (visited.contains(recordClass)) {
            throw new RecordTypeConversionException("Recusive records are not supported");
        }
        visited.add(recordClass);
    }
}

