/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.function.Function;

public class Reflection {
    private Reflection() {
    }

    public static Function<Object, Object> recordAccessor(Class<?> targetClass, RecordComponent recordComponent) {
        return Reflection.fieldAccessor(targetClass, recordComponent.getName(), recordComponent.getType());
    }

    public static Function<Object, Object> recordAccessor(Class<?> targetClass, Field classField) {
        return Reflection.fieldAccessor(targetClass, classField.getName(), classField.getType());
    }

    private static Function<Object, Object> fieldAccessor(Class<?> targetClass, String name, Class<?> fieldType) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle findVirtual = lookup.findVirtual(targetClass, name, MethodType.methodType(fieldType));
            CallSite site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), findVirtual, MethodType.methodType(fieldType, targetClass));
            return site.getTarget().invokeExact();
        }
        catch (IllegalAccessException e) {
            try {
                Method m = targetClass.getDeclaredMethod(name, new Class[0]);
                m.setAccessible(true);
                MethodHandle pmh = lookup.unreflect(m);
                return obj -> {
                    try {
                        return pmh.invoke(obj);
                    }
                    catch (Throwable e1) {
                        throw new RuntimeException(e1);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException em) {
                throw new RuntimeException(em);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

