/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.io;

import com.jerolba.carpet.io.CountedPositionOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;

public class FileSystemOutputFile
implements OutputFile {
    private final File file;

    public FileSystemOutputFile(File file) {
        this.file = file;
    }

    public PositionOutputStream create(long blockSizeHint) throws IOException {
        if (this.file.exists()) {
            throw new IllegalArgumentException("File already exists: " + this.file);
        }
        return this.createOrOverwrite(blockSizeHint);
    }

    public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
        return new CountedPositionOutputStream(new FileOutputStream(this.file));
    }

    public boolean supportsBlockSize() {
        return false;
    }

    public long defaultBlockSize() {
        return 0L;
    }
}

