/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.framework;

import com.jetbrains.rd.framework.AbstractBuffer;
import com.jetbrains.rd.framework.AbstractBufferKt;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.framework.SocketWireKt;
import com.jetbrains.rd.framework.UnsafeBuffer;
import com.jetbrains.rd.framework.base.WireBase;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.RdDefaultErrorLoggerHolder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rd.util.threading.ByteBufferAsyncProcessor;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00052\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/framework/SocketWire;", "", "()V", "Base", "Client", "Companion", "Server", "ServerFactory", "WireParameters", "rd-framework"})
public final class SocketWire {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Duration timeout;
    private static final int ack_msg_len = -1;
    private static final int ping_len = -2;
    private static final int pkg_header_len = 12;
    private static final int default_max_msg_len = 300000000;
    @NotNull
    public static final String disconnectedPauseReason = "Socket not connected";
    public static final int maximumHeartbeatDelay = 3;

    static {
        Duration duration = Duration.ofMillis(500L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(500)");
        timeout = duration;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001PB\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020=2\u0006\u0010A\u001a\u000203H\u0002J1\u0010B\u001a\u00020=2\u0006\u0010\u0002\u001a\u00020C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020=0EH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bF\u0010GJ\u0010\u0010H\u001a\u00020=2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020$H\u0002J\u0010\u0010M\u001a\u00020=2\u0006\u0010L\u001a\u00020$H\u0002J\b\u0010N\u001a\u00020OH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020302\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u00108\u001a&\u0012\f\u0012\n ;*\u0004\u0018\u00010:0: ;*\u0012\u0012\f\u0012\n ;*\u0004\u0018\u00010:0:\u0018\u00010909X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006Q"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Base;", "Lcom/jetbrains/rd/framework/base/WireBase;", "id", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;)V", "ackPkgHeader", "Lcom/jetbrains/rd/framework/AbstractBuffer;", "acktor", "Ljava/util/concurrent/ExecutorService;", "getAcktor", "()Ljava/util/concurrent/ExecutorService;", "counterpartNotionTimestamp", "", "counterpartTimestamp", "currentTimeStamp", "getId", "()Ljava/lang/String;", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "logger", "Lcom/jetbrains/rd/util/Logger;", "getLogger", "()Lcom/jetbrains/rd/util/Logger;", "value", "maxMessageLength", "getMaxMessageLength", "()I", "setMaxMessageLength", "(I)V", "maxReceivedSeqn", "", "output", "Ljava/io/OutputStream;", "pkgInput", "Ljava/io/InputStream;", "sendBuffer", "Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor;", "getSendBuffer", "()Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor;", "sendPingPkgHeader", "sendPkgHeader", "sentSeqn", "socketInput", "socketProvider", "Lcom/jetbrains/rd/util/reactive/OptProperty;", "Ljava/net/Socket;", "getSocketProvider", "()Lcom/jetbrains/rd/util/reactive/OptProperty;", "socketSendLock", "", "threadLocalBufferArray", "Ljava/lang/ThreadLocal;", "Lcom/jetbrains/rd/framework/UnsafeBuffer;", "kotlin.jvm.PlatformType", "ping", "", "readMsg", "", "receiverProc", "socket", "send", "Lcom/jetbrains/rd/framework/RdId;", "writer", "Lkotlin/Function1;", "send-311-pGg", "(JLkotlin/jvm/functions/Function1;)V", "send0", "chunk", "Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk;", "sendAck", "seqn", "sendAck0", "startHeartbeat", "Lkotlinx/coroutines/Job;", "PkgInputStream", "rd-framework"})
    @SourceDebugExtension(value={"SMAP\nSocketWire.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketWire.kt\ncom/jetbrains/rd/framework/SocketWire$Base\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,596:1\n127#2,6:597\n106#2:603\n98#2,4:604\n103#2:608\n98#2,4:609\n104#2:613\n98#2,4:614\n104#2:618\n98#2,4:619\n104#2:623\n98#2,4:624\n106#2:629\n98#2,4:630\n103#2:634\n98#2,4:635\n1#3:628\n*S KotlinDebug\n*F\n+ 1 SocketWire.kt\ncom/jetbrains/rd/framework/SocketWire$Base\n*L\n90#1:597,6\n100#1:603\n100#1:604,4\n151#1:608\n151#1:609,4\n182#1:613\n182#1:614,4\n187#1:618\n187#1:619,4\n192#1:623\n192#1:624,4\n294#1:629\n294#1:630,4\n333#1:634\n333#1:635,4\n*E\n"})
    public static abstract class Base
    extends WireBase {
        @NotNull
        private final String id;
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Logger logger;
        @NotNull
        private final OptProperty<Socket> socketProvider;
        private OutputStream output;
        private InputStream socketInput;
        private InputStream pkgInput;
        @NotNull
        private final ByteBufferAsyncProcessor sendBuffer;
        private final ThreadLocal<UnsafeBuffer> threadLocalBufferArray;
        @NotNull
        private final ExecutorService acktor;
        @NotNull
        private final Object lock;
        private volatile int maxMessageLength;
        private long maxReceivedSeqn;
        private long sentSeqn;
        @NotNull
        private final Object socketSendLock;
        @NotNull
        private final AbstractBuffer sendPkgHeader;
        @NotNull
        private final AbstractBuffer ackPkgHeader;
        private int currentTimeStamp;
        private int counterpartTimestamp;
        private int counterpartNotionTimestamp;
        @NotNull
        private final AbstractBuffer sendPingPkgHeader;

        protected Base(@NotNull String id, @NotNull Lifetime lifetime, final @NotNull IScheduler scheduler) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this.id = id;
            this.lifetime = lifetime;
            this.logger = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
            this.socketProvider = new OptProperty();
            this.sendBuffer = new ByteBufferAsyncProcessor(this.id + "/Sender", 0, (Function1)new Function1<ByteBufferAsyncProcessor.Chunk, Unit>((Object)this){

                public final void invoke(@NotNull ByteBufferAsyncProcessor.Chunk p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Base.access$send0((Base)this.receiver, p0);
                }
            }, 2, null);
            this.threadLocalBufferArray = ThreadLocal.withInitial(Base::threadLocalBufferArray$lambda$0);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
            this.acktor = executorService;
            this.lock = new Object();
            this.maxMessageLength = 300000000;
            this.sendBuffer.pause(SocketWire.disconnectedPauseReason);
            this.sendBuffer.start();
            this.getConnected().advise(this.lifetime, (Function1)new Function1<Boolean, Unit>(){

                public final void invoke(boolean it) {
                    this.getHeartbeatAlive().setValue((Object)it);
                }
            });
            this.socketProvider.advise(this.lifetime, (Function1)new Function1<Socket, Unit>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Socket socket) {
                    void $this$log$iv$iv2;
                    InputStream $this$debug$iv;
                    Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
                    Logger logger = this.getLogger();
                    Base base = this;
                    boolean $i$f$debug = false;
                    void var5_7 = $this$debug$iv;
                    LogLevel level$iv$iv = LogLevel.Debug;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv2.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var9_14 = $this$log$iv$iv2;
                        boolean bl = false;
                        String string = base.getId() + " : connected";
                        var9_14.log(logLevel, (Object)string, null);
                    }
                    OutputStream outputStream = socket.getOutputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"socket.outputStream");
                    output = outputStream;
                    InputStream inputStream = socket.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"socket.inputStream");
                    $this$debug$iv = inputStream;
                    int n = 8192;
                    socketInput = $this$debug$iv instanceof BufferedInputStream ? (BufferedInputStream)$this$debug$iv : new BufferedInputStream($this$debug$iv, n);
                    InputStream inputStream2 = socketInput;
                    if (inputStream2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"socketInput");
                        inputStream2 = null;
                    }
                    pkgInput = new PkgInputStream(inputStream2);
                    this.getSendBuffer().reprocessUnacknowledged();
                    this.getSendBuffer().resume(SocketWire.disconnectedPauseReason);
                    Job heartbeatJob = this.startHeartbeat();
                    scheduler.queue((Function0)new Function0<Unit>(){

                        public final void invoke() {
                            this.getConnected().setValue((Object)true);
                        }
                    });
                    try {
                        this.receiverProc(socket);
                    }
                    catch (Throwable throwable) {
                        scheduler.queue((Function0)new Function0<Unit>(this){
                            final /* synthetic */ Base this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getConnected().setValue((Object)false);
                            }
                        });
                        Job.DefaultImpls.cancel$default((Job)heartbeatJob, null, (int)1, null);
                        this.getSendBuffer().pause(SocketWire.disconnectedPauseReason);
                        boolean $i$f$catchAndDrop = false;
                        try {
                            boolean bl = false;
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                        }
                        throw throwable;
                    }
                    scheduler.queue((Function0)new /* invalid duplicate definition of identical inner class */);
                    Job.DefaultImpls.cancel$default((Job)heartbeatJob, null, (int)1, null);
                    this.getSendBuffer().pause(SocketWire.disconnectedPauseReason);
                    boolean $i$f$catchAndDrop = false;
                    try {
                        boolean bl = false;
                        socket.close();
                    }
                    catch (Throwable $this$log$iv$iv2) {
                    }
                }
            });
            this.socketSendLock = new Object();
            this.sendPkgHeader = AbstractBufferKt.createAbstractBuffer();
            this.ackPkgHeader = AbstractBufferKt.createAbstractBuffer();
            this.sendPingPkgHeader = AbstractBufferKt.createAbstractBuffer();
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        protected final Logger getLogger() {
            return this.logger;
        }

        @NotNull
        public final OptProperty<Socket> getSocketProvider() {
            return this.socketProvider;
        }

        @NotNull
        protected final ByteBufferAsyncProcessor getSendBuffer() {
            return this.sendBuffer;
        }

        @NotNull
        public final ExecutorService getAcktor() {
            return this.acktor;
        }

        private final void sendAck(long seqn) {
            boolean $i$f$catchAndDrop = false;
            try {
                boolean bl = false;
                this.acktor.execute(() -> Base.sendAck$lambda$2$lambda$1(this, seqn));
            }
            catch (Throwable throwable) {
            }
        }

        @NotNull
        protected final Object getLock() {
            return this.lock;
        }

        public final int getMaxMessageLength() {
            return this.maxMessageLength;
        }

        /*
         * WARNING - void declaration
         */
        public final void setMaxMessageLength(int value2) {
            if (value2 < 300000000) {
                void $this$log$iv$iv;
                Logger $this$warn$iv = this.logger;
                boolean $i$f$warn = false;
                Logger logger = $this$warn$iv;
                LogLevel level$iv$iv = LogLevel.Warn;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var8_8 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = value2 + " is less than default value (300000000). This is not allowed.";
                    var8_8.log(logLevel, (Object)string, null);
                }
            } else {
                this.maxMessageLength = value2;
            }
        }

        private final Job startHeartbeat() {
            return BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ Base this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                            // 2 sources

                            while (true) {
                                this.label = 1;
                                v0 = DelayKt.delay((long)this.this$0.getHeartbeatIntervalMs(), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl15
                                break;
                            }
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            Base.access$ping(this.this$0);
                            ** continue;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void ping() {
            block9: {
                try {
                    if (!Companion.connectionEstablished(this.currentTimeStamp, this.counterpartNotionTimestamp)) {
                        if (((Boolean)this.getHeartbeatAlive().getValue()).booleanValue()) {
                            void $this$log$iv$iv;
                            Logger $this$trace$iv = this.logger;
                            boolean $i$f$trace = false;
                            Logger logger = $this$trace$iv;
                            LogLevel level$iv$iv = LogLevel.Trace;
                            boolean $i$f$log = false;
                            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                                LogLevel logLevel = level$iv$iv;
                                void var7_12 = $this$log$iv$iv;
                                boolean bl = false;
                                String string = "Disconnect detected while sending PING " + this.id + ": currentTimeStamp: " + this.currentTimeStamp + ", counterpartTimestamp: " + this.counterpartTimestamp + ", counterpartNotionTimestamp: " + this.counterpartNotionTimestamp;
                                var7_12.log(logLevel, (Object)string, null);
                            }
                        }
                        this.getHeartbeatAlive().setValue((Object)false);
                    }
                    Object object = this.socketSendLock;
                    synchronized (object) {
                        boolean bl = false;
                        this.sendPingPkgHeader.reset();
                        this.sendPingPkgHeader.writeInt(-2);
                        this.sendPingPkgHeader.writeInt(this.currentTimeStamp);
                        this.sendPingPkgHeader.writeInt(this.counterpartTimestamp);
                        OutputStream outputStream = this.output;
                        if (outputStream == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                            outputStream = null;
                        }
                        outputStream.write(this.sendPingPkgHeader.getArray());
                        Unit unit = Unit.INSTANCE;
                    }
                    ++this.currentTimeStamp;
                }
                catch (Throwable t) {
                    if (!this.logger.isEnabled(LogLevel.Debug)) break block9;
                    this.logger.log(LogLevel.Debug, (Object)(this.id + ": " + t.getClass() + " raised during PING"), t);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void receiverProc(Socket socket) {
            while (RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
                try {
                    if (!socket.isConnected()) {
                        void $this$log$iv$iv;
                        Logger $this$debug$iv = this.logger;
                        boolean $i$f$debug = false;
                        Logger logger = $this$debug$iv;
                        LogLevel level$iv$iv = LogLevel.Debug;
                        boolean $i$f$log = false;
                        if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                        LogLevel logLevel = level$iv$iv;
                        void var10_20 = $this$log$iv$iv;
                        boolean bl = false;
                        String string = "Stop receive messages because socket disconnected";
                        var10_20.log(logLevel, (Object)string, null);
                        break;
                    }
                    if (this.readMsg()) continue;
                    Logger $this$debug$iv = this.logger;
                    boolean $i$f$debug = false;
                    Logger $this$log$iv$iv = $this$debug$iv;
                    LogLevel level$iv$iv = LogLevel.Debug;
                    boolean $i$f$log = false;
                    if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                    LogLevel logLevel = level$iv$iv;
                    Logger logger = $this$log$iv$iv;
                    boolean bl = false;
                    String string = this.id + ": Connection was gracefully shutdown";
                    logger.log(logLevel, (Object)string, null);
                }
                catch (Throwable ex) {
                    Throwable throwable = ex;
                    if ((throwable instanceof SocketException ? true : throwable instanceof EOFException) ? true : throwable instanceof IOException) {
                        void $this$log$iv$iv;
                        Logger $this$debug$iv = this.logger;
                        boolean $i$f$debug = false;
                        Logger $i$f$log = $this$debug$iv;
                        LogLevel level$iv$iv = LogLevel.Debug;
                        boolean $i$f$log2 = false;
                        if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                        LogLevel logLevel = level$iv$iv;
                        void var10_22 = $this$log$iv$iv;
                        boolean bl = false;
                        String string = "Exception in SocketWire.Receive:  " + this.id + ": " + ex;
                        var10_22.log(logLevel, (Object)string, null);
                        break;
                    }
                    LoggerKt.error((Logger)this.logger, (String)(this.id + " caught processing"), (Throwable)ex);
                }
                break;
            }
        }

        private final boolean readMsg() {
            long seqnAtStart = this.maxReceivedSeqn;
            InputStream inputStream = this.pkgInput;
            if (inputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pkgInput");
                inputStream = null;
            }
            Integer n = SocketWireKt.access$readInt32(inputStream);
            if (n == null) {
                return false;
            }
            int len = n;
            if (!(len > 0)) {
                boolean $i$a$-require-SocketWire$Base$readMsg$32 = false;
                String $i$a$-require-SocketWire$Base$readMsg$32 = "len > 0: " + len;
                throw new IllegalArgumentException($i$a$-require-SocketWire$Base$readMsg$32.toString());
            }
            if (!(len < this.maxMessageLength)) {
                boolean $i$a$-require-SocketWire$Base$readMsg$42 = false;
                String string = Integer.toString(len, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                String string2 = Integer.toString(this.maxMessageLength, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
                String $i$a$-require-SocketWire$Base$readMsg$42 = "Possible OOM: array_len=" + len + "(0x" + string + "), allowed_len=" + this.maxMessageLength + "(0x" + string2 + ")";
                throw new IllegalArgumentException($i$a$-require-SocketWire$Base$readMsg$42.toString());
            }
            byte[] data = new byte[len];
            InputStream inputStream2 = this.pkgInput;
            if (inputStream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pkgInput");
                inputStream2 = null;
            }
            if (!SocketWireKt.access$readByteArray(inputStream2, data)) {
                return false;
            }
            if (this.maxReceivedSeqn > seqnAtStart) {
                long responseSeqn = this.maxReceivedSeqn;
                this.sendAck(responseSeqn);
            }
            UnsafeBuffer unsafeBuffer = new UnsafeBuffer(data);
            long id = RdId.Companion.read-0fMd8cM(unsafeBuffer);
            this.getMessageBroker().dispatch-311-pGg(id, unsafeBuffer);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void sendAck0(long seqn) {
            block6: {
                try {
                    this.ackPkgHeader.reset();
                    this.ackPkgHeader.writeInt(-1);
                    this.ackPkgHeader.writeLong(seqn);
                    Object object = this.socketSendLock;
                    synchronized (object) {
                        boolean $i$a$-synchronized-SocketWire$Base$sendAck0$22 = false;
                        OutputStream outputStream = this.output;
                        if (outputStream == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                            outputStream = null;
                        }
                        outputStream.write(this.ackPkgHeader.getArray(), 0, 12);
                        Unit $i$a$-synchronized-SocketWire$Base$sendAck0$22 = Unit.INSTANCE;
                    }
                }
                catch (SocketException ex) {
                    void $this$log$iv$iv;
                    Logger $this$warn$iv = this.logger;
                    boolean $i$f$warn = false;
                    Logger logger = $this$warn$iv;
                    LogLevel level$iv$iv = LogLevel.Warn;
                    boolean $i$f$log = false;
                    if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break block6;
                    LogLevel logLevel = level$iv$iv;
                    void var10_13 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = this.id + ": Exception raised during ACK, seqn = " + seqn;
                    var10_13.log(logLevel, (Object)string, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void send0(ByteBufferAsyncProcessor.Chunk chunk) {
            try {
                if (chunk.isNotProcessed()) {
                    ++this.sentSeqn;
                    chunk.setSeqn(this.sentSeqn);
                }
                this.sendPkgHeader.reset();
                this.sendPkgHeader.writeInt(chunk.getPtr());
                this.sendPkgHeader.writeLong(chunk.getSeqn());
                Object object = this.socketSendLock;
                synchronized (object) {
                    OutputStream outputStream;
                    void $this$log$iv$iv;
                    boolean bl = false;
                    Logger $this$trace$iv = this.logger;
                    boolean $i$f$trace = false;
                    Logger logger = $this$trace$iv;
                    LogLevel level$iv$iv = LogLevel.Trace;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var11_12 = $this$log$iv$iv;
                        boolean bl2 = false;
                        String string = "Send package with seqn " + chunk.getSeqn();
                        var11_12.log(logLevel, (Object)string, null);
                    }
                    if ((outputStream = this.output) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                        outputStream = null;
                    }
                    outputStream.write(this.sendPkgHeader.getArray(), 0, 12);
                    OutputStream outputStream2 = this.output;
                    if (outputStream2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                        outputStream2 = null;
                    }
                    outputStream2.write(chunk.getData(), 0, chunk.getPtr());
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (SocketException ex) {
                this.sendBuffer.pause(SocketWire.disconnectedPauseReason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send-311-pGg(long id, @NotNull Function1<? super AbstractBuffer, Unit> writer) {
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            if (!(!RdId.isNull-impl(id))) {
                boolean $i$a$-require-SocketWire$Base$send$22 = false;
                String $i$a$-require-SocketWire$Base$send$22 = "id mustn't be null";
                throw new IllegalArgumentException($i$a$-require-SocketWire$Base$send$22.toString());
            }
            UnsafeBuffer unsafeBuffer = this.threadLocalBufferArray.get();
            int initialPosition = unsafeBuffer.getPosition();
            try {
                unsafeBuffer.writeInt(0);
                Intrinsics.checkNotNullExpressionValue((Object)unsafeBuffer, (String)"unsafeBuffer");
                RdId.write-impl(id, unsafeBuffer);
                this.getContexts().writeCurrentMessageContext(unsafeBuffer);
                writer.invoke((Object)unsafeBuffer);
                int len = unsafeBuffer.getPosition() - initialPosition;
                unsafeBuffer.setPosition(initialPosition);
                unsafeBuffer.writeInt(len - 4);
                byte[] bytes = unsafeBuffer.getArray();
                this.sendBuffer.put(bytes, initialPosition, len);
            }
            finally {
                if (initialPosition == 0) {
                    unsafeBuffer.reset();
                } else {
                    unsafeBuffer.setPosition(initialPosition);
                }
            }
        }

        private static final UnsafeBuffer threadLocalBufferArray$lambda$0() {
            return new UnsafeBuffer(new byte[16384]);
        }

        private static final void sendAck$lambda$2$lambda$1(Base this$0, long $seqn) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.sendAck0($seqn);
        }

        public static final /* synthetic */ void access$ping(Base $this) {
            $this.ping();
        }

        public static final /* synthetic */ void access$send0(Base $this, ByteBufferAsyncProcessor.Chunk chunk) {
            $this.send0(chunk);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Base$PkgInputStream;", "Ljava/io/InputStream;", "stream", "(Lcom/jetbrains/rd/framework/SocketWire$Base;Ljava/io/InputStream;)V", "pkg", "", "getPkg", "()[B", "setPkg", "([B)V", "pos", "", "getPos", "()I", "setPos", "(I)V", "read", "rd-framework"})
        @SourceDebugExtension(value={"SMAP\nSocketWire.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketWire.kt\ncom/jetbrains/rd/framework/SocketWire$Base$PkgInputStream\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,596:1\n103#2:597\n98#2,4:598\n1#3:602\n*S KotlinDebug\n*F\n+ 1 SocketWire.kt\ncom/jetbrains/rd/framework/SocketWire$Base$PkgInputStream\n*L\n246#1:597\n246#1:598,4\n*E\n"})
        public final class PkgInputStream
        extends InputStream {
            @NotNull
            private final InputStream stream;
            @NotNull
            private byte[] pkg;
            private int pos;

            public PkgInputStream(InputStream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                this.stream = stream;
                this.pkg = new byte[0];
            }

            @NotNull
            public final byte[] getPkg() {
                return this.pkg;
            }

            public final void setPkg(@NotNull byte[] byArray) {
                Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
                this.pkg = byArray;
            }

            public final int getPos() {
                return this.pos;
            }

            public final void setPos(int n) {
                this.pos = n;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int read() {
                if (this.pos < this.pkg.length) {
                    int n = this.pos;
                    this.pos = n + 1;
                    return this.pkg[n] & 0xFF;
                }
                while (true) {
                    Base base;
                    Integer n = SocketWireKt.access$readInt32(this.stream);
                    if (n == null) {
                        return -1;
                    }
                    int len = n;
                    if (len == -2) {
                        Integer n2 = SocketWireKt.access$readInt32(this.stream);
                        if (n2 == null) {
                            return -1;
                        }
                        int receivedTimestamp = n2;
                        Integer n3 = SocketWireKt.access$readInt32(this.stream);
                        if (n3 == null) {
                            return -1;
                        }
                        int receivedCounterpartTimestamp = n3;
                        Base.this.counterpartTimestamp = receivedTimestamp;
                        Base.this.counterpartNotionTimestamp = receivedCounterpartTimestamp;
                        if (!Companion.connectionEstablished(Base.this.currentTimeStamp, Base.this.counterpartNotionTimestamp)) continue;
                        if (!((Boolean)Base.this.getHeartbeatAlive().getValue()).booleanValue()) {
                            void $this$log$iv$iv;
                            void $this$trace$iv;
                            Logger logger = Base.this.getLogger();
                            base = Base.this;
                            boolean $i$f$trace = false;
                            void var7_13 = $this$trace$iv;
                            LogLevel level$iv$iv = LogLevel.Trace;
                            boolean $i$f$log = false;
                            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                                LogLevel logLevel = level$iv$iv;
                                void var11_17 = $this$log$iv$iv;
                                boolean bl = false;
                                String string = "Connection is alive after receiving PING " + base.getId() + ": receivedTimestamp: " + receivedTimestamp + ", receivedCounterpartTimestamp: " + receivedCounterpartTimestamp + "currentTimeStamp: " + base.currentTimeStamp + ", counterpartTimestamp: " + base.counterpartTimestamp + ", counterpartNotionTimestamp: " + base.counterpartNotionTimestamp;
                                var11_17.log(logLevel, (Object)string, null);
                            }
                        }
                        Base.this.getHeartbeatAlive().setValue((Object)true);
                        continue;
                    }
                    Long l = SocketWireKt.access$readInt64(this.stream);
                    if (l == null) {
                        return -1;
                    }
                    long seqn = l;
                    if (len == -1) {
                        Base.this.getSendBuffer().acknowledge(seqn);
                        continue;
                    }
                    if (!(len > 0)) {
                        boolean bl = false;
                        String string = "len > 0: " + len;
                        throw new IllegalArgumentException(string.toString());
                    }
                    int n4 = len < Base.this.getMaxMessageLength() ? 1 : 0;
                    base = Base.this;
                    if (n4 == 0) {
                        boolean bl = false;
                        String string = Integer.toString(len, CharsKt.checkRadix((int)16));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                        int n5 = base.getMaxMessageLength();
                        String string2 = Integer.toString(base.getMaxMessageLength(), CharsKt.checkRadix((int)16));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
                        String string3 = "Possible OOM: array_len=" + len + "(0x" + string + "), allowed_len=" + n5 + "(0x" + string2 + ")";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.pkg = new byte[len];
                    this.pos = 0;
                    SocketWireKt.access$readByteArray(this.stream, this.pkg);
                    if (seqn > Base.this.maxReceivedSeqn) {
                        Base.this.maxReceivedSeqn = seqn;
                        n4 = this.pos;
                        this.pos = n4 + 1;
                        return this.pkg[n4] & 0xFF;
                    }
                    Base.this.sendAck(seqn);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Client;", "Lcom/jetbrains/rd/framework/SocketWire$Base;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "port", "", "optId", "", "hostAddress", "Ljava/net/InetAddress;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;ILjava/lang/String;Ljava/net/InetAddress;)V", "rd-framework"})
    public static final class Client
    extends Base {
        public Client(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, int port, @Nullable String optId, @NotNull InetAddress hostAddress) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            Intrinsics.checkNotNullParameter((Object)hostAddress, (String)"hostAddress");
            String string = optId;
            if (string == null) {
                string = "ClientSocket";
            }
            super(string, lifetime, scheduler);
            Ref.ObjectRef socket = new Ref.ObjectRef();
            String string2 = this.getId();
            Thread thread2 = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)string2, (int)0, (Function0)((Function0)new Function0<Unit>(lifetime, this, hostAddress, port, (Ref.ObjectRef<Socket>)socket){
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ Client this$0;
                final /* synthetic */ InetAddress $hostAddress;
                final /* synthetic */ int $port;
                final /* synthetic */ Ref.ObjectRef<Socket> $socket;
                {
                    this.$lifetime = $lifetime;
                    this.this$0 = $receiver;
                    this.$hostAddress = $hostAddress;
                    this.$port = $port;
                    this.$socket = $socket;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public final void invoke() {
                    void $this$log$iv$iv;
                    void $this$debug$iv;
                    Object e22;
                    String string;
                    Object object;
                    Object object2;
                    Client client;
                    try {
                        int lastReportedErrorHash = 0;
                        while (RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                            Object $this$log$iv$iv2;
                            InetAddress level$iv$iv;
                            Object object3;
                            Object $this$debug$iv2;
                            Client client2;
                            Socket s;
                            block26: {
                                void $this$log$iv$iv3;
                                void $this$debug$iv3;
                                void $this$log$iv$iv422;
                                void $this$log$iv$iv5;
                                s = new Socket();
                                s.setTcpNoDelay(true);
                                client = this.this$0.getLogger();
                                client2 = this.this$0;
                                Object object4 = this.$hostAddress;
                                int n = this.$port;
                                boolean $i$f$debug232 = false;
                                void var8_34 = $this$debug$iv2;
                                LogLevel level$iv$iv2 = LogLevel.Debug;
                                boolean $i$f$log = false;
                                if ($this$log$iv$iv5.isEnabled(level$iv$iv2)) {
                                    object2 = level$iv$iv2;
                                    object = $this$log$iv$iv5;
                                    boolean bl2 = false;
                                    string = client2.getId() + " : connecting to " + (InetAddress)object4 + ":" + n;
                                    object.log(object2, (Object)string, null);
                                }
                                s.connect(new InetSocketAddress(this.$hostAddress, this.$port));
                                $this$debug$iv2 = this.this$0.getLock();
                                client2 = this.$lifetime;
                                object4 = this.this$0;
                                object3 = this.$socket;
                                Object $i$f$debug232 = $this$debug$iv2;
                                // MONITORENTER : $i$f$debug232
                                boolean bl = false;
                                if (RLifetimeKt.isAlive((Lifetime)client2)) break block26;
                                Logger $this$debug$iv4 = ((Base)object4).getLogger();
                                boolean $i$f$debug = false;
                                Logger bl2 = $this$debug$iv4;
                                LogLevel level$iv$iv3 = LogLevel.Debug;
                                boolean $i$f$log2 = false;
                                if ($this$log$iv$iv422.isEnabled(level$iv$iv3)) {
                                    LogLevel logLevel = level$iv$iv3;
                                    void var15_59 = $this$log$iv$iv422;
                                    boolean bl3 = false;
                                    String string2 = ((Base)object4).getId() + " : connected, but lifetime is already canceled, closing socket";
                                    var15_59.log(logLevel, (Object)string2, null);
                                }
                                boolean $i$f$catchAndDrop = false;
                                try {
                                    boolean bl4 = false;
                                    s.close();
                                }
                                catch (Throwable $this$log$iv$iv422) {
                                }
                                Logger logger = this.this$0.getLogger();
                                Client client3 = this.this$0;
                                boolean $i$f$debug3 = false;
                                void var21_65 = $this$debug$iv3;
                                LogLevel level$iv$iv4 = LogLevel.Debug;
                                boolean $i$f$log3 = false;
                                if (!$this$log$iv$iv3.isEnabled(level$iv$iv4)) return;
                                object2 = level$iv$iv4;
                                object = $this$log$iv$iv3;
                                boolean bl5 = false;
                                string = client3.getId() + ": terminated.";
                                object.log(object2, (Object)string, null);
                                return;
                            }
                            try {
                                object3.element = s;
                                Unit unit = Unit.INSTANCE;
                                // MONITOREXIT : $i$f$debug232
                                this.this$0.getSocketProvider().set((Object)s);
                                $this$debug$iv2 = this.this$0.getLogger();
                                client2 = this.this$0;
                                boolean $i$f$debug = false;
                                object3 = $this$debug$iv2;
                                level$iv$iv = LogLevel.Debug;
                                boolean $i$f$log = false;
                                if (!$this$log$iv$iv2.isEnabled((LogLevel)level$iv$iv)) continue;
                                object2 = level$iv$iv;
                                object = $this$log$iv$iv2;
                                boolean bl2 = false;
                                string = client2.getId() + ": receiverProc finished ";
                                object.log(object2, (Object)string, null);
                            }
                            catch (ConnectException e22) {
                                boolean bl;
                                Pair errorSource = new Pair((Object)e22.getMessage(), (Object)ExceptionsKt.stackTraceToString((Throwable)e22));
                                int errorHashCode = errorSource.hashCode();
                                if (lastReportedErrorHash != errorHashCode) {
                                    lastReportedErrorHash = errorHashCode;
                                    if (this.this$0.getLogger().isEnabled(LogLevel.Debug)) {
                                        this.this$0.getLogger().log(LogLevel.Debug, (Object)(this.this$0.getId() + ": connection error for endpoint " + this.$hostAddress + ":" + this.$port + "."), (Throwable)e22);
                                    }
                                } else {
                                    void $this$log$iv$iv6;
                                    void $this$debug$iv5;
                                    Logger $i$f$debug = this.this$0.getLogger();
                                    $this$log$iv$iv2 = this.this$0;
                                    level$iv$iv = this.$hostAddress;
                                    int $i$f$log = this.$port;
                                    boolean $i$f$debug4 = false;
                                    void bl4 = $this$debug$iv5;
                                    LogLevel level$iv$iv5 = LogLevel.Debug;
                                    boolean $i$f$log4 = false;
                                    if ($this$log$iv$iv6.isEnabled(level$iv$iv5)) {
                                        object2 = level$iv$iv5;
                                        object = $this$log$iv$iv6;
                                        boolean bl6 = false;
                                        string = ((Base)$this$log$iv$iv2).getId() + ": connection error for endpoint " + level$iv$iv + ":" + $i$f$log + " (" + e22.getMessage() + ").";
                                        object.log(object2, (Object)string, null);
                                    }
                                }
                                $this$log$iv$iv2 = this.this$0.getLock();
                                level$iv$iv = this.$lifetime;
                                Client $i$f$log = this.this$0;
                                Object object5 = $this$log$iv$iv2;
                                // MONITORENTER : object5
                                boolean bl7 = false;
                                if (RLifetimeKt.isAlive((Lifetime)level$iv$iv)) {
                                    $i$f$log.getLock().wait(SocketWire.Companion.getTimeout().toMillis());
                                    bl = RLifetimeKt.isAlive((Lifetime)level$iv$iv);
                                } else {
                                    bl = false;
                                }
                                boolean bl8 = bl;
                                // MONITOREXIT : object5
                                boolean shouldReconnect = bl8;
                                if (shouldReconnect) continue;
                            }
                        }
                    }
                    catch (SocketException ex22) {
                        void $this$log$iv$iv7;
                        void $this$debug$iv6;
                        Logger level$iv$iv;
                        Object $this$info$iv;
                        block27: {
                            void $this$log$iv$iv8;
                            e22 = this.this$0.getLogger();
                            Client $i$f$debug = this.this$0;
                            boolean $i$f$info = false;
                            level$iv$iv = $this$info$iv;
                            LogLevel level$iv$iv6 = LogLevel.Info;
                            boolean $i$f$log = false;
                            if (!$this$log$iv$iv8.isEnabled(level$iv$iv6)) break block27;
                            object2 = level$iv$iv6;
                            object = $this$log$iv$iv8;
                            boolean bl = false;
                            string = $i$f$debug.getId() + ": closed with exception: " + ex22;
                            object.log(object2, (Object)string, null);
                            {
                                catch (Throwable throwable) {
                                    void $this$debug$iv7;
                                    $this$info$iv = this.this$0.getLogger();
                                    client = this.this$0;
                                    boolean $i$f$debug5 = false;
                                    level$iv$iv = $this$debug$iv7;
                                    level$iv$iv6 = LogLevel.Debug;
                                    $i$f$log = false;
                                    if (!$this$log$iv$iv8.isEnabled(level$iv$iv6)) throw throwable;
                                    object2 = level$iv$iv6;
                                    object = $this$log$iv$iv8;
                                    boolean bl9 = false;
                                    string = client.getId() + ": terminated.";
                                    object.log(object2, (Object)string, null);
                                    throw throwable;
                                }
                            }
                        }
                        Logger ex22 = this.this$0.getLogger();
                        $this$info$iv = this.this$0;
                        boolean $i$f$debug = false;
                        void $i$f$info = $this$debug$iv6;
                        level$iv$iv = LogLevel.Debug;
                        boolean $i$f$log = false;
                        if (!$this$log$iv$iv7.isEnabled((LogLevel)level$iv$iv)) return;
                        object2 = level$iv$iv;
                        object = $this$log$iv$iv7;
                        boolean bl4 = false;
                        string = ((Base)$this$info$iv).getId() + ": terminated.";
                        object.log(object2, (Object)string, null);
                        return;
                        catch (Throwable ex2222) {
                            LoggerKt.error((Logger)this.this$0.getLogger(), (String)(this.this$0.getId() + ": unhandled exception."), (Throwable)ex2222);
                            Logger ex2222 = this.this$0.getLogger();
                            $this$info$iv = this.this$0;
                            $i$f$debug = false;
                            $this$log$iv$iv7 = $this$debug$iv4;
                            level$iv$iv = LogLevel.Debug;
                            $i$f$log = false;
                            if (!$this$log$iv$iv7.isEnabled((LogLevel)level$iv$iv)) return;
                            object2 = level$iv$iv;
                            object = $this$log$iv$iv7;
                            bl5 = false;
                            string = ((Base)$this$info$iv).getId() + ": terminated.";
                            object.log(object2, (Object)string, null);
                            return;
                        }
                    }
                    Logger lastReportedErrorHash = this.this$0.getLogger();
                    e22 = this.this$0;
                    boolean $i$f$debug = false;
                    void errorHashCode = $this$debug$iv;
                    LogLevel level$iv$iv = LogLevel.Debug;
                    boolean $i$f$log = false;
                    if (!$this$log$iv$iv.isEnabled(level$iv$iv)) return;
                    object2 = level$iv$iv;
                    object = $this$log$iv$iv;
                    boolean bl6 = false;
                    string = ((Base)e22).getId() + ": terminated.";
                    object.log(object2, (Object)string, null);
                    return;
                }
            }), (int)21, null);
            RLifetimeKt.plusAssign((Lifetime)lifetime, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<Socket>)socket, thread2){
                final /* synthetic */ Ref.ObjectRef<Socket> $socket;
                final /* synthetic */ Thread $thread;
                {
                    this.$socket = $socket;
                    this.$thread = $thread;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$info$iv;
                    boolean $i$f$catch;
                    Object $this$log$iv$iv;
                    Object $this$debug$iv;
                    void $this$debug$iv2;
                    String string;
                    Object object;
                    LogLevel logLevel;
                    void $this$log$iv$iv2;
                    Logger $this$info$iv2;
                    Logger logger = this.getLogger();
                    Client client = this;
                    boolean $i$f$info = false;
                    void var4_8 = $this$info$iv2;
                    LogLevel level$iv$iv = LogLevel.Info;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv2.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        object = $this$log$iv$iv2;
                        boolean bl = false;
                        string = client.getId() + ": start terminating lifetime";
                        object.log(logLevel, (Object)string, null);
                    }
                    $this$info$iv2 = this.getLogger();
                    client = this;
                    boolean $i$f$debug22 = false;
                    $this$log$iv$iv2 = $this$debug$iv2;
                    level$iv$iv = LogLevel.Debug;
                    $i$f$log = false;
                    if ($this$log$iv$iv2.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        object = $this$log$iv$iv2;
                        boolean bl = false;
                        string = client.getId() + ": shutting down ack sending executor";
                        object.log(logLevel, (Object)string, null);
                    }
                    this.getAcktor().shutdown();
                    boolean sendBufferStopped = this.getSendBuffer().stop(Companion.getTimeout());
                    client = this.getLogger();
                    Client $i$f$debug22 = this;
                    boolean $i$f$debug32 = false;
                    level$iv$iv = $this$debug$iv;
                    LogLevel level$iv$iv2 = LogLevel.Debug;
                    boolean $i$f$log2 = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv2)) {
                        logLevel = level$iv$iv2;
                        object = $this$log$iv$iv;
                        boolean bl = false;
                        string = $i$f$debug22.getId() + ": send buffer stopped, success: " + sendBufferStopped;
                        object.log(logLevel, (Object)string, null);
                    }
                    $this$debug$iv = this.getLock();
                    $i$f$debug22 = this;
                    Ref.ObjectRef<Socket> $i$f$debug32 = this.$socket;
                    $this$log$iv$iv = $this$debug$iv;
                    synchronized ($this$log$iv$iv) {
                        void $this$log$iv$iv3;
                        boolean $i$a$-synchronized-SocketWire$Client$1$52 = false;
                        Logger $this$debug$iv3 = $i$f$debug22.getLogger();
                        boolean $i$f$debug = false;
                        Logger logger2 = $this$debug$iv3;
                        LogLevel level$iv$iv3 = LogLevel.Debug;
                        boolean $i$f$log3 = false;
                        if ($this$log$iv$iv3.isEnabled(level$iv$iv3)) {
                            LogLevel logLevel2 = level$iv$iv3;
                            void var13_40 = $this$log$iv$iv3;
                            boolean bl = false;
                            String string2 = $i$f$debug22.getId() + ": closing socket";
                            var13_40.log(logLevel2, (Object)string2, null);
                        }
                        $i$f$catch = false;
                        Object comment$iv$iv = null;
                        boolean $i$f$catch2 = false;
                        Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
                        boolean $i$f$catch3 = false;
                        try {
                            boolean bl = false;
                            Socket socket = (Socket)$i$f$debug32.element;
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Throwable e$iv$iv$iv) {
                            String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                            LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
                        }
                        $i$f$debug22.getLock().notifyAll();
                        Unit $i$a$-synchronized-SocketWire$Client$1$52 = Unit.INSTANCE;
                    }
                    $this$debug$iv = this.getLogger();
                    $i$f$debug22 = this;
                    boolean $i$f$debug = false;
                    $this$log$iv$iv = $this$debug$iv;
                    level$iv$iv = LogLevel.Debug;
                    $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        object = $this$log$iv$iv;
                        boolean bl = false;
                        string = $i$f$debug22.getId() + ": waiting for receiver thread";
                        object.log(logLevel, (Object)string, null);
                    }
                    $this$debug$iv = this.$thread;
                    boolean $i$f$catch4 = false;
                    Object comment$iv$iv = null;
                    boolean $i$f$catch22 = false;
                    Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
                    $i$f$catch = false;
                    try {
                        boolean bl = false;
                        ((Thread)$this$debug$iv).join(Companion.getTimeout().toMillis());
                    }
                    catch (Throwable e$iv$iv$iv) {
                        String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                        LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
                    }
                    $this$debug$iv = this.getLogger();
                    Client client2 = this;
                    boolean $i$f$info2 = false;
                    void $i$f$catch22 = $this$info$iv;
                    level$iv$iv = LogLevel.Info;
                    $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        object = $this$log$iv$iv;
                        boolean bl = false;
                        string = client2.getId() + ": termination finished";
                        object.log(logLevel, (Object)string, null);
                    }
                }
            }));
        }

        public /* synthetic */ Client(Lifetime lifetime, IScheduler iScheduler, int n, String string, InetAddress inetAddress, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                InetAddress inetAddress2 = InetAddress.getLoopbackAddress();
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getLoopbackAddress()");
                inetAddress = inetAddress2;
            }
            this(lifetime, iScheduler, n, string, inetAddress);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Companion;", "", "()V", "ack_msg_len", "", "default_max_msg_len", "disconnectedPauseReason", "", "maximumHeartbeatDelay", "ping_len", "pkg_header_len", "timeout", "Ljava/time/Duration;", "getTimeout", "()Ljava/time/Duration;", "connectionEstablished", "", "timeStamp", "notionTimestamp", "rd-framework"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getTimeout() {
            return timeout;
        }

        private final boolean connectionEstablished(int timeStamp, int notionTimestamp) {
            return timeStamp - notionTimestamp <= 3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Server;", "Lcom/jetbrains/rd/framework/SocketWire$Base;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "port", "", "optId", "", "allowRemoteConnections", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/lang/Integer;Ljava/lang/String;Z)V", "ss", "Ljava/net/ServerSocket;", "allowReconnect", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/net/ServerSocket;Ljava/lang/String;Z)V", "getPort", "()I", "Companion", "rd-framework"})
    public static final class Server
    extends Base {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int port;

        public Server(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, @NotNull ServerSocket ss, @Nullable String optId, boolean allowReconnect) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            Intrinsics.checkNotNullParameter((Object)ss, (String)"ss");
            String string = optId;
            if (string == null) {
                string = "ServerSocket";
            }
            super(string, lifetime, scheduler);
            this.port = ss.getLocalPort();
            Ref.ObjectRef socket = new Ref.ObjectRef();
            String string2 = this.getId();
            Thread thread2 = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)string2, (int)0, (Function0)((Function0)new Function0<Unit>(this, lifetime, ss, allowReconnect, (Ref.ObjectRef<Socket>)socket){
                final /* synthetic */ Server this$0;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ ServerSocket $ss;
                final /* synthetic */ boolean $allowReconnect;
                final /* synthetic */ Ref.ObjectRef<Socket> $socket;
                {
                    this.this$0 = $receiver;
                    this.$lifetime = $lifetime;
                    this.$ss = $ss;
                    this.$allowReconnect = $allowReconnect;
                    this.$socket = $socket;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$log$iv$iv;
                    void $this$debug$iv;
                    Logger $this$catch$iv;
                    Logger logger = this.this$0.getLogger();
                    Object object = this.$lifetime;
                    Server server = this.this$0;
                    ServerSocket serverSocket = this.$ss;
                    boolean bl = this.$allowReconnect;
                    Ref.ObjectRef<Socket> objectRef = this.$socket;
                    boolean $i$f$catch = false;
                    void var8_11 = $this$catch$iv;
                    Object comment$iv$iv = null;
                    boolean $i$f$catch2 = false;
                    try {
                        boolean bl2 = false;
                        while (RLifetimeKt.isAlive((Lifetime)object)) {
                            Logger $i$a$-synchronized-SocketWire$Server$thread$1$1$3;
                            String string;
                            Object object2;
                            LogLevel logLevel;
                            Object $this$log$iv$iv2;
                            boolean $i$f$log;
                            LogLevel level$iv$iv;
                            boolean $i$f$debug;
                            Logger $this$debug$iv2;
                            try {
                                $this$debug$iv2 = server.getLogger();
                                $i$f$debug = false;
                                Logger logger2 = $this$debug$iv2;
                                level$iv$iv = LogLevel.Debug;
                                $i$f$log = false;
                                if ($this$log$iv$iv2.isEnabled(level$iv$iv)) {
                                    logLevel = level$iv$iv;
                                    object2 = $this$log$iv$iv2;
                                    boolean bl3 = false;
                                    string = server.getId() + ": listening " + serverSocket.getLocalSocketAddress();
                                    object2.log(logLevel, (Object)string, null);
                                }
                                Socket s = serverSocket.accept();
                                s.setTcpNoDelay(true);
                                $this$log$iv$iv2 = server.getLock();
                                synchronized ($this$log$iv$iv2) {
                                    boolean bl4 = false;
                                    if (!RLifetimeKt.isAlive((Lifetime)object)) {
                                        void $this$log$iv$iv3;
                                        Logger $this$debug$iv3 = server.getLogger();
                                        boolean $i$f$debug2 = false;
                                        Logger logger3 = $this$debug$iv3;
                                        LogLevel level$iv$iv2 = LogLevel.Debug;
                                        boolean $i$f$log2 = false;
                                        if ($this$log$iv$iv3.isEnabled(level$iv$iv2)) {
                                            LogLevel logLevel2 = level$iv$iv2;
                                            void var25_46 = $this$log$iv$iv3;
                                            boolean bl5 = false;
                                            String string2 = server.getId() + " : connected, but lifetime is already canceled, closing socket";
                                            var25_46.log(logLevel2, (Object)string2, null);
                                        }
                                        boolean $i$f$catch3 = false;
                                        Object comment$iv$iv2 = null;
                                        boolean $i$f$catch4 = false;
                                        Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
                                        boolean $i$f$catch5 = false;
                                        try {
                                            boolean bl6 = false;
                                            s.close();
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            CharSequence cfr_ignored_0 = (CharSequence)comment$iv$iv2;
                                            String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                                            LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
                                        }
                                        return;
                                    }
                                    objectRef.element = s;
                                    $i$a$-synchronized-SocketWire$Server$thread$1$1$3 = Unit.INSTANCE;
                                }
                                OptProperty<Socket> optProperty = server.getSocketProvider();
                                Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                                optProperty.set((Object)s);
                            }
                            catch (SocketException ex) {
                                void $this$log$iv$iv4;
                                Logger $this$debug$iv4 = server.getLogger();
                                boolean $i$f$debug3 = false;
                                $i$a$-synchronized-SocketWire$Server$thread$1$1$3 = $this$debug$iv4;
                                LogLevel level$iv$iv3 = LogLevel.Debug;
                                boolean $i$f$log3 = false;
                                if ($this$log$iv$iv4.isEnabled(level$iv$iv3)) {
                                    logLevel = level$iv$iv3;
                                    object2 = $this$log$iv$iv4;
                                    boolean bl7 = false;
                                    string = server.getId() + " closed with exception: " + ex;
                                    object2.log(logLevel, (Object)string, null);
                                }
                            }
                            catch (Exception ex) {
                                LoggerKt.error((Logger)server.getLogger(), (String)(server.getId() + " closed with exception"), (Throwable)ex);
                            }
                            if (!bl) {
                                void $this$log$iv$iv5;
                                $this$debug$iv2 = server.getLogger();
                                boolean $i$f$debug4 = false;
                                Logger $i$f$debug3 = $this$debug$iv2;
                                level$iv$iv = LogLevel.Debug;
                                boolean $i$f$log4 = false;
                                if ($this$log$iv$iv5.isEnabled(level$iv$iv)) {
                                    logLevel = level$iv$iv;
                                    object2 = $this$log$iv$iv5;
                                    boolean bl8 = false;
                                    string = server.getId() + ": finished listening on " + serverSocket.getLocalSocketAddress() + ".";
                                    object2.log(logLevel, (Object)string, null);
                                }
                                break;
                            }
                            $this$debug$iv2 = server.getLogger();
                            $i$f$debug = false;
                            $this$log$iv$iv2 = $this$debug$iv2;
                            level$iv$iv = LogLevel.Debug;
                            $i$f$log = false;
                            if (!$this$log$iv$iv2.isEnabled(level$iv$iv)) continue;
                            logLevel = level$iv$iv;
                            object2 = $this$log$iv$iv2;
                            boolean bl9 = false;
                            string = server.getId() + ": waiting for reconnection on " + serverSocket.getLocalSocketAddress() + ".";
                            object2.log(logLevel, (Object)string, null);
                        }
                    }
                    catch (Throwable e$iv$iv) {
                        void $this$catch$iv$iv;
                        CharSequence cfr_ignored_1 = (CharSequence)comment$iv$iv;
                        String sfx$iv$iv = e$iv$iv.getClass().getName() + " " + e$iv$iv.getMessage() + "";
                        LoggerKt.error((Logger)$this$catch$iv$iv, (String)("Catch " + sfx$iv$iv), (Throwable)e$iv$iv);
                    }
                    $this$catch$iv = this.this$0.getLogger();
                    object = this.this$0;
                    boolean $i$f$debug = false;
                    serverSocket = $this$debug$iv;
                    LogLevel level$iv$iv = LogLevel.Debug;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var31_54 = $this$log$iv$iv;
                        boolean bl10 = false;
                        String string = ((Base)object).getId() + ": terminated.";
                        var31_54.log(logLevel, (Object)string, null);
                    }
                }
            }), (int)21, null);
            lifetime.onTerminationIfAlive((Function0)new Function0<Unit>((Ref.ObjectRef<Socket>)socket, thread2){
                final /* synthetic */ Ref.ObjectRef<Socket> $socket;
                final /* synthetic */ Thread $thread;
                {
                    this.$socket = $socket;
                    this.$thread = $thread;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$log$iv$iv;
                    void $this$info$iv;
                    void $this$log$iv$iv2;
                    Object $this$debug$iv;
                    void $this$debug$iv2;
                    String string;
                    void var23_20;
                    LogLevel logLevel;
                    void $this$log$iv$iv3;
                    Logger $this$info$iv2;
                    Logger logger = this.getLogger();
                    Server server = this;
                    boolean $i$f$info = false;
                    void var4_8 = $this$info$iv2;
                    LogLevel level$iv$iv = LogLevel.Info;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv3.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        var23_20 = $this$log$iv$iv3;
                        boolean bl = false;
                        string = server.getId() + ": start terminating lifetime";
                        var23_20.log(logLevel, (Object)string, null);
                    }
                    $this$info$iv2 = this.getLogger();
                    server = this;
                    boolean $i$f$debug22 = false;
                    $this$log$iv$iv3 = $this$debug$iv2;
                    level$iv$iv = LogLevel.Debug;
                    $i$f$log = false;
                    if ($this$log$iv$iv3.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        var23_20 = $this$log$iv$iv3;
                        boolean bl = false;
                        string = server.getId() + ": shutting down ack sending executor";
                        var23_20.log(logLevel, (Object)string, null);
                    }
                    this.getAcktor().shutdown();
                    boolean sendBufferStopped = this.getSendBuffer().stop(SocketWire.Companion.getTimeout());
                    server = this.getLogger();
                    Ref.ObjectRef<Socket> $i$f$debug22 = this;
                    boolean $i$f$debug = false;
                    level$iv$iv = $this$debug$iv;
                    LogLevel level$iv$iv2 = LogLevel.Debug;
                    boolean $i$f$log2 = false;
                    if ($this$log$iv$iv2.isEnabled(level$iv$iv2)) {
                        logLevel = level$iv$iv2;
                        var23_20 = $this$log$iv$iv2;
                        boolean bl = false;
                        string = $i$f$debug22.getId() + ": send buffer stopped, success: " + sendBufferStopped;
                        var23_20.log(logLevel, (Object)string, null);
                    }
                    $this$debug$iv = this;
                    $i$f$debug22 = this.$socket;
                    boolean $i$f$catch = false;
                    Object comment$iv$iv = null;
                    boolean $i$f$catch2 = false;
                    Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
                    boolean $i$f$catch3 = false;
                    try {
                        boolean bl = false;
                        Object object = ((Base)$this$debug$iv).getLock();
                        synchronized (object) {
                            void $this$log$iv$iv4;
                            boolean bl2 = false;
                            Logger $this$debug$iv3 = ((Base)$this$debug$iv).getLogger();
                            boolean $i$f$debug3 = false;
                            Logger logger2 = $this$debug$iv3;
                            LogLevel level$iv$iv3 = LogLevel.Debug;
                            boolean $i$f$log3 = false;
                            if ($this$log$iv$iv4.isEnabled(level$iv$iv3)) {
                                LogLevel logLevel2 = level$iv$iv3;
                                void var18_40 = $this$log$iv$iv4;
                                boolean bl3 = false;
                                String string2 = ((Base)$this$debug$iv).getId() + ": closing socket";
                                var18_40.log(logLevel2, (Object)string2, null);
                            }
                            Socket socket = (Socket)$i$f$debug22.element;
                            if (socket != null) {
                                socket.close();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    catch (Throwable e$iv$iv$iv) {
                        String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                        LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
                    }
                    $this$debug$iv = this.$thread;
                    boolean $i$f$catch4 = false;
                    Object comment$iv$iv2 = null;
                    boolean $i$f$catch222 = false;
                    Logger $this$catch$iv$iv$iv2 = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
                    boolean $i$f$catch5 = false;
                    try {
                        boolean bl = false;
                        ((Thread)$this$debug$iv).join(SocketWire.Companion.getTimeout().toMillis());
                    }
                    catch (Throwable e$iv$iv$iv) {
                        String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
                        LoggerKt.error((Logger)$this$catch$iv$iv$iv2, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
                    }
                    $this$debug$iv = this.getLogger();
                    Server server2 = this;
                    boolean $i$f$info2 = false;
                    void $i$f$catch222 = $this$info$iv;
                    level$iv$iv = LogLevel.Info;
                    $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        var23_20 = $this$log$iv$iv;
                        boolean bl = false;
                        string = server2.getId() + ": termination finished";
                        var23_20.log(logLevel, (Object)string, null);
                    }
                }
            });
        }

        public /* synthetic */ Server(Lifetime lifetime, IScheduler iScheduler, ServerSocket serverSocket, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string = null;
            }
            this(lifetime, iScheduler, serverSocket, string, bl);
        }

        public final int getPort() {
            return this.port;
        }

        public Server(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, @Nullable Integer port, @Nullable String optId, boolean allowRemoteConnections) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this(lifetime, scheduler, Companion.createServerSocket$rd_framework(lifetime, port, allowRemoteConnections), optId, true);
        }

        public /* synthetic */ Server(Lifetime lifetime, IScheduler iScheduler, Integer n, String string, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                bl = false;
            }
            this(lifetime, iScheduler, n, string, bl);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Server$Companion;", "", "()V", "createServerSocket", "Ljava/net/ServerSocket;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "port", "", "allowRemoteConnections", "", "createServerSocket$rd_framework", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Integer;Z)Ljava/net/ServerSocket;", "rd-framework"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ServerSocket createServerSocket$rd_framework(@NotNull Lifetime lifetime, @Nullable Integer port, boolean allowRemoteConnections) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                InetAddress address = allowRemoteConnections ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName("127.0.0.1");
                Integer n = port;
                int portToBind = n != null ? n : 0;
                ServerSocket res = new ServerSocket();
                res.setReuseAddress(true);
                res.bind(new InetSocketAddress(address, portToBind), 0);
                lifetime.onTermination((Function0)new Function0<Unit>(res){
                    final /* synthetic */ ServerSocket $res;
                    {
                        this.$res = $res;
                        super(0);
                    }

                    public final void invoke() {
                        this.$res.close();
                    }
                });
                return res;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fB=\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001e0 H\u0096\u0001J+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0015\u0012\u0004\u0012\u00020\u001e0\"H\u0096\u0001J\u0011\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010%\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0096\u0001J\t\u0010(\u001a\u00020\u000bH\u0096\u0001J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*H\u0096\u0003J+\u0010+\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001e0 H\u0096\u0001R\u001e\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$ServerFactory;", "Lcom/jetbrains/rd/util/reactive/IViewableSet;", "Lcom/jetbrains/rd/framework/SocketWire$Server;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "wireParametersFactory", "Lkotlin/Function0;", "Lcom/jetbrains/rd/framework/SocketWire$WireParameters;", "port", "", "allowRemoteConnections", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function0;Ljava/lang/Integer;Z)V", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/lang/Integer;Z)V", "set", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function0;Ljava/lang/Integer;ZLcom/jetbrains/rd/util/reactive/ViewableSet;)V", "change", "Lcom/jetbrains/rd/util/reactive/ISource;", "Lcom/jetbrains/rd/util/reactive/IViewableSet$Event;", "getChange", "()Lcom/jetbrains/rd/util/reactive/ISource;", "localPort", "getLocalPort", "()I", "size", "getSize", "advise", "", "handler", "Lkotlin/Function2;", "Lcom/jetbrains/rd/util/reactive/AddRemove;", "Lkotlin/Function1;", "contains", "element", "containsAll", "elements", "", "isEmpty", "iterator", "", "view", "rd-framework"})
    public static final class ServerFactory
    implements IViewableSet<Server> {
        private final /* synthetic */ ViewableSet<Server> $$delegate_0;
        private final int localPort;

        private ServerFactory(Lifetime lifetime, Function0<WireParameters> wireParametersFactory, Integer port, boolean allowRemoteConnections, ViewableSet<Server> set2) {
            this.$$delegate_0 = set2;
            ServerSocket ss = Server.Companion.createServerSocket$rd_framework(lifetime, port, allowRemoteConnections);
            this.localPort = ss.getLocalPort();
            ServerFactory._init_$rec(lifetime, wireParametersFactory, ss, set2);
        }

        @NotNull
        public ISource<IViewableSet.Event<Server>> getChange() {
            return (ISource)this.$$delegate_0.getChange();
        }

        public int getSize() {
            return this.$$delegate_0.size();
        }

        public void advise(@NotNull Lifetime lifetime, @NotNull Function2<? super AddRemove, ? super Server, Unit> handler) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.$$delegate_0.advise(lifetime, handler);
        }

        public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super IViewableSet.Event<Server>, Unit> handler) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.$$delegate_0.advise(lifetime, handler);
        }

        public boolean contains(@NotNull Server element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.$$delegate_0.contains((Object)element);
        }

        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.$$delegate_0.containsAll(elements);
        }

        public boolean isEmpty() {
            return this.$$delegate_0.isEmpty();
        }

        @NotNull
        public Iterator<Server> iterator() {
            return this.$$delegate_0.iterator();
        }

        public void view(@NotNull Lifetime lifetime, @NotNull Function2<? super Lifetime, ? super Server, Unit> handler) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.$$delegate_0.view(lifetime, handler);
        }

        public ServerFactory(@NotNull Lifetime lifetime, @NotNull Function0<WireParameters> wireParametersFactory, @Nullable Integer port, boolean allowRemoteConnections) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(wireParametersFactory, (String)"wireParametersFactory");
            this(lifetime, wireParametersFactory, port, allowRemoteConnections, (ViewableSet<Server>)new ViewableSet(null, 1, null));
        }

        public /* synthetic */ ServerFactory(Lifetime lifetime, Function0 function0, Integer n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(lifetime, (Function0<WireParameters>)function0, n, bl);
        }

        public ServerFactory(@NotNull Lifetime lifetime, final @NotNull IScheduler scheduler, @Nullable Integer port, boolean allowRemoteConnections) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this(lifetime, (Function0<WireParameters>)((Function0)new Function0<WireParameters>(){

                @NotNull
                public final WireParameters invoke() {
                    return new WireParameters(scheduler, null);
                }
            }), port, allowRemoteConnections, (ViewableSet<Server>)new ViewableSet(null, 1, null));
        }

        public /* synthetic */ ServerFactory(Lifetime lifetime, IScheduler iScheduler, Integer n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(lifetime, iScheduler, n, bl);
        }

        public final int getLocalPort() {
            return this.localPort;
        }

        public boolean add(Server element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public boolean addAll(Collection<? extends Server> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public boolean remove(Object element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public boolean removeAll(Collection<? extends Object> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public boolean retainAll(Collection<? extends Object> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        private static final void _init_$rec(Lifetime $lifetime, Function0<WireParameters> $wireParametersFactory, ServerSocket ss, ViewableSet<Server> $set) {
            $lifetime.executeIfAlive((Function0)new Function0<Unit>($wireParametersFactory, $lifetime, ss, $set){
                final /* synthetic */ Function0<WireParameters> $wireParametersFactory;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ ServerSocket $ss;
                final /* synthetic */ ViewableSet<Server> $set;
                {
                    this.$wireParametersFactory = $wireParametersFactory;
                    this.$lifetime = $lifetime;
                    this.$ss = $ss;
                    this.$set = $set;
                    super(0);
                }

                public final void invoke() {
                    WireParameters wireParameters = (WireParameters)this.$wireParametersFactory.invoke();
                    IScheduler scheduler = wireParameters.component1();
                    String optId = wireParameters.component2();
                    Server s = new Server(this.$lifetime, scheduler, this.$ss, optId, false);
                    BoolPropertyExKt.whenTrue((IViewable)((IViewable)s.getConnected()), (Lifetime)this.$lifetime, (Function1)((Function1)new Function1<Lifetime, Unit>(this.$set, s, this.$lifetime, this.$wireParametersFactory, this.$ss){
                        final /* synthetic */ ViewableSet<Server> $set;
                        final /* synthetic */ Server $s;
                        final /* synthetic */ Lifetime $lifetime;
                        final /* synthetic */ Function0<WireParameters> $wireParametersFactory;
                        final /* synthetic */ ServerSocket $ss;
                        {
                            this.$set = $set;
                            this.$s = $s;
                            this.$lifetime = $lifetime;
                            this.$wireParametersFactory = $wireParametersFactory;
                            this.$ss = $ss;
                            super(1);
                        }

                        public final void invoke(@NotNull Lifetime lt) {
                            Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                            CollectionExKt.addUnique((Collection)((Collection)this.$set), (Lifetime)lt, (Object)this.$s);
                            ServerFactory.access$_init_$rec(this.$lifetime, this.$wireParametersFactory, this.$ss, this.$set);
                        }
                    }));
                }
            });
        }

        public static final /* synthetic */ void access$_init_$rec(Lifetime $lifetime, Function0 $wireParametersFactory, ServerSocket ss, ViewableSet $set) {
            ServerFactory._init_$rec($lifetime, (Function0<WireParameters>)$wireParametersFactory, ss, (ViewableSet<Server>)$set);
        }

        public <T> T[] toArray(T[] array2) {
            Intrinsics.checkNotNullParameter(array2, (String)"array");
            return CollectionToArray.toArray((Collection)((Collection)((Object)this)), (Object[])array2);
        }

        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)((Collection)((Object)this)));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$WireParameters;", "", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "id", "", "(Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getScheduler", "()Lcom/jetbrains/rd/util/reactive/IScheduler;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "rd-framework"})
    public static final class WireParameters {
        @NotNull
        private final IScheduler scheduler;
        @Nullable
        private final String id;

        public WireParameters(@NotNull IScheduler scheduler, @Nullable String id) {
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this.scheduler = scheduler;
            this.id = id;
        }

        @NotNull
        public final IScheduler getScheduler() {
            return this.scheduler;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final IScheduler component1() {
            return this.scheduler;
        }

        @Nullable
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final WireParameters copy(@NotNull IScheduler scheduler, @Nullable String id) {
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            return new WireParameters(scheduler, id);
        }

        public static /* synthetic */ WireParameters copy$default(WireParameters wireParameters, IScheduler iScheduler, String string, int n, Object object) {
            if ((n & 1) != 0) {
                iScheduler = wireParameters.scheduler;
            }
            if ((n & 2) != 0) {
                string = wireParameters.id;
            }
            return wireParameters.copy(iScheduler, string);
        }

        @NotNull
        public String toString() {
            return "WireParameters(scheduler=" + this.scheduler + ", id=" + this.id + ")";
        }

        public int hashCode() {
            int result = this.scheduler.hashCode();
            result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof WireParameters)) {
                return false;
            }
            WireParameters wireParameters = (WireParameters)other2;
            if (!Intrinsics.areEqual((Object)this.scheduler, (Object)wireParameters.scheduler)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.id, (Object)wireParameters.id);
        }
    }
}

