/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.generator.gradle;

import com.jetbrains.rd.generator.gradle.GradleGenerationSpec;
import com.jetbrains.rd.generator.gradle.RdGenExtension;
import groovy.lang.Closure;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J#\u0010\r\u001a\u0002022\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000104\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u00105J\n\u00106\u001a\u0004\u0018\u000107H\u0002J\u001f\u00108\u001a\u00020\"2\u0017\u00109\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002020:\u00a2\u0006\u0002\b;J\u0014\u00108\u001a\u00020\"2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\"0<J.\u0010=\u001a\b\u0012\u0004\u0012\u0002070>2\u0006\u0010?\u001a\u00020\u00002\u0016\u0010@\u001a\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0:H\u0002J3\u0010A\u001a\u0004\u0018\u0001HB\"\u0004\b\u0000\u0010B2\b\u0010C\u001a\u0004\u0018\u00010\u00002\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002HB0:H\u0002\u00a2\u0006\u0002\u0010DJ\u000e\u0010E\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0000J#\u0010.\u001a\u0002022\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000104\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u00105J\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0018\"\u0004\b%\u0010\u001aR\u001e\u0010&\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b'\u0010\u0012\"\u0004\b(\u0010\u0014R\u001c\u0010)\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0018\"\u0004\b+\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\fR\u0016\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010/\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u0010\u0014\u00a8\u0006G"}, d2={"Lcom/jetbrains/rd/generator/gradle/RdGenExtension;", "", "task", "Lorg/gradle/api/Task;", "(Lorg/gradle/api/Task;)V", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "classPathEntries", "", "", "getClassPathEntries", "()Ljava/util/List;", "classpath", "", "clearOutput", "", "getClearOutput", "()Ljava/lang/Boolean;", "setClearOutput", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "compiled", "getCompiled", "()Ljava/lang/String;", "setCompiled", "(Ljava/lang/String;)V", "filter", "getFilter", "setFilter", "force", "getForce", "setForce", "generators", "Lcom/jetbrains/rd/generator/gradle/GradleGenerationSpec;", "hashFolder", "getHashFolder", "setHashFolder", "lineNumbersInComments", "getLineNumbersInComments", "setLineNumbersInComments", "packages", "getPackages", "setPackages", "sourceFiles", "getSourceFiles", "sources", "verbose", "getVerbose", "setVerbose", "", "paths", "", "([Ljava/lang/Object;)V", "createGeneratorsFile", "Ljava/io/File;", "generator", "closure", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Lgroovy/lang/Closure;", "mergeFiles", "", "global", "getter", "mergeObject", "T", "defaults", "(Lcom/jetbrains/rd/generator/gradle/RdGenExtension;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "mergeWith", "toArguments", "rd-gen_gradlePlugin"})
public class RdGenExtension {
    @Nullable
    private String hashFolder;
    @Nullable
    private String compiled;
    @Nullable
    private Boolean force;
    @Nullable
    private Boolean clearOutput;
    @Nullable
    private String packages;
    @Nullable
    private String filter;
    @Nullable
    private Boolean verbose;
    @Nullable
    private Boolean lineNumbersInComments;
    private final List<GradleGenerationSpec> generators;
    private final List<Object> sources;
    private final List<Object> classpath;
    private final Project project;

    @NotNull
    public final RdGenExtension mergeWith(@NotNull RdGenExtension defaults) {
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        RdGenExtension result = new RdGenExtension(this.project);
        result.sources(this.mergeFiles(defaults, mergeWith.1.INSTANCE));
        result.hashFolder = (String)this.mergeObject(defaults, mergeWith.2.INSTANCE);
        result.compiled = (String)this.mergeObject(defaults, mergeWith.3.INSTANCE);
        result.classpath(this.mergeFiles(defaults, mergeWith.4.INSTANCE));
        result.packages = (String)this.mergeObject(defaults, mergeWith.5.INSTANCE);
        result.filter = (String)this.mergeObject(defaults, mergeWith.6.INSTANCE);
        result.force = (Boolean)this.mergeObject(defaults, mergeWith.7.INSTANCE);
        result.verbose = (Boolean)this.mergeObject(defaults, mergeWith.8.INSTANCE);
        result.lineNumbersInComments = (Boolean)this.mergeObject(defaults, mergeWith.9.INSTANCE);
        result.clearOutput = (Boolean)this.mergeObject(defaults, mergeWith.10.INSTANCE);
        List list = (List)this.mergeObject(defaults, mergeWith.11.INSTANCE);
        result.generators.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        return result;
    }

    private final <T> T mergeObject(RdGenExtension defaults, Function1<? super RdGenExtension, ? extends T> getter) {
        Object value = getter.invoke((Object)this);
        if (defaults == null) {
            return (T)value;
        }
        if (value == null) {
            return (T)getter.invoke((Object)defaults);
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return (T)getter.invoke((Object)defaults);
        }
        return (T)(value instanceof Map && ((Map)value).isEmpty() ? getter.invoke((Object)defaults) : value);
    }

    private final Set<File> mergeFiles(RdGenExtension global, Function1<? super RdGenExtension, ? extends List<?>> getter) {
        List<?> list = this.mergeObject(global, getter);
        Intrinsics.checkNotNull(list);
        List<?> mergedFiles = list;
        ConfigurableFileCollection configurableFileCollection = this.project.files(new Object[]{mergedFiles});
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(mergedFiles)");
        Set set = configurableFileCollection.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.files(mergedFiles).files");
        return set;
    }

    @NotNull
    public final List<String> toArguments() {
        File generatorsFile;
        boolean generateLineNumbersInComments;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-s");
        arguments.add(String.join((CharSequence)";", (Iterable<? extends CharSequence>)this.getSourceFiles()));
        if (this.hashFolder != null) {
            arguments.add("-h");
            arguments.add(this.hashFolder);
        }
        if (this.compiled != null) {
            arguments.add("--compiled");
            arguments.add(this.compiled);
        }
        if (CollectionsKt.any((Iterable)this.getClassPathEntries())) {
            arguments.add("-c");
            arguments.add(String.join((CharSequence)System.getProperty("path.separator"), (Iterable<? extends CharSequence>)this.getClassPathEntries()));
        }
        if (Intrinsics.areEqual((Object)this.force, (Object)true)) {
            arguments.add("-f");
        }
        if (Intrinsics.areEqual((Object)this.clearOutput, (Object)true)) {
            arguments.add("-x");
        }
        if (this.packages != null) {
            arguments.add("-p");
            arguments.add(this.packages);
        }
        if (this.filter != null) {
            arguments.add("--filter");
            arguments.add(this.filter);
        }
        if (Intrinsics.areEqual((Object)this.verbose, (Object)true)) {
            arguments.add("-v");
        }
        Boolean bl = this.lineNumbersInComments;
        boolean bl2 = generateLineNumbersInComments = bl != null ? bl : true;
        if (!generateLineNumbersInComments) {
            arguments.add("--no-line-numbers");
        }
        if ((generatorsFile = this.createGeneratorsFile()) != null) {
            arguments.add("-g");
            arguments.add(generatorsFile.getPath());
        }
        return arguments;
    }

    @Nullable
    public final String getHashFolder() {
        return this.hashFolder;
    }

    public final void setHashFolder(@Nullable String string2) {
        this.hashFolder = string2;
    }

    @Nullable
    public final String getCompiled() {
        return this.compiled;
    }

    public final void setCompiled(@Nullable String string2) {
        this.compiled = string2;
    }

    @Nullable
    public final Boolean getForce() {
        return this.force;
    }

    public final void setForce(@Nullable Boolean bl) {
        this.force = bl;
    }

    @Nullable
    public final Boolean getClearOutput() {
        return this.clearOutput;
    }

    public final void setClearOutput(@Nullable Boolean bl) {
        this.clearOutput = bl;
    }

    @Nullable
    public final String getPackages() {
        return this.packages;
    }

    public final void setPackages(@Nullable String string2) {
        this.packages = string2;
    }

    @Nullable
    public final String getFilter() {
        return this.filter;
    }

    public final void setFilter(@Nullable String string2) {
        this.filter = string2;
    }

    @Nullable
    public final Boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(@Nullable Boolean bl) {
        this.verbose = bl;
    }

    @Nullable
    public final Boolean getLineNumbersInComments() {
        return this.lineNumbersInComments;
    }

    public final void setLineNumbersInComments(@Nullable Boolean bl) {
        this.lineNumbersInComments = bl;
    }

    @NotNull
    public final GradleGenerationSpec generator(@NotNull Closure<GradleGenerationSpec> closure) {
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        GradleGenerationSpec gradleGenerationSpec = new GradleGenerationSpec();
        boolean bl = false;
        boolean bl2 = false;
        GradleGenerationSpec $this$apply = gradleGenerationSpec;
        boolean bl3 = false;
        this.project.configure((Object)$this$apply, closure);
        this.generators.add($this$apply);
        return gradleGenerationSpec;
    }

    @NotNull
    public final GradleGenerationSpec generator(@NotNull Function1<? super GradleGenerationSpec, Unit> closure) {
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        GradleGenerationSpec gradleGenerationSpec = new GradleGenerationSpec();
        boolean bl = false;
        boolean bl2 = false;
        GradleGenerationSpec $this$apply = gradleGenerationSpec;
        boolean bl3 = false;
        closure.invoke((Object)$this$apply);
        this.generators.add($this$apply);
        return gradleGenerationSpec;
    }

    public final void sources(Object ... paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        CollectionsKt.addAll((Collection)this.sources, (Object[])paths);
    }

    public final void classpath(Object ... paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        CollectionsKt.addAll((Collection)this.classpath, (Object[])paths);
    }

    private final List<String> getSourceFiles() {
        ConfigurableFileCollection configurableFileCollection = this.project.files(new Object[]{this.sources});
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(sources)");
        List<String> list = configurableFileCollection.getFiles().stream().map(sourceFiles.1.INSTANCE).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"project.files(sources).f\u2026lect(Collectors.toList())");
        return list;
    }

    private final List<String> getClassPathEntries() {
        ConfigurableFileCollection configurableFileCollection = this.project.files(new Object[]{this.classpath});
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(classpath)");
        List<String> list = configurableFileCollection.getFiles().stream().map(classPathEntries.1.INSTANCE).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"project.files(classpath)\u2026lect(Collectors.toList())");
        return list;
    }

    private final File createGeneratorsFile() {
        if (this.generators.isEmpty()) {
            return null;
        }
        File file2 = Files.createTempFile("rd-", ".generators", new FileAttribute[0]).toFile();
        StringBuilder sb = new StringBuilder();
        for (GradleGenerationSpec generator : this.generators) {
            sb.append(generator.toString());
            sb.append("\n");
        }
        Path path = file2.toPath();
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        String string3 = string2;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write(path, byArray, new OpenOption[0]);
        return file2;
    }

    public RdGenExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.generators = new ArrayList();
        this.sources = new ArrayList();
        this.classpath = new ArrayList();
    }

    public RdGenExtension(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Project project = task.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.project");
        this(project);
    }

    public static final /* synthetic */ List access$getSources$p(RdGenExtension $this) {
        return $this.sources;
    }

    public static final /* synthetic */ List access$getClasspath$p(RdGenExtension $this) {
        return $this.classpath;
    }

    public static final /* synthetic */ List access$getGenerators$p(RdGenExtension $this) {
        return $this.generators;
    }
}

