/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.generator.nova;

import com.jetbrains.rd.generator.nova.Class;
import com.jetbrains.rd.generator.nova.Context;
import com.jetbrains.rd.generator.nova.Declaration;
import com.jetbrains.rd.generator.nova.Enum;
import com.jetbrains.rd.generator.nova.FlowKind;
import com.jetbrains.rd.generator.nova.FlowTransform;
import com.jetbrains.rd.generator.nova.IAttributedType;
import com.jetbrains.rd.generator.nova.IGenerator;
import com.jetbrains.rd.generator.nova.IHasItemType;
import com.jetbrains.rd.generator.nova.INonNullable;
import com.jetbrains.rd.generator.nova.INonNullableScalar;
import com.jetbrains.rd.generator.nova.INullable;
import com.jetbrains.rd.generator.nova.IScalar;
import com.jetbrains.rd.generator.nova.IType;
import com.jetbrains.rd.generator.nova.PredefinedType;
import com.jetbrains.rd.generator.nova.ScalarAttributedType;
import com.jetbrains.rd.generator.nova.SettingsHolder;
import com.jetbrains.rd.util.hash.IncrementalHash64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006 !\"#$%B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fR\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0005&'()*\u00a8\u0006+"}, d2={"Lcom/jetbrains/rd/generator/nova/Member;", "Lcom/jetbrains/rd/generator/nova/SettingsHolder;", "name", "", "referencedTypes", "", "Lcom/jetbrains/rd/generator/nova/IType;", "(Ljava/lang/String;Ljava/util/List;)V", "documentation", "getDocumentation", "()Ljava/lang/String;", "setDocumentation", "(Ljava/lang/String;)V", "getName", "owner", "Lcom/jetbrains/rd/generator/nova/Declaration;", "getOwner", "()Lcom/jetbrains/rd/generator/nova/Declaration;", "setOwner", "(Lcom/jetbrains/rd/generator/nova/Declaration;)V", "getReferencedTypes", "()Ljava/util/List;", "expandItemTypes", "type", "serializationHash", "Lcom/jetbrains/rd/util/hash/IncrementalHash64;", "initial", "toString", "validate", "", "errors", "", "Const", "EnumConst", "ExtensionDelegate", "Field", "Method", "Reactive", "Lcom/jetbrains/rd/generator/nova/Member$EnumConst;", "Lcom/jetbrains/rd/generator/nova/Member$Field;", "Lcom/jetbrains/rd/generator/nova/Member$Method;", "Lcom/jetbrains/rd/generator/nova/Member$Const;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive;", "rd-gen"})
public abstract class Member
extends SettingsHolder {
    @NotNull
    private final String name;
    @Nullable
    private String documentation;
    @NotNull
    public Declaration owner;
    @NotNull
    private final List<IType> referencedTypes;

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public final String getDocumentation() {
        return this.documentation;
    }

    public final void setDocumentation(@Nullable String string2) {
        this.documentation = string2;
    }

    @NotNull
    public final Declaration getOwner() {
        Declaration declaration = this.owner;
        if (declaration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"owner");
        }
        return declaration;
    }

    public final void setOwner(@NotNull Declaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"<set-?>");
        this.owner = declaration;
    }

    @NotNull
    public final List<IType> getReferencedTypes() {
        return this.referencedTypes;
    }

    private final List<IType> expandItemTypes(IType type) {
        List res2 = CollectionsKt.mutableListOf((Object[])new IType[]{type});
        if (type instanceof IHasItemType) {
            res2.addAll((Collection)this.expandItemTypes(((IHasItemType)type).getItemType()));
        }
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IncrementalHash64 serializationHash(@NotNull IncrementalHash64 initial) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        Iterable iterable = this.referencedTypes;
        IncrementalHash64 initial$iv = initial.mix(this.getName());
        boolean $i$f$fold = false;
        IncrementalHash64 accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void type;
            IType iType = (IType)element$iv;
            IncrementalHash64 acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.mix(type.getName());
        }
        return accumulator$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void validate(@NotNull List<String> errors) {
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Iterator iterator;
        String m;
        block17: {
            block19: {
                block18: {
                    boolean bl2;
                    block16: {
                        Intrinsics.checkNotNullParameter(errors, (String)"errors");
                        StringBuilder stringBuilder = new StringBuilder().append('\'');
                        Declaration declaration = this.owner;
                        if (declaration == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"owner");
                        }
                        m = stringBuilder.append(declaration.getName()).append('.').append(this.getName()).append('\'').toString();
                        if (StringsKt.isBlank((CharSequence)this.getName())) {
                            errors.add("Member " + m + " is invalid: empty name");
                            return;
                        }
                        char c = this.getName().charAt(0);
                        boolean bl3 = false;
                        if (!Character.isLetter(c)) break block18;
                        CharSequence $this$all$iv = this.getName();
                        boolean $i$f$all = false;
                        iterator = $this$all$iv;
                        for (int i = 0; i < iterator.length(); ++i) {
                            char element$iv;
                            char it = element$iv = iterator.charAt(i);
                            boolean bl4 = false;
                            char c2 = it;
                            boolean bl5 = false;
                            if (Character.isLetterOrDigit(c2) || it == '_') continue;
                            bl2 = false;
                            break block16;
                        }
                        bl2 = true;
                    }
                    if (bl2) break block19;
                }
                errors.add("Member " + m + " is invalid: must be [A-Za-z][A-Za-z0-9_]*");
                return;
            }
            String string2 = StringsKt.capitalize((String)this.getName());
            Declaration declaration = this.owner;
            if (declaration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"owner");
            }
            if (Intrinsics.areEqual((Object)string2, (Object)declaration.getName())) {
                errors.add("Member " + m + " is invalid: name cannot be the same as its enclosing declaration");
                return;
            }
            Declaration declaration2 = this.owner;
            if (declaration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"owner");
            }
            $this$any$iv = declaration2.getOwnMembers();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Member it = (Member)element$iv;
                    boolean bl6 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)this) ^ true && Intrinsics.areEqual((Object)it.getName(), (Object)this.getName()))) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            errors.add("Member " + m + " is duplicated");
            return;
        } else {
            Member it;
            Declaration declaration = this.owner;
            if (declaration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"owner");
            }
            $this$any$iv = declaration.getMembersOfBaseClasses();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return;
            }
            iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return;
                Object element$iv = iterator.next();
                it = (Member)element$iv;
                boolean bl7 = false;
            } while (!Intrinsics.areEqual((Object)it.getName(), (Object)this.getName()));
            boolean bl8 = true;
            if (!bl8) return;
            errors.add("Member " + m + " is contained by base class");
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.getName();
    }

    /*
     * WARNING - void declaration
     */
    private Member(String name2, List<? extends IType> referencedTypes) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        this.name = StringsKt.decapitalize((String)name2);
        Iterable iterable = referencedTypes;
        Member member = this;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IType it = (IType)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.expandItemTypes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        member.referencedTypes = CollectionsKt.distinct((Iterable)list);
    }

    public /* synthetic */ Member(String name2, List referencedTypes, DefaultConstructorMarker $constructor_marker) {
        this(name2, referencedTypes);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$EnumConst;", "Lcom/jetbrains/rd/generator/nova/Member;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "rd-gen"})
    public static final class EnumConst
    extends Member {
        @NotNull
        private final String name;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public EnumConst(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            super(name2, CollectionsKt.emptyList(), null);
            this.name = name2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Field;", "Lcom/jetbrains/rd/generator/nova/Member;", "name", "", "type", "Lcom/jetbrains/rd/generator/nova/IType;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/IType;)V", "defaultValue", "", "getDefaultValue$rd_gen", "()Ljava/lang/Object;", "setDefaultValue$rd_gen", "(Ljava/lang/Object;)V", "emptyCtorSuppressed", "", "getEmptyCtorSuppressed$rd_gen", "()Z", "setEmptyCtorSuppressed$rd_gen", "(Z)V", "isOptional", "isOptional$rd_gen", "setOptional$rd_gen", "getType", "()Lcom/jetbrains/rd/generator/nova/IType;", "usedInEquals", "getUsedInEquals$rd_gen", "setUsedInEquals$rd_gen", "rd-gen"})
    public static final class Field
    extends Member {
        private boolean emptyCtorSuppressed;
        private boolean isOptional;
        @Nullable
        private Object defaultValue;
        private boolean usedInEquals;
        @NotNull
        private final IType type;

        public final boolean getEmptyCtorSuppressed$rd_gen() {
            return this.emptyCtorSuppressed;
        }

        public final void setEmptyCtorSuppressed$rd_gen(boolean bl) {
            this.emptyCtorSuppressed = bl;
        }

        public final boolean isOptional$rd_gen() {
            return this.isOptional;
        }

        public final void setOptional$rd_gen(boolean bl) {
            this.isOptional = bl;
        }

        @Nullable
        public final Object getDefaultValue$rd_gen() {
            return this.defaultValue;
        }

        public final void setDefaultValue$rd_gen(@Nullable Object object) {
            this.defaultValue = object;
        }

        public final boolean getUsedInEquals$rd_gen() {
            return this.usedInEquals;
        }

        public final void setUsedInEquals$rd_gen(boolean bl) {
            this.usedInEquals = bl;
        }

        @NotNull
        public final IType getType() {
            return this.type;
        }

        public Field(@NotNull String name2, @NotNull IType type) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(name2, CollectionsKt.listOf((Object)type), null);
            this.type = type;
            this.usedInEquals = true;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\b0\u0007\u00a2\u0006\u0002\u0010\tR#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Method;", "Lcom/jetbrains/rd/generator/nova/Member;", "name", "", "resultType", "Lcom/jetbrains/rd/generator/nova/IType;", "args", "", "Lkotlin/Pair;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/IType;Ljava/util/List;)V", "getArgs", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getResultType", "()Lcom/jetbrains/rd/generator/nova/IType;", "rd-gen"})
    public static final class Method
    extends Member {
        @NotNull
        private final String name;
        @NotNull
        private final IType resultType;
        @NotNull
        private final List<Pair<String, IType>> args;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final IType getResultType() {
            return this.resultType;
        }

        @NotNull
        public final List<Pair<String, IType>> getArgs() {
            return this.args;
        }

        /*
         * WARNING - void declaration
         */
        public Method(@NotNull String name2, @NotNull IType resultType, @NotNull List<? extends Pair<String, ? extends IType>> args) {
            Collection<IType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resultType, (String)"resultType");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Iterable iterable = args;
            String string2 = name2;
            Method method = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IType iType = (IType)it.getSecond();
                collection.add(iType);
            }
            collection = (List)destination$iv$iv;
            super(string2, CollectionsKt.plus((Collection)collection, (Object)resultType), null);
            this.name = name2;
            this.resultType = resultType;
            this.args = args;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\f\rB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Const;", "Lcom/jetbrains/rd/generator/nova/Member;", "name", "", "type", "Lcom/jetbrains/rd/generator/nova/IScalar;", "value", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/IScalar;Ljava/lang/String;)V", "getType", "()Lcom/jetbrains/rd/generator/nova/IScalar;", "getValue", "()Ljava/lang/String;", "Enum", "Integral", "Lcom/jetbrains/rd/generator/nova/Member$Const$Integral;", "Lcom/jetbrains/rd/generator/nova/Member$Const$Enum;", "rd-gen"})
    public static abstract class Const
    extends Member {
        @NotNull
        private final IScalar type;
        @NotNull
        private final String value;

        @NotNull
        public final IScalar getType() {
            return this.type;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        private Const(String name2, IScalar type, String value) {
            super(name2, CollectionsKt.listOf((Object)type), null);
            this.type = type;
            this.value = value;
        }

        public /* synthetic */ Const(String name2, IScalar type, String value, DefaultConstructorMarker $constructor_marker) {
            this(name2, type, value);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Const$Integral;", "Lcom/jetbrains/rd/generator/nova/Member$Const;", "name", "", "type", "Lcom/jetbrains/rd/generator/nova/PredefinedType;", "value", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/PredefinedType;Ljava/lang/String;)V", "Lcom/jetbrains/rd/generator/nova/ScalarAttributedType;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/ScalarAttributedType;Ljava/lang/String;)V", "rd-gen"})
        public static final class Integral
        extends Const {
            public Integral(@NotNull String name2, @NotNull PredefinedType type, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(name2, type, value, null);
            }

            public Integral(@NotNull String name2, @NotNull ScalarAttributedType<? extends PredefinedType> type, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter(type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(name2, type, value, null);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Const$Enum;", "Lcom/jetbrains/rd/generator/nova/Member$Const;", "name", "", "type", "Lcom/jetbrains/rd/generator/nova/Enum;", "value", "Lcom/jetbrains/rd/generator/nova/Member$EnumConst;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/Enum;Lcom/jetbrains/rd/generator/nova/Member$EnumConst;)V", "rd-gen"})
        public static final class Enum
        extends Const {
            public Enum(@NotNull String name2, @NotNull com.jetbrains.rd.generator.nova.Enum type, @NotNull EnumConst value) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(name2, type, value.getName(), null);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$ExtensionDelegate;", "", "klass", "Lkotlin/reflect/KClass;", "Lcom/jetbrains/rd/generator/nova/IGenerator;", "flowTransform", "Lcom/jetbrains/rd/generator/nova/FlowTransform;", "delegateFqn", "", "factoryFqn", "(Lkotlin/reflect/KClass;Lcom/jetbrains/rd/generator/nova/FlowTransform;Ljava/lang/String;Ljava/lang/String;)V", "getDelegateFqn", "()Ljava/lang/String;", "getFactoryFqn", "getFlowTransform", "()Lcom/jetbrains/rd/generator/nova/FlowTransform;", "getKlass", "()Lkotlin/reflect/KClass;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "rd-gen"})
    public static final class ExtensionDelegate {
        @NotNull
        private final KClass<? extends IGenerator> klass;
        @Nullable
        private final FlowTransform flowTransform;
        @NotNull
        private final String delegateFqn;
        @Nullable
        private final String factoryFqn;

        @NotNull
        public final KClass<? extends IGenerator> getKlass() {
            return this.klass;
        }

        @Nullable
        public final FlowTransform getFlowTransform() {
            return this.flowTransform;
        }

        @NotNull
        public final String getDelegateFqn() {
            return this.delegateFqn;
        }

        @Nullable
        public final String getFactoryFqn() {
            return this.factoryFqn;
        }

        public ExtensionDelegate(@NotNull KClass<? extends IGenerator> klass, @Nullable FlowTransform flowTransform, @NotNull String delegateFqn, @Nullable String factoryFqn) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)delegateFqn, (String)"delegateFqn");
            this.klass = klass;
            this.flowTransform = flowTransform;
            this.delegateFqn = delegateFqn;
            this.factoryFqn = factoryFqn;
        }

        public /* synthetic */ ExtensionDelegate(KClass kClass, FlowTransform flowTransform, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            this((KClass<? extends IGenerator>)kClass, flowTransform, string2, string3);
        }

        @NotNull
        public final KClass<? extends IGenerator> component1() {
            return this.klass;
        }

        @Nullable
        public final FlowTransform component2() {
            return this.flowTransform;
        }

        @NotNull
        public final String component3() {
            return this.delegateFqn;
        }

        @Nullable
        public final String component4() {
            return this.factoryFqn;
        }

        @NotNull
        public final ExtensionDelegate copy(@NotNull KClass<? extends IGenerator> klass, @Nullable FlowTransform flowTransform, @NotNull String delegateFqn, @Nullable String factoryFqn) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)delegateFqn, (String)"delegateFqn");
            return new ExtensionDelegate(klass, flowTransform, delegateFqn, factoryFqn);
        }

        public static /* synthetic */ ExtensionDelegate copy$default(ExtensionDelegate extensionDelegate, KClass kClass, FlowTransform flowTransform, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                kClass = extensionDelegate.klass;
            }
            if ((n & 2) != 0) {
                flowTransform = extensionDelegate.flowTransform;
            }
            if ((n & 4) != 0) {
                string2 = extensionDelegate.delegateFqn;
            }
            if ((n & 8) != 0) {
                string3 = extensionDelegate.factoryFqn;
            }
            return extensionDelegate.copy(kClass, flowTransform, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ExtensionDelegate(klass=" + this.klass + ", flowTransform=" + (Object)((Object)this.flowTransform) + ", delegateFqn=" + this.delegateFqn + ", factoryFqn=" + this.factoryFqn + ")";
        }

        public int hashCode() {
            KClass<? extends IGenerator> kClass = this.klass;
            FlowTransform flowTransform = this.flowTransform;
            String string2 = this.delegateFqn;
            String string3 = this.factoryFqn;
            return (((kClass != null ? kClass.hashCode() : 0) * 31 + (flowTransform != null ? ((Object)((Object)flowTransform)).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExtensionDelegate)) break block3;
                    ExtensionDelegate extensionDelegate = (ExtensionDelegate)object;
                    if (!Intrinsics.areEqual(this.klass, extensionDelegate.klass) || !Intrinsics.areEqual((Object)((Object)this.flowTransform), (Object)((Object)extensionDelegate.flowTransform)) || !Intrinsics.areEqual((Object)this.delegateFqn, (Object)extensionDelegate.delegateFqn) || !Intrinsics.areEqual((Object)this.factoryFqn, (Object)extensionDelegate.factoryFqn)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u0082\u0001\u0003 !\"\u00a8\u0006#"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive;", "Lcom/jetbrains/rd/generator/nova/Member;", "name", "", "genericParams", "", "Lcom/jetbrains/rd/generator/nova/IType;", "(Ljava/lang/String;[Lcom/jetbrains/rd/generator/nova/IType;)V", "context", "Lcom/jetbrains/rd/generator/nova/Context;", "getContext", "()Lcom/jetbrains/rd/generator/nova/Context;", "setContext", "(Lcom/jetbrains/rd/generator/nova/Context;)V", "flow", "Lcom/jetbrains/rd/generator/nova/FlowKind;", "getFlow", "()Lcom/jetbrains/rd/generator/nova/FlowKind;", "setFlow", "(Lcom/jetbrains/rd/generator/nova/FlowKind;)V", "freeThreaded", "", "getFreeThreaded", "()Z", "setFreeThreaded", "(Z)V", "getGenericParams", "()[Lcom/jetbrains/rd/generator/nova/IType;", "[Lcom/jetbrains/rd/generator/nova/IType;", "Signal", "Stateful", "Task", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Task;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Signal;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful;", "rd-gen"})
    public static abstract class Reactive
    extends Member {
        @NotNull
        private FlowKind flow;
        private boolean freeThreaded;
        @Nullable
        private Context context;
        @NotNull
        private final IType[] genericParams;

        @NotNull
        public final FlowKind getFlow() {
            return this.flow;
        }

        public final void setFlow(@NotNull FlowKind flowKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)flowKind), (String)"<set-?>");
            this.flow = flowKind;
        }

        public final boolean getFreeThreaded() {
            return this.freeThreaded;
        }

        public final void setFreeThreaded(boolean bl) {
            this.freeThreaded = bl;
        }

        @Nullable
        public final Context getContext() {
            return this.context;
        }

        public final void setContext(@Nullable Context context) {
            this.context = context;
        }

        @NotNull
        public final IType[] getGenericParams() {
            return this.genericParams;
        }

        private Reactive(String name2, IType ... genericParams) {
            super(name2, ArraysKt.toList((Object[])genericParams), null);
            this.genericParams = genericParams;
            this.flow = FlowKind.Both;
        }

        public /* synthetic */ Reactive(String name2, IType[] genericParams,  /* corrupt varargs signature?! */ DefaultConstructorMarkerDefaultConstructorMarker $constructor_marker) {
            this(name2, genericParams);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive$Task;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive;", "name", "", "paramType", "Lcom/jetbrains/rd/generator/nova/IScalar;", "resultType", "Lcom/jetbrains/rd/generator/nova/IType;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/IScalar;Lcom/jetbrains/rd/generator/nova/IType;)V", "rd-gen"})
        public static final class Task
        extends Reactive {
            public Task(@NotNull String name2, @NotNull IScalar paramType, @NotNull IType resultType) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)paramType, (String)"paramType");
                Intrinsics.checkNotNullParameter((Object)resultType, (String)"resultType");
                super(name2, new IType[]{paramType, resultType}, (DefaultConstructorMarker)null);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive$Signal;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive;", "name", "", "paramType", "Lcom/jetbrains/rd/generator/nova/IScalar;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/IScalar;)V", "rd-gen"})
        public static final class Signal
        extends Reactive {
            public Signal(@NotNull String name2, @NotNull IScalar paramType) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)paramType, (String)"paramType");
                super(name2, new IType[]{paramType}, (DefaultConstructorMarker)null);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\b\t\n\u000b\fB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u0082\u0001\u0005\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive;", "name", "", "genericParams", "", "Lcom/jetbrains/rd/generator/nova/IType;", "(Ljava/lang/String;[Lcom/jetbrains/rd/generator/nova/IType;)V", "Extension", "List", "Map", "Property", "Set", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$Property;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$List;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$Set;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$Map;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$Extension;", "rd-gen"})
        public static abstract class Stateful
        extends Reactive {
            private Stateful(String name2, IType ... genericParams) {
                super(name2, Arrays.copyOf(genericParams, genericParams.length), (DefaultConstructorMarker)null);
            }

            public /* synthetic */ Stateful(String name2, IType[] genericParams,  /* corrupt varargs signature?! */ DefaultConstructorMarkerDefaultConstructorMarker $constructor_marker) {
                this(name2, genericParams);
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u000b\u001a\u00020\f*\u00020\u0005H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$Property;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful;", "name", "", "valueType", "Lcom/jetbrains/rd/generator/nova/IType;", "defaultValue", "", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/IType;Ljava/lang/Object;)V", "getDefaultValue", "()Ljava/lang/Object;", "isNullable", "", "()Z", "rd-gen"})
            public static final class Property
            extends Stateful {
                @Nullable
                private final Object defaultValue;

                public final boolean isNullable() {
                    return this.isNullable((IType)CollectionsKt.first(this.getReferencedTypes()));
                }

                private final boolean isNullable(IType $this$isNullable) {
                    IType iType = $this$isNullable;
                    return iType instanceof INullable ? true : (iType instanceof IAttributedType ? this.isNullable(((IAttributedType)$this$isNullable).getItemType()) : false);
                }

                @Nullable
                public final Object getDefaultValue() {
                    return this.defaultValue;
                }

                public Property(@NotNull String name2, @NotNull IType valueType, @Nullable Object defaultValue) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
                    super(name2, new IType[]{valueType}, (DefaultConstructorMarker)null);
                    this.defaultValue = defaultValue;
                }

                public /* synthetic */ Property(String string2, IType iType, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 4) != 0) {
                        object = null;
                    }
                    this(string2, iType, object);
                }
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$List;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful;", "name", "", "itemType", "Lcom/jetbrains/rd/generator/nova/IType;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/IType;)V", "rd-gen"})
            public static final class List
            extends Stateful {
                public List(@NotNull String name2, @NotNull IType itemType) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
                    super(name2, new IType[]{itemType}, (DefaultConstructorMarker)null);
                }
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$Set;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful;", "name", "", "itemType", "Lcom/jetbrains/rd/generator/nova/INonNullableScalar;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/INonNullableScalar;)V", "rd-gen"})
            public static final class Set
            extends Stateful {
                public Set(@NotNull String name2, @NotNull INonNullableScalar itemType) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
                    super(name2, new IType[]{itemType}, (DefaultConstructorMarker)null);
                }
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$Map;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful;", "name", "", "keyType", "Lcom/jetbrains/rd/generator/nova/INonNullableScalar;", "valueType", "Lcom/jetbrains/rd/generator/nova/INonNullable;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/INonNullableScalar;Lcom/jetbrains/rd/generator/nova/INonNullable;)V", "rd-gen"})
            public static final class Map
            extends Stateful {
                public Map(@NotNull String name2, @NotNull INonNullableScalar keyType, @NotNull INonNullable valueType) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
                    Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
                    super(name2, new IType[]{keyType, valueType}, (DefaultConstructorMarker)null);
                }
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001BS\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012:\u0010\u0006\u001a\u001e\u0012\u001a\b\u0001\u0012\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00030\b0\u0007\"\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\u000bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0007\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0007\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful$Extension;", "Lcom/jetbrains/rd/generator/nova/Member$Reactive$Stateful;", "name", "", "delegatedBy", "Lcom/jetbrains/rd/generator/nova/Class;", "_delegateFqn", "", "Lkotlin/Pair;", "Lkotlin/reflect/KClass;", "Lcom/jetbrains/rd/generator/nova/IGenerator;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/Class;[Lkotlin/Pair;)V", "_delegates", "Lcom/jetbrains/rd/generator/nova/Member$ExtensionDelegate;", "(Ljava/lang/String;Lcom/jetbrains/rd/generator/nova/Class;[Lcom/jetbrains/rd/generator/nova/Member$ExtensionDelegate;)V", "getDelegatedBy", "()Lcom/jetbrains/rd/generator/nova/Class;", "delegates", "getDelegates", "()[Lcom/jetbrains/rd/generator/nova/Member$ExtensionDelegate;", "[Lcom/jetbrains/rd/generator/nova/Member$ExtensionDelegate;", "factoryFqn", "generator", "flowTransform", "Lcom/jetbrains/rd/generator/nova/FlowTransform;", "findDelegate", "fqn", "rd-gen"})
            public static abstract class Extension
            extends Stateful {
                @NotNull
                private final ExtensionDelegate[] delegates;
                @NotNull
                private final Class delegatedBy;

                @NotNull
                public final ExtensionDelegate[] getDelegates() {
                    return this.delegates;
                }

                @NotNull
                public final String fqn(@NotNull IGenerator generator, @NotNull FlowTransform flowTransform) {
                    Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
                    Intrinsics.checkNotNullParameter((Object)((Object)flowTransform), (String)"flowTransform");
                    Object object = this.findDelegate(generator, flowTransform);
                    if (object == null || (object = ((ExtensionDelegate)object).getDelegateFqn()) == null) {
                        String string2 = this.getClass().getSimpleName();
                        object = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.simpleName");
                    }
                    return object;
                }

                @NotNull
                public final String factoryFqn(@NotNull IGenerator generator, @NotNull FlowTransform flowTransform) {
                    Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
                    Intrinsics.checkNotNullParameter((Object)((Object)flowTransform), (String)"flowTransform");
                    ExtensionDelegate extensionDelegate = this.findDelegate(generator, flowTransform);
                    if (extensionDelegate == null) {
                        String string2 = this.getClass().getSimpleName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.simpleName");
                        return string2;
                    }
                    ExtensionDelegate delegate = extensionDelegate;
                    String string3 = delegate.getFactoryFqn();
                    if (string3 == null) {
                        string3 = delegate.getDelegateFqn();
                    }
                    return string3;
                }

                @Nullable
                public final ExtensionDelegate findDelegate(@NotNull IGenerator generator, @NotNull FlowTransform flowTransform) {
                    ExtensionDelegate extensionDelegate;
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
                        Intrinsics.checkNotNullParameter((Object)((Object)flowTransform), (String)"flowTransform");
                        ExtensionDelegate[] $this$firstOrNull$iv = this.delegates;
                        boolean $i$f$firstOrNull = false;
                        ExtensionDelegate[] extensionDelegateArray = $this$firstOrNull$iv;
                        int n = extensionDelegateArray.length;
                        for (int i = 0; i < n; ++i) {
                            ExtensionDelegate element$iv;
                            ExtensionDelegate it = element$iv = extensionDelegateArray[i];
                            boolean bl = false;
                            if (!(KClasses.safeCast(it.getKlass(), (Object)generator) != null && (it.getFlowTransform() == null || it.getFlowTransform() == flowTransform))) continue;
                            extensionDelegate = element$iv;
                            break block1;
                        }
                        extensionDelegate = null;
                    }
                    return extensionDelegate;
                }

                @NotNull
                public final Class getDelegatedBy() {
                    return this.delegatedBy;
                }

                public Extension(@NotNull String name2, @NotNull Class delegatedBy, ExtensionDelegate ... _delegates) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)delegatedBy, (String)"delegatedBy");
                    Intrinsics.checkNotNullParameter((Object)_delegates, (String)"_delegates");
                    super(name2, new IType[0], (DefaultConstructorMarker)null);
                    this.delegatedBy = delegatedBy;
                    this.delegates = _delegates;
                }

                /*
                 * WARNING - void declaration
                 */
                public Extension(@NotNull String name2, @NotNull Class delegatedBy, Pair<? extends KClass<? extends IGenerator>, String> ... _delegateFqn) {
                    Collection<ExtensionDelegate> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)delegatedBy, (String)"delegatedBy");
                    Intrinsics.checkNotNullParameter(_delegateFqn, (String)"_delegateFqn");
                    Pair<? extends KClass<? extends IGenerator>, String>[] pairArray = _delegateFqn;
                    Class clazz = delegatedBy;
                    String string2 = name2;
                    Extension extension = this;
                    boolean $i$f$map = false;
                    void var6_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    void var9_12 = $this$mapTo$iv$iv;
                    int n = ((void)var9_12).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var13_16 = item$iv$iv = var9_12[i];
                        collection = destination$iv$iv;
                        boolean bl = false;
                        ExtensionDelegate extensionDelegate = new ExtensionDelegate((KClass)it.getFirst(), null, (String)it.getSecond(), null, 8, null);
                        collection.add(extensionDelegate);
                    }
                    collection = (java.util.List)destination$iv$iv;
                    Collection $this$toTypedArray$iv = collection;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    ExtensionDelegate[] extensionDelegateArray = thisCollection$iv.toArray(new ExtensionDelegate[0]);
                    if (extensionDelegateArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    extension(string2, clazz, Arrays.copyOf(extensionDelegateArray, extensionDelegateArray.length));
                }
            }
        }
    }
}

