/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.generator.nova;

import com.jetbrains.rd.generator.nova.GenerateKt;
import com.jetbrains.rd.generator.nova.GenerationSpec;
import com.jetbrains.rd.generator.nova.IGenerator;
import com.jetbrains.rd.generator.nova.RdGen;
import com.jetbrains.rd.generator.nova.Toplevel;
import com.jetbrains.rd.generator.nova.util.EnvUtilKt;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.hash.PersistentHash;
import com.jetbrains.rd.util.kli.Kli;
import com.jetbrains.rd.util.kli.Option;
import com.jetbrains.rd.util.reflection.ReflectionScannerKt;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 G2\u00020\u0001:\u0001GB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00105\u001a\u000206H\u0002J \u00107\u001a\u0004\u0018\u00010\u00052\f\u00108\u001a\b\u0012\u0004\u0012\u0002090#2\u0006\u0010:\u001a\u00020\u0010H\u0002J\u0016\u0010;\u001a\u0004\u0018\u00010\u00142\f\u00108\u001a\b\u0012\u0004\u0012\u0002090#J\u0014\u0010<\u001a\u0002062\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002090AH\u0002J\u0006\u0010B\u001a\u000206J\u0010\u0010C\u001a\u00020D2\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001f\u0010'\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0007R\u0011\u0010)\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000bR\u000e\u0010.\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0007R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0007R\u0011\u00103\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u000b\u00a8\u0006H"}, d2={"Lcom/jetbrains/rd/generator/nova/RdGen;", "Lcom/jetbrains/rd/util/kli/Kli;", "()V", "classpath", "Lcom/jetbrains/rd/util/kli/Option$Valued;", "", "getClasspath", "()Lcom/jetbrains/rd/util/kli/Option$Valued;", "clearOutput", "Lcom/jetbrains/rd/util/kli/Option$Flag;", "getClearOutput", "()Lcom/jetbrains/rd/util/kli/Option$Flag;", "comments", "getComments", "()Ljava/lang/String;", "compiled", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCompiled", "compilerClassloader", "Ljava/lang/ClassLoader;", "getCompilerClassloader", "()Ljava/lang/ClassLoader;", "setCompilerClassloader", "(Ljava/lang/ClassLoader;)V", "defaultClassloader", "description", "getDescription", "filter", "getFilter", "force", "getForce", "generatorsFile", "getGeneratorsFile", "gradleGenerationSpecs", "", "Lcom/jetbrains/rd/generator/nova/GenerationSpec;", "getGradleGenerationSpecs", "()Ljava/util/List;", "hashFolder", "getHashFolder", "hashfile", "getHashfile", "()Ljava/nio/file/Path;", "noLineNumbersInComments", "getNoLineNumbersInComments", "outputFolderKey", "packages", "getPackages", "sources", "getSources", "verbose", "getVerbose", "changedSinceLastStart", "", "compile0", "src", "Ljava/io/File;", "dst", "compileDsl", "errorAndExit", "msg", "prepareHash", "Lcom/jetbrains/rd/util/hash/PersistentHash;", "outputFolders", "", "run", "v", "", "e", "", "Companion", "rd-gen"})
public final class RdGen
extends Kli {
    @Nullable
    private ClassLoader compilerClassloader;
    @NotNull
    private final Option.Valued<String> sources = Kli.option_string$default(this, Character.valueOf('s'), "source", "Folders with dsl .kt files. If not present, scan classpath for inheritors of '" + Toplevel.class.getName() + '\'', null, 8, null);
    @NotNull
    private final Option.Valued<Path> hashFolder = this.option_path(Character.valueOf('h'), "hash-folder", "Folder to store hash file '.rdgen' for incremental generation", Paths.get("", new String[0]).toAbsolutePath());
    @NotNull
    private final Option.Valued<Path> compiled = Kli.option_path$default(this, null, "compiled", "Folder for compiled dsl. Temporary folder is created if option is not specified.", null, 8, null);
    @NotNull
    private final Option.Valued<String> classpath = Kli.option_string$default(this, Character.valueOf('c'), "compiler-classpath", "Classpath for kotlin compiler. You must specify it if you referenced something from your dsl", null, 8, null);
    @NotNull
    private final Option.Flag force = this.option_flag(Character.valueOf('f'), "force", "Suppress incremental generation.");
    @NotNull
    private final Option.Flag clearOutput = this.option_flag(Character.valueOf('x'), "clear", "Clear output folder before generation (if it is not incremental) ");
    @NotNull
    private final Option.Valued<String> packages = this.option_string(Character.valueOf('p'), "packages", "Java package names to search toplevels, delimited by ','. Example: com.jetbrains.rd.model.nova", "com,org");
    @NotNull
    private final Option.Valued<String> filter = Kli.option_string$default(this, null, "filter", "Filter generators by searching regular expression inside generator class simple name (case insensitive). Example: kotlin|csharp|cpp", null, 8, null);
    @NotNull
    private final Option.Flag verbose = this.option_flag(Character.valueOf('v'), "verbose", "Verbose output");
    @NotNull
    private final Option.Flag noLineNumbersInComments = this.option_flag(Character.valueOf('n'), "no-line-numbers", "Don't save original source line numbers in comments inside of generated files");
    @NotNull
    private final Option.Valued<String> generatorsFile = Kli.option_string$default(this, Character.valueOf('g'), "generators", "Path to the file with serialized GeneratorSpecs", null, 8, null);
    private final ClassLoader defaultClassloader;
    private final String outputFolderKey;
    @NotNull
    public static final String version = "1.10";
    @NotNull
    public static final String hashFileName = ".rdgen";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getDescription() {
        return "RD Generator, v1.10. Search for inheritors of '" + Toplevel.class.getName() + '\'' + " and generate sources according generators: inheritors of '" + IGenerator.class.getName() + "'.";
    }

    @Override
    @NotNull
    public String getComments() {
        return "Generates RD Model from DSL ";
    }

    @Nullable
    public final ClassLoader getCompilerClassloader() {
        return this.compilerClassloader;
    }

    public final void setCompilerClassloader(@Nullable ClassLoader classLoader) {
        this.compilerClassloader = classLoader;
    }

    @NotNull
    public final Option.Valued<String> getSources() {
        return this.sources;
    }

    @NotNull
    public final Option.Valued<Path> getHashFolder() {
        return this.hashFolder;
    }

    @NotNull
    public final Option.Valued<Path> getCompiled() {
        return this.compiled;
    }

    @NotNull
    public final Option.Valued<String> getClasspath() {
        return this.classpath;
    }

    @NotNull
    public final Option.Flag getForce() {
        return this.force;
    }

    @NotNull
    public final Option.Flag getClearOutput() {
        return this.clearOutput;
    }

    @NotNull
    public final Option.Valued<String> getPackages() {
        return this.packages;
    }

    @NotNull
    public final Option.Valued<String> getFilter() {
        return this.filter;
    }

    @NotNull
    public final Option.Flag getVerbose() {
        return this.verbose;
    }

    @NotNull
    public final Option.Flag getNoLineNumbersInComments() {
        return this.noLineNumbersInComments;
    }

    @NotNull
    public final Option.Valued<String> getGeneratorsFile() {
        return this.generatorsFile;
    }

    @NotNull
    public final List<GenerationSpec> getGradleGenerationSpecs() {
        String path = (String)this.generatorsFile.getValue();
        return path == null ? CollectionsKt.emptyList() : GenerationSpec.Companion.loadFrom(new File(path));
    }

    @NotNull
    public final Path getHashfile() {
        Object t = this.hashFolder.getValue();
        Intrinsics.checkNotNull(t);
        Path path = Paths.get(t.toString(), hashFileName).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(hashFolder.val\u2026hashFileName).normalize()");
        return path;
    }

    private final void v(String msg) {
        if (this.verbose.getValue().booleanValue()) {
            boolean bl = false;
            System.out.println((Object)msg);
        }
    }

    private final void v(Throwable e) {
        if (this.verbose.getValue().booleanValue()) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String compile0(List<? extends File> src, Path dst) {
        if (src.isEmpty()) {
            throw (Throwable)new Exception("Input file list is empty, compilation aborted");
        }
        this.v("Searching for Kotlin compiler");
        try {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Class<?> clazz;
            block18: {
                String compilerClass;
                block17: {
                    compilerClass = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
                    clazz = this.compilerClassloader;
                    if (clazz == null) break block17;
                    ClassLoader classLoader = clazz;
                    boolean bl = false;
                    boolean bl2 = false;
                    ClassLoader it = classLoader;
                    boolean bl3 = false;
                    this.v("Using special classloader for kotlin compiler: " + it);
                    clazz = Class.forName(compilerClass, true, it);
                    if (clazz != null) break block18;
                }
                clazz = Class.forName(compilerClass);
            }
            Class<?> clazz2 = clazz;
            Method method = clazz2.getMethod("exec", PrintStream.class, new String[]{""}.getClass());
            this.v("Compiling sources from '" + CollectionsKt.joinToString$default((Iterable)src, null, null, null, (int)0, null, (Function1)compile0.1.INSTANCE, (int)31, null) + "' to '" + dst.toAbsolutePath() + '\'');
            String string2 = (String)this.classpath.getValue();
            if (string2 == null) {
                string2 = "";
            }
            String userCp = string2;
            this.v("User classpath: '" + userCp + '\'');
            String[] stringArray = new String[1];
            Package package_ = this.getClass().getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"javaClass.`package`");
            String string3 = package_.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"javaClass.`package`.name");
            stringArray[0] = string3;
            Iterable iterable = SequencesKt.toSet((Sequence)SequencesKt.plus(ReflectionScannerKt.scanForResourcesContaining(this.defaultClassloader, stringArray), ReflectionScannerKt.scanForResourcesContaining(this.defaultClassloader, "kotlin")));
            String string4 = System.getProperty("path.separator");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"System.getProperty(\"path.separator\")");
            String defaultCp = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, null, (int)62, null);
            this.v("Rdgen default classpath: '" + defaultCp + '\'');
            Iterable $this$filter$iv = CollectionsKt.listOf((Object[])new String[]{userCp, defaultCp});
            boolean $i$f$filter22 = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            String string5 = System.getProperty("path.separator");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"System.getProperty(\"path.separator\")");
            String cp = CollectionsKt.joinToString$default((Iterable)iterable3, (CharSequence)string5, null, null, (int)0, null, null, (int)62, null);
            this.v("Resulting kotlinc classpath: '" + cp + '\'');
            Iterable $i$f$filter22 = src;
            Collection collection2 = CollectionsKt.listOf((Object[])new String[]{"-cp", cp, "-no-stdlib", "-d", ((Object)dst).toString(), "-jvm-target", "1.8"});
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File bl = (File)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                String string6 = it.getAbsolutePath();
                collection.add(string6);
            }
            collection = (List)destination$iv$iv2;
            List args = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            this.v("kotlinc " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, (Function1)compile0.2.INSTANCE, (int)30, null));
            Object[] objectArray = new Object[2];
            objectArray[0] = System.err;
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray[1] = stringArray2;
            Object object = method.invoke(clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), objectArray);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            Enum returnCode = (Enum)object;
            return returnCode.ordinal() == 0 ? null : "Compilation failed. Return code: " + returnCode.ordinal() + '(' + returnCode + ").";
        }
        catch (Throwable e) {
            String string7;
            this.v(e);
            if (e instanceof ClassNotFoundException) {
                string7 = "Can't find K2JVMCompiler, maybe you forgot to add 'kotlin-compiler.jar' into classpath?";
            } else if (e instanceof NoSuchMethodException || e instanceof IllegalStateException || e instanceof NullPointerException || e instanceof InstantiationError || e instanceof ExceptionInInitializerError) {
                string7 = "Found compiler, but can't run it properly. Exception: " + PlatformDependentKt.getThrowableText((Throwable)e) + '.' + System.lineSeparator() + "Maybe, compiler version is not correct?";
            } else if (e instanceof InvocationTargetException) {
                StringBuilder stringBuilder = new StringBuilder().append("Compilation failed with exception: ");
                Throwable throwable = ((InvocationTargetException)e).getTargetException();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"e.targetException");
                string7 = stringBuilder.append(PlatformDependentKt.getThrowableText((Throwable)throwable)).toString();
            } else {
                string7 = "Unknown exception:  " + PlatformDependentKt.getThrowableText((Throwable)e);
            }
            return string7;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassLoader compileDsl(@NotNull List<? extends File> src) {
        ClassLoader classLoader;
        Path path;
        block13: {
            Path $this$apply;
            boolean bl;
            boolean bl2;
            Path path2;
            block12: {
                Intrinsics.checkNotNullParameter(src, (String)"src");
                path = (Path)this.compiled.getValue();
                if (path == null) break block12;
                path2 = path;
                bl2 = false;
                bl = false;
                $this$apply = path2;
                boolean bl3 = false;
                this.v("Compiling into specified folder: " + $this$apply);
                path = path2;
                if (path != null) break block13;
            }
            path2 = Files.createTempDirectory("rdgen-", new FileAttribute[0]);
            bl2 = false;
            bl = false;
            $this$apply = path2;
            boolean bl4 = false;
            this.v("Temporary folder created: " + $this$apply);
            $this$apply.toFile().deleteOnExit();
            path = path2;
        }
        Path dst = path;
        boolean $i$f$measureTimeMillis = false;
        boolean $this$apply2 = false;
        long start$iv2 = System.currentTimeMillis();
        boolean bl6 = false;
        Path path3 = dst;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dst");
        this.setError(this.compile0(src, path3));
        long elapsed = System.currentTimeMillis() - start$iv2;
        this.v("Compilation finished in " + elapsed + " ms");
        if (this.getError() == null) {
            URLClassLoader uRLClassLoader;
            try {
                Iterable iterable;
                Collection collection = CollectionsKt.listOf((Object)dst.toUri().toURL());
                String string2 = (String)this.classpath.getValue();
                if (string2 != null) {
                    void $this$mapTo$iv$iv;
                    void it;
                    String $this$apply2 = string2;
                    boolean start$iv2 = false;
                    boolean bl5 = false;
                    String bl6 = $this$apply2;
                    Collection collection2 = collection;
                    boolean bl7 = false;
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        String string3 = (String)item$iv$iv;
                        Collection collection3 = destination$iv$iv;
                        boolean bl8 = false;
                        URL uRL = new File((String)it2).toURI().toURL();
                        collection3.add(uRL);
                    }
                    List list = (List)destination$iv$iv;
                    collection = collection2;
                    iterable = list;
                } else {
                    iterable = CollectionsKt.emptyList();
                }
                List classpathUris = CollectionsKt.plus((Collection)collection, (Iterable)iterable);
                this.v("Loading compiled classes from '" + CollectionsKt.joinToString$default((Iterable)classpathUris, null, null, null, (int)0, null, null, (int)63, null) + '\'');
                Collection $this$toTypedArray$iv = classpathUris;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                uRLClassLoader = new URLClassLoader(uRLArray, this.defaultClassloader);
            }
            catch (Throwable e) {
                this.setError("Error during loading classes from '" + dst + '\'');
                uRLClassLoader = null;
            }
            classLoader = uRLClassLoader;
        } else {
            classLoader = null;
        }
        return classLoader;
    }

    private final boolean errorAndExit(String msg) {
        PrintStream printStream = System.err;
        boolean bl = false;
        boolean bl2 = false;
        PrintStream $this$apply = printStream;
        boolean bl3 = false;
        String string2 = msg;
        if (string2 == null) {
            string2 = this.getError();
        }
        $this$apply.println(string2);
        $this$apply.println();
        $this$apply.println(this.help());
        return false;
    }

    static /* synthetic */ boolean errorAndExit$default(RdGen rdGen, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return rdGen.errorAndExit(string2);
    }

    private final PersistentHash prepareHash(Collection<? extends File> outputFolders2) {
        PersistentHash persistentHash = new PersistentHash();
        boolean bl = false;
        boolean bl2 = false;
        PersistentHash res2 = persistentHash;
        boolean bl3 = false;
        String string2 = (String)this.sources.getValue();
        if (string2 != null) {
            String string3 = string2;
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string3;
            boolean bl6 = false;
            for (String src : StringsKt.split$default((CharSequence)it, (char[])new char[]{';'}, (boolean)false, (int)0, (int)6, null)) {
                PersistentHash.mixFileRecursively$default(res2, new File(src), null, 2, null);
            }
        }
        Sequence<File> $this$forEach$iv = (Sequence<File>)outputFolders2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl7 = false;
            res2.mixFileRecursively(it, (Function1<? super File, Boolean>)((Function1)prepareHash.1.2.1.INSTANCE));
        }
        $this$forEach$iv = outputFolders2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File folder = (File)element$iv;
            boolean bl8 = false;
            res2.mix(this.outputFolderKey, folder.getCanonicalPath());
        }
        String[] stringArray = new String[1];
        Package package_ = this.getClass().getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"javaClass.`package`");
        String string4 = package_.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"javaClass.`package`.name");
        stringArray[0] = string4;
        $this$forEach$iv = ReflectionScannerKt.scanForResourcesContaining(this.defaultClassloader, stringArray);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl9 = false;
            res2.mixFileRecursively(file2, (Function1<? super File, Boolean>)((Function1)prepareHash.1.4.1.INSTANCE));
        }
        res2.mix("version", version);
        res2.mix("userClasspath", (String)this.classpath.getValue());
        res2.mix("filter", (String)this.filter.getValue());
        res2.mix("packages", (String)this.packages.getValue());
        res2.mix("noLineNumbersInComments", String.valueOf(this.noLineNumbersInComments.getValue()));
        return persistentHash;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean changedSinceLastStart() {
        void $this$mapTo$iv$iv;
        if (this.sources.getValue() == null) {
            return true;
        }
        this.v("Reading hash from " + this.getHashfile());
        PersistentHash oldHash = PersistentHash.Companion.load(this.getHashfile());
        Iterable $this$map$iv = oldHash.get(this.outputFolderKey);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file2 = new File((String)it);
            collection.add(file2);
        }
        List outputFolders2 = (List)destination$iv$iv;
        PersistentHash newHash = this.prepareHash(outputFolders2);
        String string3 = oldHash.firstDiff(newHash);
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            this.v("Hashes are different at key '" + it + "', oldHash: " + CollectionsKt.joinToString$default((Iterable)oldHash.get(it), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ", newHash:" + CollectionsKt.joinToString$default((Iterable)newHash.get(it), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            return true;
        }
        if (this.getHashfile().toFile().exists()) {
            this.getHashfile().toFile().setLastModified(System.currentTimeMillis());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean run() {
        Set sourcePath2;
        ClassLoader classLoader;
        Object sourcePaths;
        String srcDir;
        String string2;
        if (this.getError() != null) {
            return RdGen.errorAndExit$default(this, null, 1, null);
        }
        try {
            Regex regex;
            String string3 = (String)this.filter.getValue();
            if (string3 != null) {
                string2 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                regex = new Regex(it, RegexOption.IGNORE_CASE);
            } else {
                regex = null;
            }
            string2 = regex;
        }
        catch (Throwable e) {
            return this.errorAndExit("Can't parse regex '" + (String)this.filter.getValue() + '\'');
        }
        String generatorFilter = string2;
        Object t = this.packages.getValue();
        Intrinsics.checkNotNull(t);
        Iterable $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((CharSequence)t), (char[])new char[]{',', ' ', ':', ';'}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv2.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] pkgPrefixes = stringArray;
        if (!this.force.getValue().booleanValue()) {
            if (!this.changedSinceLastStart()) {
                this.v("No changes since last start");
                return true;
            }
        } else {
            this.v("Forced: true");
            Path path = (Path)this.compiled.getValue();
            if (path != null) {
                $this$toTypedArray$iv = path;
                $i$f$toTypedArray = false;
                boolean thisCollection$iv2 = false;
                Iterable it = $this$toTypedArray$iv;
                boolean bl = false;
                this.v("Clearing '" + it + '\'');
                File file2 = it.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.toFile()");
                FilesKt.deleteRecursively((File)file2);
            }
        }
        if ((srcDir = (String)this.sources.getValue()) != null) {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)srcDir, (char[])new char[]{';'}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl4 = false;
                if (!(charSequence.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file3 = new File(it);
                collection.add(file3);
            }
            sourcePaths = (List)destination$iv$iv;
            Iterator $i$f$map22 = sourcePaths.iterator();
            while ($i$f$map22.hasNext()) {
                File sourcePath2 = (File)$i$f$map22.next();
                if (sourcePath2.isDirectory()) continue;
                return this.errorAndExit("Sources are incorrect. No folder found at '" + sourcePath2 + '\'');
            }
            classLoader = this.compileDsl((List<? extends File>)sourcePaths);
            if (classLoader == null) {
                return RdGen.errorAndExit$default(this, null, 1, null);
            }
        } else {
            sourcePaths = "Folder 'source' isn't specified, searching for models in classloader of RdGen class (current java process classpath).";
            boolean sourcePath2 = false;
            System.out.println(sourcePaths);
            sourcePaths = "To see parameters and usages invoke `rdgen -h`";
            sourcePath2 = false;
            System.out.println(sourcePaths);
            classLoader = this.defaultClassloader;
        }
        ClassLoader classloader = classLoader;
        this.v("gradleGenerationSpecs=[" + CollectionsKt.joinToString$default((Iterable)this.getGradleGenerationSpecs(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + ']');
        this.v("noLineNumbersInComments=" + this.noLineNumbersInComments.getValue());
        try {
            sourcePath2 = (Set)EnvUtilKt.usingSystemProperty("rdgen.line_numbers_in_comments", String.valueOf(this.noLineNumbersInComments.getValue() == false), (Function0)new Function0<Set<? extends File>>(this, classloader, pkgPrefixes, (Regex)generatorFilter){
                final /* synthetic */ RdGen this$0;
                final /* synthetic */ ClassLoader $classloader;
                final /* synthetic */ String[] $pkgPrefixes;
                final /* synthetic */ Regex $generatorFilter;

                @NotNull
                public final Set<File> invoke() {
                    return GenerateKt.generateRdModel(this.$classloader, this.$pkgPrefixes, this.this$0.getVerbose().getValue(), this.$generatorFilter, this.this$0.getClearOutput().getValue(), this.this$0.getGradleGenerationSpecs());
                }
                {
                    this.this$0 = rdGen;
                    this.$classloader = classLoader;
                    this.$pkgPrefixes = stringArray;
                    this.$generatorFilter = regex;
                    super(0);
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        Set outputFolders2 = sourcePath2;
        if (srcDir != null) {
            PersistentHash hash = this.prepareHash(outputFolders2);
            this.v("Storing hash into '" + this.getHashfile() + '\'');
            hash.store(this.getHashfile());
        } else {
            this.v("Don't store hashfile, build is not incremental since 'sources' aren't specified");
        }
        return true;
    }

    public RdGen() {
        ClassLoader classLoader = RdGen.class.getClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        this.defaultClassloader = classLoader;
        this.outputFolderKey = "outputFolders";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/generator/nova/RdGen$Companion;", "", "()V", "hashFileName", "", "version", "rd-gen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

