/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.yoke.annotations;

public enum DataType {
    INTEGER("integer", "int32", 3),
    LONG("integer", "int64", 3),
    FLOAT("number", "float", 3),
    DOUBLE("number", "double", 3),
    STRING("string", null, 3),
    BYTE("string", "byte", 3),
    BOOLEAN("boolean", null, 3),
    DATE("string", "date", 3),
    DATETIME("string", "date-time", 3),
    ARRAY("array", null, 3),
    SET("array", null, 3),
    VOID("void", null, 2),
    FILE("File", null, 1),
    REF(null, null, 0),
    UNDEFINED(null, null, 0);

    private static final int IN = 1;
    private static final int OUT = 2;
    private final String type;
    private final String format;
    private final int inOut;

    private DataType(String type, String format, int inOut) {
        this.type = type;
        this.format = format;
        this.inOut = inOut;
    }

    public String type() {
        if (this.type == null) {
            throw new RuntimeException("UNDEFINED cannot be used as a type");
        }
        return this.type;
    }

    public String format() {
        if (this.type == null) {
            throw new RuntimeException("UNDEFINED cannot be used as a type");
        }
        return this.format;
    }

    public boolean isIN() {
        if (this.type == null) {
            throw new RuntimeException("UNDEFINED cannot be used as a type");
        }
        return (this.inOut & 1) == 1;
    }

    public boolean isOUT() {
        if (this.type == null) {
            throw new RuntimeException("UNDEFINED cannot be used as a type");
        }
        return (this.inOut & 2) == 2;
    }
}

