/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.yoke.annotations.processors;

import com.jetdrone.vertx.yoke.annotations.ALL;
import com.jetdrone.vertx.yoke.annotations.CONNECT;
import com.jetdrone.vertx.yoke.annotations.Consumes;
import com.jetdrone.vertx.yoke.annotations.DELETE;
import com.jetdrone.vertx.yoke.annotations.DataType;
import com.jetdrone.vertx.yoke.annotations.GET;
import com.jetdrone.vertx.yoke.annotations.HEAD;
import com.jetdrone.vertx.yoke.annotations.JsonSchema;
import com.jetdrone.vertx.yoke.annotations.OPTIONS;
import com.jetdrone.vertx.yoke.annotations.PATCH;
import com.jetdrone.vertx.yoke.annotations.POST;
import com.jetdrone.vertx.yoke.annotations.PUT;
import com.jetdrone.vertx.yoke.annotations.ParamType;
import com.jetdrone.vertx.yoke.annotations.Parameter;
import com.jetdrone.vertx.yoke.annotations.Processor;
import com.jetdrone.vertx.yoke.annotations.Produces;
import com.jetdrone.vertx.yoke.annotations.ResponseMessage;
import com.jetdrone.vertx.yoke.annotations.SwaggerDoc;
import com.jetdrone.vertx.yoke.annotations.SwaggerResource;
import com.jetdrone.vertx.yoke.annotations.processors.AbstractAnnotationHandler;
import com.jetdrone.vertx.yoke.json.JsonSchemaResolver;
import com.jetdrone.vertx.yoke.middleware.Swagger;
import com.jetdrone.vertx.yoke.middleware.YokeRequest;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public class SwaggerProcessor
extends AbstractAnnotationHandler<Swagger> {
    public SwaggerProcessor() {
        super(Swagger.class);
    }

    public void process(Swagger swagger, Object instance, Class<?> clazz, Method method) {
        String[] consumes;
        String[] clazzConsumes;
        SwaggerResource res = (SwaggerResource)Processor.getAnnotation(clazz, SwaggerResource.class);
        if (res == null) {
            return;
        }
        Swagger.Resource resource = swagger.createResource(res.path(), res.description());
        Produces clazzProducesAnn = (Produces)Processor.getAnnotation(clazz, Produces.class);
        Consumes clazzConsumesAnn = (Consumes)Processor.getAnnotation(clazz, Consumes.class);
        String[] clazzProduces = clazzProducesAnn != null ? clazzProducesAnn.value() : null;
        String[] stringArray = clazzConsumes = clazzConsumesAnn != null ? clazzConsumesAnn.value() : null;
        if (clazzProduces != null) {
            resource.produces(clazzProduces);
        }
        if (clazzConsumes != null) {
            resource.consumes(clazzConsumes);
        }
        Produces producesAnn = (Produces)Processor.getAnnotation((Method)method, Produces.class);
        Consumes consumesAnn = (Consumes)Processor.getAnnotation((Method)method, Consumes.class);
        String[] produces = producesAnn != null ? producesAnn.value() : null;
        String[] stringArray2 = consumes = consumesAnn != null ? consumesAnn.value() : null;
        if (produces == null) {
            produces = clazzProduces;
        }
        if (consumes == null) {
            consumes = clazzConsumes;
        }
        if (produces != null) {
            resource.produces(produces);
        }
        if (consumes != null) {
            resource.consumes(consumes);
        }
        for (JsonSchema jsonSchema : res.models()) {
            String id = jsonSchema.id();
            JsonObject json = new JsonObject((Map)JsonSchemaResolver.resolveSchema((String)jsonSchema.value()));
            if ("".equals(id)) {
                id = json.getString("id");
            }
            resource.addModel(id, json);
        }
        SwaggerDoc doc = (SwaggerDoc)Processor.getAnnotation((Method)method, SwaggerDoc.class);
        Deprecated deprecated = (Deprecated)Processor.getAnnotation((Method)method, Deprecated.class);
        if (doc == null) {
            return;
        }
        JsonObject operations = new JsonObject();
        if (doc.notes().length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String s : doc.notes()) {
                sb.append(s);
                sb.append(' ');
            }
            String string = sb.toString();
            int len = string.length() - 1;
            len = len > 0 ? len : 0;
            String string2 = string.substring(0, len);
            operations.put("notes", string2);
        }
        operations.put("nickname", method.getName());
        DataType dataType = doc.type();
        if (dataType == DataType.REF) {
            operations.put("type", doc.refId());
        } else {
            operations.put("type", dataType.type());
            String format = dataType.format();
            if (format != null) {
                operations.put("format", format);
            }
        }
        if (doc.parameters().length > 0) {
            JsonArray jsonParameters = new JsonArray();
            operations.put("parameters", jsonParameters);
            Parameter[] parameterArray = doc.parameters();
            int n = parameterArray.length;
            for (int i = 0; i < n; ++i) {
                Parameter parameter = parameterArray[i];
                jsonParameters.add(this.parseParameter(parameter, clazzConsumesAnn, consumesAnn));
            }
        }
        if (doc.responseMessages().length > 0) {
            JsonArray jsonResponseMessages = new JsonArray();
            operations.put("responseMessages", jsonResponseMessages);
            for (ResponseMessage responseMessage : doc.responseMessages()) {
                JsonObject json = new JsonObject().put("code", Integer.valueOf(responseMessage.code())).put("message", responseMessage.message());
                if (!responseMessage.responseModel().equals("")) {
                    json.put("responseModel", responseMessage.responseModel());
                }
                jsonResponseMessages.add(json);
            }
        }
        if (produces != null) {
            operations.put("produces", new JsonArray(Arrays.asList(produces)));
        }
        if (consumes != null) {
            operations.put("consumes", new JsonArray(Arrays.asList(consumes)));
        }
        if (deprecated != null) {
            operations.put("deprecated", "true");
        }
        if (Processor.isCompatible((Method)method, ALL.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.all(((ALL)Processor.getAnnotation((Method)method, ALL.class)).value(), doc.summary(), operations);
        }
        if (Processor.isCompatible((Method)method, CONNECT.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.connect(((CONNECT)Processor.getAnnotation((Method)method, CONNECT.class)).value(), doc.summary(), operations);
        }
        if (Processor.isCompatible((Method)method, OPTIONS.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.options(((OPTIONS)Processor.getAnnotation((Method)method, OPTIONS.class)).value(), doc.summary(), operations);
        }
        if (Processor.isCompatible((Method)method, HEAD.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.head(((HEAD)Processor.getAnnotation((Method)method, HEAD.class)).value(), doc.summary(), operations);
        }
        if (Processor.isCompatible((Method)method, GET.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.get(((GET)Processor.getAnnotation((Method)method, GET.class)).value(), doc.summary(), operations);
        }
        if (Processor.isCompatible((Method)method, POST.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.post(((POST)Processor.getAnnotation((Method)method, POST.class)).value(), doc.summary(), operations);
        }
        if (Processor.isCompatible((Method)method, PUT.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.put(((PUT)Processor.getAnnotation((Method)method, PUT.class)).value(), doc.summary(), operations);
        }
        if (Processor.isCompatible((Method)method, PATCH.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.patch(((PATCH)Processor.getAnnotation((Method)method, PATCH.class)).value(), doc.summary(), operations);
        }
        if (Processor.isCompatible((Method)method, DELETE.class, (Class[])new Class[]{YokeRequest.class, Handler.class})) {
            resource.delete(((DELETE)Processor.getAnnotation((Method)method, DELETE.class)).value(), doc.summary(), operations);
        }
    }

    public void process(Swagger swagger, Object instance, Class<?> clazz, Field field) {
    }

    private JsonObject parseParameter(Parameter parameter, Consumes classConsumes, Consumes methodConsumes) {
        JsonObject response = new JsonObject();
        response.put("paramType", parameter.paramType().name().toLowerCase());
        response.put("name", parameter.name());
        String description = parameter.description();
        if (!description.equals("")) {
            response.put("description", parameter.description());
        }
        response.put("required", Boolean.valueOf(parameter.required()));
        response.put("allowMultiple", Boolean.valueOf(parameter.allowMultiple()));
        DataType type = parameter.type();
        switch (type) {
            case REF: {
                response.put("type", parameter.modelRef());
                break;
            }
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                response.put("type", type.type());
                if (type.format() != null) {
                    response.put("format", type.format());
                }
                if (!parameter.minimum().equals("")) {
                    response.put("minimum", parameter.minimum());
                }
                if (!parameter.maximum().equals("")) {
                    response.put("maximum", parameter.maximum());
                }
                if (parameter.defaultValue().equals("")) break;
                String val = parameter.defaultValue();
                if (val.indexOf(46) != -1) {
                    response.put("defaultValue", Double.valueOf(Double.parseDouble(parameter.defaultValue())));
                    break;
                }
                response.put("defaultValue", Integer.valueOf(Integer.parseInt(parameter.defaultValue())));
                break;
            }
            case BYTE: 
            case STRING: 
            case DATE: 
            case DATETIME: {
                response.put("type", type.type());
                if (type.format() != null) {
                    response.put("format", type.format());
                }
                if (!parameter.defaultValue().equals("")) {
                    response.put("defaultValue", parameter.defaultValue());
                }
                if (!parameter.minimum().equals("")) {
                    response.put("minimum", parameter.minimum());
                }
                if (!parameter.maximum().equals("")) {
                    response.put("maximum", parameter.maximum());
                }
                if (parameter.enumeration().length <= 0) break;
                JsonArray enumeration = new JsonArray();
                response.put("enum", enumeration);
                for (String item : parameter.enumeration()) {
                    enumeration.add(item);
                }
                break;
            }
            case BOOLEAN: {
                response.put("type", type.type());
                if (parameter.defaultValue().equals("")) break;
                response.put("defaultValue", Boolean.valueOf(Boolean.parseBoolean(parameter.defaultValue())));
                break;
            }
            case SET: {
                response.put("uniqueItems", Boolean.valueOf(true));
            }
            case ARRAY: {
                response.put("type", type.type());
                if (parameter.items() == DataType.UNDEFINED) {
                    if (!"".equals(parameter.itemsRefId())) {
                        response.put("items", new JsonObject().put("$ref", parameter.itemsRefId()));
                        break;
                    }
                    throw new RuntimeException("ARRAY/SET must specify items type or items refId");
                }
                if (parameter.items() == DataType.ARRAY || parameter.items() == DataType.SET) {
                    throw new RuntimeException("ARRAY/SET cannot contain ARRAYS/SETs");
                }
                if (parameter.items() == DataType.REF) {
                    response.put("items", new JsonObject().put("$ref", parameter.modelRef()));
                    break;
                }
                response.put("items", new JsonObject().put("type", parameter.items().type()).put("format", parameter.items().format()));
                break;
            }
            case VOID: {
                response.put("type", type.type());
                break;
            }
            case FILE: {
                response.put("type", type.type());
                if (parameter.paramType() != ParamType.FORM) {
                    throw new RuntimeException("File requires paramType to be FORM");
                }
                boolean multipart = false;
                if (classConsumes != null) {
                    for (String c : classConsumes.value()) {
                        if (!"multipart/form-data".equalsIgnoreCase(c)) continue;
                        multipart = true;
                        break;
                    }
                }
                if (methodConsumes != null) {
                    for (String c : methodConsumes.value()) {
                        if (!"multipart/form-data".equalsIgnoreCase(c)) continue;
                        multipart = true;
                        break;
                    }
                }
                if (multipart) break;
                throw new RuntimeException("File requires @Consumes(\"multipart/form-data\")");
            }
        }
        return response;
    }
}

