/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.yoke.middleware;

import com.jetdrone.vertx.yoke.IMiddleware;
import com.jetdrone.vertx.yoke.Middleware;
import com.jetdrone.vertx.yoke.annotations.Processor;
import com.jetdrone.vertx.yoke.annotations.processors.SwaggerProcessor;
import com.jetdrone.vertx.yoke.middleware.Router;
import com.jetdrone.vertx.yoke.middleware.YokeRequest;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Swagger {
    private final List<Resource> resources = new ArrayList<Resource>();
    private final Router router;
    private final String prefix;
    private final String apiVersion;
    private JsonObject info;
    private JsonObject authorizations;

    public Swagger(Router router, String apiVersion) {
        this(router, "/", apiVersion);
    }

    public Swagger(Router router, String prefix, final String apiVersion) {
        this.router = router;
        this.apiVersion = apiVersion;
        this.prefix = prefix.endsWith("/") ? prefix + "api-docs" : prefix + "/api-docs";
        this.router.get(this.prefix, new IMiddleware[]{new Middleware(){

            public void handle(@NotNull YokeRequest request, @NotNull Handler<Object> next) {
                JsonObject result = new JsonObject().put("apiVersion", apiVersion).put("swaggerVersion", "1.2");
                JsonArray apis = new JsonArray();
                result.put("apis", apis);
                for (Resource r : Swagger.this.resources) {
                    apis.add(new JsonObject().put("path", r.path).put("description", r.description));
                }
                if (Swagger.this.authorizations != null) {
                    result.put("authorizations", Swagger.this.authorizations);
                }
                result.put("info", Swagger.this.info);
                request.response().end(result);
            }
        }});
    }

    public Swagger setInfo(JsonObject info) {
        this.info = info;
        return this;
    }

    public Swagger setAuthorizations(JsonObject authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    protected Resource createSwaggerResource(final String path, String description) {
        for (Resource res : this.resources) {
            if (!res.path.equals(path)) continue;
            return res;
        }
        final Resource resource = new Resource(path, description);
        this.resources.add(resource);
        this.router.get(this.prefix + path, new IMiddleware[]{new Middleware(){

            public void handle(@NotNull YokeRequest request, @NotNull Handler<Object> next) {
                JsonObject result = new JsonObject().put("apiVersion", Swagger.this.apiVersion).put("swaggerVersion", "1.2").put("basePath", "/").put("resourcePath", path);
                if (resource.produces != null) {
                    result.put("produces", resource.produces);
                }
                if (resource.consumes != null) {
                    result.put("consumes", resource.consumes);
                }
                JsonArray apis = new JsonArray();
                result.put("apis", apis);
                for (String key : resource.apis.fieldNames()) {
                    apis.add(resource.apis.getValue(key));
                }
                result.put("models", resource.models);
                request.response().end(result);
            }
        }});
        return resource;
    }

    public Resource createResource(String path) {
        return this.createResource(path, "");
    }

    public Resource createResource(String path, String description) {
        String normalizedPath = path.charAt(0) != '/' ? "/" + path : path;
        return this.createSwaggerResource(normalizedPath, description);
    }

    public static Swagger from(Router router, String version, Object ... objs) {
        Swagger swagger = new Swagger(router, version);
        Swagger.from(swagger, objs);
        return swagger;
    }

    public static Swagger from(Swagger router, Object ... objs) {
        for (Object o : objs) {
            Processor.process((Object)router, (Object)o);
        }
        return router;
    }

    static {
        Processor.registerProcessor(SwaggerProcessor.class);
    }

    public static class Resource {
        final String path;
        final String description;
        JsonArray produces;
        JsonArray consumes;
        JsonObject models = new JsonObject();
        JsonObject apis = new JsonObject();

        Resource(String path, String description) {
            this.path = path;
            this.description = description;
        }

        private JsonObject getApi(String path) {
            JsonObject api = this.apis.getJsonObject(path);
            if (api == null) {
                api = new JsonObject().put("path", path).put("operations", new JsonArray());
                this.apis.put(path, api);
            }
            return api;
        }

        public Resource produces(String ... mimes) {
            this.produces = new JsonArray();
            for (String mime : mimes) {
                if (this.produces.contains((Object)mime)) continue;
                this.produces.add(mime);
            }
            return this;
        }

        public Resource consumes(String ... mimes) {
            this.consumes = new JsonArray();
            for (String mime : mimes) {
                if (this.consumes.contains((Object)mime)) continue;
                this.consumes.add(mime);
            }
            return this;
        }

        public Resource all(String path, JsonObject operation) {
            this.all(path, "", operation);
            return this;
        }

        public Resource all(String path, String summary, JsonObject operation) {
            this.addOperation("GET", path, summary, operation);
            this.addOperation("PUT", path, summary, operation);
            this.addOperation("POST", path, summary, operation);
            this.addOperation("DELETE", path, summary, operation);
            this.addOperation("OPTIONS", path, summary, operation);
            this.addOperation("HEAD", path, summary, operation);
            this.addOperation("TRACE", path, summary, operation);
            this.addOperation("CONNECT", path, summary, operation);
            this.addOperation("PATCH", path, summary, operation);
            return this;
        }

        public Resource get(String path, JsonObject operation) {
            this.get(path, "", operation);
            return this;
        }

        public Resource get(String path, String summary, JsonObject operation) {
            this.addOperation("GET", path, summary, operation);
            return this;
        }

        public Resource post(String path, JsonObject operation) {
            this.post(path, "", operation);
            return this;
        }

        public Resource post(String path, String summary, JsonObject operation) {
            this.addOperation("POST", path, summary, operation);
            return this;
        }

        public Resource put(String path, JsonObject operation) {
            this.put(path, "", operation);
            return this;
        }

        public Resource put(String path, String summary, JsonObject operation) {
            this.addOperation("PUT", path, summary, operation);
            return this;
        }

        public Resource delete(String path, JsonObject operation) {
            this.delete(path, "", operation);
            return this;
        }

        public Resource delete(String path, String summary, JsonObject operation) {
            this.addOperation("DELETE", path, summary, operation);
            return this;
        }

        public Resource options(String path, JsonObject operation) {
            this.options(path, "", operation);
            return this;
        }

        public Resource options(String path, String summary, JsonObject operation) {
            this.addOperation("OPTIONS", path, summary, operation);
            return this;
        }

        public Resource head(String path, JsonObject operation) {
            this.head(path, "", operation);
            return this;
        }

        public Resource head(String path, String summary, JsonObject operation) {
            this.addOperation("HEAD", path, summary, operation);
            return this;
        }

        public Resource trace(String path, JsonObject operation) {
            this.trace(path, "", operation);
            return this;
        }

        public Resource trace(String path, String summary, JsonObject operation) {
            this.addOperation("TRACE", path, summary, operation);
            return this;
        }

        public Resource connect(String path, JsonObject operation) {
            this.connect(path, "", operation);
            return this;
        }

        public Resource connect(String path, String summary, JsonObject operation) {
            this.addOperation("CONNECT", path, summary, operation);
            return this;
        }

        public Resource patch(String path, JsonObject operation) {
            this.patch(path, "", operation);
            return this;
        }

        public Resource patch(String path, String summary, JsonObject operation) {
            this.addOperation("PATCH", path, summary, operation);
            return this;
        }

        public Resource addModel(String id, JsonObject model) {
            model.put("id", id);
            this.models.put(id, model);
            return this;
        }

        protected void addOperation(String verb, String path, String summary, JsonObject operation) {
            Matcher m = Pattern.compile(":([A-Za-z][A-Za-z0-9_]*)").matcher(path);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, "\\{$1\\}");
            }
            m.appendTail(sb);
            JsonObject op = new JsonObject().put("method", verb).put("summary", summary);
            op.mergeIn(operation);
            JsonObject api = this.getApi(sb.toString());
            api.getJsonArray("operations").add(op);
        }
    }
}

