/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.druid;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.DruidDataSource;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class DruidPlugin
implements IPlugin,
IDataSourceProvider {
    protected String name = null;
    protected String url;
    protected String username;
    protected String password;
    protected String publicKey;
    protected String driverClass = null;
    protected int initialSize = 1;
    protected int minIdle = 10;
    protected int maxActive = 32;
    protected long maxWait = -1L;
    protected long timeBetweenEvictionRunsMillis = 60000L;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected long timeBetweenConnectErrorMillis = 30000L;
    protected String validationQuery = "select 1";
    protected String connectionInitSql = null;
    protected String connectionProperties = null;
    protected boolean testWhileIdle = true;
    protected boolean testOnBorrow = false;
    protected boolean testOnReturn = false;
    protected boolean removeAbandoned = false;
    protected long removeAbandonedTimeoutMillis = 300000L;
    protected boolean logAbandoned = false;
    protected int maxPoolPreparedStatementPerConnectionSize = -1;
    protected Integer defaultTransactionIsolation = null;
    protected Integer validationQueryTimeout = null;
    protected Integer timeBetweenLogStatsMillis = null;
    protected Boolean keepAlive = null;
    protected String filters;
    protected List<Filter> filterList;
    protected DruidDataSource ds;
    protected volatile boolean isStarted = false;

    public DruidPlugin(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.validationQuery = DruidPlugin.autoCheckValidationQuery(url);
    }

    public DruidPlugin(String url, String username, String password, String driverClass) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.driverClass = driverClass;
        this.validationQuery = DruidPlugin.autoCheckValidationQuery(url);
    }

    public DruidPlugin(String url, String username, String password, String driverClass, String filters) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.driverClass = driverClass;
        this.filters = filters;
        this.validationQuery = DruidPlugin.autoCheckValidationQuery(url);
    }

    private static String autoCheckValidationQuery(String url) {
        if (url.startsWith("jdbc:oracle")) {
            return "select 1 from dual";
        }
        if (url.startsWith("jdbc:db2")) {
            return "select 1 from sysibm.sysdummy1";
        }
        if (url.startsWith("jdbc:hsqldb")) {
            return "select 1 from INFORMATION_SCHEMA.SYSTEM_USERS";
        }
        if (url.startsWith("jdbc:derby")) {
            return "select 1 from INFORMATION_SCHEMA.SYSTEM_USERS";
        }
        return "select 1";
    }

    public void setConnectionInitSql(String sql) {
        this.connectionInitSql = sql;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public DruidPlugin setFilters(String filters) {
        this.filters = filters;
        return this;
    }

    public synchronized DruidPlugin addFilter(Filter filter) {
        if (this.filterList == null) {
            this.filterList = new ArrayList<Filter>();
        }
        this.filterList.add(filter);
        return this;
    }

    @Override
    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        this.ds = new DruidDataSource();
        if (this.name != null) {
            this.ds.setName(this.name);
        }
        this.ds.setUrl(this.url);
        this.ds.setUsername(this.username);
        this.ds.setPassword(this.password);
        if (this.driverClass != null) {
            this.ds.setDriverClassName(this.driverClass);
        }
        this.ds.setInitialSize(this.initialSize);
        this.ds.setMinIdle(this.minIdle);
        this.ds.setMaxActive(this.maxActive);
        this.ds.setMaxWait(this.maxWait);
        this.ds.setTimeBetweenConnectErrorMillis(this.timeBetweenConnectErrorMillis);
        this.ds.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        this.ds.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        this.ds.setValidationQuery(this.validationQuery);
        if (StrKit.notBlank(this.connectionInitSql)) {
            ArrayList<String> connectionInitSqls = new ArrayList<String>();
            connectionInitSqls.add(this.connectionInitSql);
            this.ds.setConnectionInitSqls(connectionInitSqls);
        }
        this.ds.setTestWhileIdle(this.testWhileIdle);
        this.ds.setTestOnBorrow(this.testOnBorrow);
        this.ds.setTestOnReturn(this.testOnReturn);
        this.ds.setRemoveAbandoned(this.removeAbandoned);
        this.ds.setRemoveAbandonedTimeoutMillis(this.removeAbandonedTimeoutMillis);
        this.ds.setLogAbandoned(this.logAbandoned);
        this.ds.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize);
        if (this.defaultTransactionIsolation != null) {
            this.ds.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (this.validationQueryTimeout != null) {
            this.ds.setValidationQueryTimeout(this.validationQueryTimeout.intValue());
        }
        if (this.timeBetweenLogStatsMillis != null) {
            this.ds.setTimeBetweenLogStatsMillis((long)this.timeBetweenLogStatsMillis.intValue());
        }
        if (this.keepAlive != null) {
            this.ds.setKeepAlive(this.keepAlive.booleanValue());
        }
        boolean hasSetConnectionProperties = false;
        if (StrKit.notBlank(this.filters)) {
            try {
                this.ds.setFilters(this.filters);
                if (this.filters.contains("config")) {
                    if (StrKit.isBlank(this.publicKey)) {
                        throw new RuntimeException("Druid\u8fde\u63a5\u6c60\u7684filter\u8bbe\u5b9a\u4e86config\u65f6\uff0c\u5fc5\u987b\u8bbe\u5b9apublicKey");
                    }
                    String decryptStr = "config.decrypt=true;config.decrypt.key=" + this.publicKey;
                    String cp = this.connectionProperties;
                    cp = StrKit.isBlank(cp) ? decryptStr : cp + ";" + decryptStr;
                    this.ds.setConnectionProperties(cp);
                    hasSetConnectionProperties = true;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (!hasSetConnectionProperties && StrKit.notBlank(this.connectionProperties)) {
            this.ds.setConnectionProperties(this.connectionProperties);
        }
        this.addFilterList(this.ds);
        this.isStarted = true;
        return true;
    }

    private void addFilterList(DruidDataSource ds) {
        if (this.filterList != null) {
            List targetList = ds.getProxyFilters();
            for (Filter add : this.filterList) {
                boolean found = false;
                for (Filter target : targetList) {
                    if (!add.getClass().equals(target.getClass())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                targetList.add(add);
            }
        }
    }

    @Override
    public boolean stop() {
        if (this.ds != null) {
            this.ds.close();
        }
        this.ds = null;
        this.isStarted = false;
        return true;
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    public DruidPlugin set(int initialSize, int minIdle, int maxActive) {
        this.initialSize = initialSize;
        this.minIdle = minIdle;
        this.maxActive = maxActive;
        return this;
    }

    public DruidPlugin setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    public DruidPlugin setInitialSize(int initialSize) {
        this.initialSize = initialSize;
        return this;
    }

    public DruidPlugin setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public DruidPlugin setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public DruidPlugin setMaxWait(long maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public DruidPlugin setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        return this;
    }

    public DruidPlugin setValidationQueryTimeout(int validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
        return this;
    }

    public DruidPlugin setTimeBetweenLogStatsMillis(int timeBetweenLogStatsMillis) {
        this.timeBetweenLogStatsMillis = timeBetweenLogStatsMillis;
        return this;
    }

    public DruidPlugin setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public DruidPlugin setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        return this;
    }

    public DruidPlugin setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        return this;
    }

    public DruidPlugin setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        return this;
    }

    public DruidPlugin setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public DruidPlugin setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public DruidPlugin setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public DruidPlugin setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
        return this;
    }

    public final DruidPlugin setTimeBetweenConnectErrorMillis(long timeBetweenConnectErrorMillis) {
        this.timeBetweenConnectErrorMillis = timeBetweenConnectErrorMillis;
        return this;
    }

    public final DruidPlugin setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
        return this;
    }

    public final DruidPlugin setRemoveAbandonedTimeoutMillis(long removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
        return this;
    }

    public final DruidPlugin setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
        return this;
    }

    public final DruidPlugin setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public final DruidPlugin setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }
}

