/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.Func;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.generator.BaseModelGenerator;
import com.jfinal.plugin.activerecord.generator.DataDictionaryGenerator;
import com.jfinal.plugin.activerecord.generator.MappingKitGenerator;
import com.jfinal.plugin.activerecord.generator.MetaBuilder;
import com.jfinal.plugin.activerecord.generator.ModelGenerator;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.plugin.activerecord.generator.TypeMapping;
import java.util.List;
import javax.sql.DataSource;

public class Generator {
    protected Dialect dialect = null;
    protected MetaBuilder metaBuilder;
    protected BaseModelGenerator baseModelGenerator;
    protected ModelGenerator modelGenerator;
    protected MappingKitGenerator mappingKitGenerator;
    protected DataDictionaryGenerator dataDictionaryGenerator;
    protected boolean generateDataDictionary = false;

    public Generator(DataSource dataSource, String baseModelPackageName, String baseModelOutputDir, String modelPackageName, String modelOutputDir) {
        this(dataSource, new BaseModelGenerator(baseModelPackageName, baseModelOutputDir), new ModelGenerator(modelPackageName, baseModelPackageName, modelOutputDir));
    }

    public Generator(DataSource dataSource, String baseModelPackageName, String baseModelOutputDir) {
        this(dataSource, new BaseModelGenerator(baseModelPackageName, baseModelOutputDir));
    }

    public Generator(DataSource dataSource, BaseModelGenerator baseModelGenerator) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        if (baseModelGenerator == null) {
            throw new IllegalArgumentException("baseModelGenerator can not be null.");
        }
        this.metaBuilder = new MetaBuilder(dataSource);
        this.baseModelGenerator = baseModelGenerator;
        this.modelGenerator = null;
        this.mappingKitGenerator = null;
        this.dataDictionaryGenerator = null;
    }

    public Generator(DataSource dataSource, BaseModelGenerator baseModelGenerator, ModelGenerator modelGenerator) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        if (baseModelGenerator == null) {
            throw new IllegalArgumentException("baseModelGenerator can not be null.");
        }
        if (modelGenerator == null) {
            throw new IllegalArgumentException("modelGenerator can not be null.");
        }
        this.metaBuilder = new MetaBuilder(dataSource);
        this.baseModelGenerator = baseModelGenerator;
        this.modelGenerator = modelGenerator;
        this.mappingKitGenerator = new MappingKitGenerator(modelGenerator.modelPackageName, modelGenerator.modelOutputDir);
        this.dataDictionaryGenerator = new DataDictionaryGenerator(dataSource, modelGenerator.modelOutputDir);
    }

    public void configMetaBuilder(Func.F10<MetaBuilder> metaBuilder) {
        metaBuilder.call(this.metaBuilder);
    }

    public void configBaseModelGenerator(Func.F10<BaseModelGenerator> baseModelGenerator) {
        baseModelGenerator.call(this.baseModelGenerator);
    }

    public void configModelGenerator(Func.F10<ModelGenerator> modelGenerator) {
        modelGenerator.call(this.modelGenerator);
    }

    public void configMappingKitGenerator(Func.F10<MappingKitGenerator> mappingKitGenerator) {
        mappingKitGenerator.call(this.mappingKitGenerator);
    }

    public void configDataDictionaryGenerator(Func.F10<DataDictionaryGenerator> dataDictionaryGenerator) {
        dataDictionaryGenerator.call(this.dataDictionaryGenerator);
    }

    public void setMetaBuilder(MetaBuilder metaBuilder) {
        if (metaBuilder != null) {
            this.metaBuilder = metaBuilder;
        }
    }

    public MetaBuilder getMetaBuilder() {
        return this.metaBuilder;
    }

    public void setGenerateRemarks(boolean generateRemarks) {
        if (this.metaBuilder != null) {
            this.metaBuilder.setGenerateRemarks(generateRemarks);
        }
    }

    public void setGenerateView(boolean generateView) {
        if (this.metaBuilder != null) {
            this.metaBuilder.setGenerateView(generateView);
        }
    }

    public void setFetchFieldAutoIncrement(boolean fetchFieldAutoIncrement) {
        if (this.metaBuilder != null) {
            this.metaBuilder.setFetchFieldAutoIncrement(fetchFieldAutoIncrement);
        }
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.metaBuilder.setTypeMapping(typeMapping);
    }

    public void addTypeMapping(Class<?> from, Class<?> to) {
        this.metaBuilder.typeMapping.addMapping(from, to);
    }

    public void removeTypeMapping(Class<?> from) {
        this.metaBuilder.typeMapping.removeMapping(from);
    }

    public void addTypeMapping(String from, String to) {
        this.metaBuilder.typeMapping.addMapping(from, to);
    }

    public void removeTypeMapping(String from) {
        this.metaBuilder.typeMapping.removeMapping(from);
    }

    public void setMappingKitGenerator(MappingKitGenerator mappingKitGenerator) {
        if (mappingKitGenerator != null) {
            this.mappingKitGenerator = mappingKitGenerator;
        }
    }

    public void setDataDictionaryGenerator(DataDictionaryGenerator dataDictionaryGenerator) {
        if (dataDictionaryGenerator != null) {
            this.dataDictionaryGenerator = dataDictionaryGenerator;
        }
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setBaseModelTemplate(String baseModelTemplate) {
        this.baseModelGenerator.setTemplate(baseModelTemplate);
    }

    public void setGenerateChainSetter(boolean generateChainSetter) {
        this.baseModelGenerator.setGenerateChainSetter(generateChainSetter);
    }

    public void setRemovedTableNamePrefixes(String ... removedTableNamePrefixes) {
        this.metaBuilder.setRemovedTableNamePrefixes(removedTableNamePrefixes);
    }

    public void addWhitelist(String ... tableNames) {
        this.metaBuilder.addWhitelist(tableNames);
    }

    public void removeWhitelist(String tableName) {
        this.metaBuilder.removeWhitelist(tableName);
    }

    public void addBlacklist(String ... tableNames) {
        this.metaBuilder.addBlacklist(tableNames);
    }

    public void removeBlacklist(String tableName) {
        this.metaBuilder.removeBlacklist(tableName);
    }

    public void addExcludedTable(String ... excludedTables) {
        this.metaBuilder.addExcludedTable(excludedTables);
    }

    public void setModelTemplate(String modelTemplate) {
        if (this.modelGenerator != null) {
            this.modelGenerator.setTemplate(modelTemplate);
        }
    }

    public void setGenerateDaoInModel(boolean generateDaoInModel) {
        if (this.modelGenerator != null) {
            this.modelGenerator.setGenerateDaoInModel(generateDaoInModel);
        }
    }

    public void setGenerateDataDictionary(boolean generateDataDictionary) {
        this.generateDataDictionary = generateDataDictionary;
    }

    public void setMappingKitTemplate(String mappingKitTemplate) {
        if (this.mappingKitGenerator != null) {
            this.mappingKitGenerator.setTemplate(mappingKitTemplate);
        }
    }

    public void setMappingKitOutputDir(String mappingKitOutputDir) {
        if (this.mappingKitGenerator != null) {
            this.mappingKitGenerator.setMappingKitOutputDir(mappingKitOutputDir);
        }
    }

    public void setMappingKitPackageName(String mappingKitPackageName) {
        if (this.mappingKitGenerator != null) {
            this.mappingKitGenerator.setMappingKitPackageName(mappingKitPackageName);
        }
    }

    public void setMappingKitClassName(String mappingKitClassName) {
        if (this.mappingKitGenerator != null) {
            this.mappingKitGenerator.setMappingKitClassName(mappingKitClassName);
        }
    }

    public void setDataDictionaryOutputDir(String dataDictionaryOutputDir) {
        if (this.dataDictionaryGenerator != null) {
            this.dataDictionaryGenerator.setDataDictionaryOutputDir(dataDictionaryOutputDir);
        }
    }

    public void setDataDictionaryFileName(String dataDictionaryFileName) {
        if (this.dataDictionaryGenerator != null) {
            this.dataDictionaryGenerator.setDataDictionaryFileName(dataDictionaryFileName);
        }
    }

    public void generate() {
        if (this.dialect != null) {
            this.metaBuilder.setDialect(this.dialect);
        }
        long start = System.currentTimeMillis();
        List<TableMeta> tableMetas = this.metaBuilder.build();
        if (tableMetas.size() == 0) {
            System.out.println("TableMeta \u6570\u91cf\u4e3a 0\uff0c\u4e0d\u751f\u6210\u4efb\u4f55\u6587\u4ef6");
            return;
        }
        this.baseModelGenerator.generate(tableMetas);
        if (this.modelGenerator != null) {
            this.modelGenerator.generate(tableMetas);
        }
        if (this.mappingKitGenerator != null) {
            this.mappingKitGenerator.generate(tableMetas);
        }
        if (this.dataDictionaryGenerator != null && this.generateDataDictionary) {
            this.dataDictionaryGenerator.generate(tableMetas);
        }
        long usedTime = (System.currentTimeMillis() - start) / 1000L;
        System.out.println("Generate complete in " + usedTime + " seconds.");
    }
}

