/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.template.Env;
import com.jfinal.template.io.ByteWriter;
import com.jfinal.template.io.CharWriter;
import com.jfinal.template.io.FastStringWriter;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Stat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class Template {
    private Env env;
    private Stat ast;

    public Template(Env env, Stat ast) {
        if (env == null || ast == null) {
            throw new IllegalArgumentException("env and ast can not be null");
        }
        this.env = env;
        this.ast = ast;
    }

    public void render(Map<?, ?> data, OutputStream outputStream) {
        try (ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(outputStream);){
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
    }

    public void render(OutputStream outputStream) {
        this.render(null, outputStream);
    }

    public void render(Map<?, ?> data, Writer writer) {
        try (CharWriter charWriter = this.env.engineConfig.writerBuffer.getCharWriter(writer);){
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), charWriter);
        }
    }

    public void render(Writer writer) {
        this.render(null, writer);
    }

    public String renderToString(Map<?, ?> data) {
        try (FastStringWriter fsw = this.env.engineConfig.writerBuffer.getFastStringWriter();){
            this.render(data, fsw);
            String string = fsw.toString();
            return string;
        }
    }

    public String renderToString() {
        return this.renderToString(null);
    }

    public StringBuilder renderToStringBuilder(Map<?, ?> data) {
        FastStringWriter fsw = new FastStringWriter();
        this.render(data, fsw);
        return fsw.toStringBuilder();
    }

    public void render(Map<?, ?> data, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.render(data, fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void render(Map<?, ?> data, String fileName) {
        this.render(data, new File(fileName));
    }

    public boolean isModified() {
        return this.env.isSourceListModified();
    }

    /*
     * Exception decompiling
     */
    public String renderToString(Map<?, ?> data, Func<CharWriter> func) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void render(Map<?, ?> data, OutputStream outputStream, Func<ByteWriter> func) {
        try (ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(outputStream);){
            func.call(this.ast, this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
    }

    public void render(Map<?, ?> data, Writer writer, Func<CharWriter> func) {
        try (CharWriter charWriter = this.env.engineConfig.writerBuffer.getCharWriter(writer);){
            func.call(this.ast, this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), charWriter);
        }
    }

    public void render(Map<?, ?> data, File file, Func<ByteWriter> func) {
        try (FileOutputStream fos = new FileOutputStream(file);
             ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(fos);){
            func.call(this.ast, this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void close(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, OutputStream outputStream, boolean autoCloseOutputStream) {
        try (ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(outputStream);){
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
        finally {
            if (autoCloseOutputStream) {
                this.close(outputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, Writer writer, boolean autoCloseWriter) {
        try (CharWriter charWriter = this.env.engineConfig.writerBuffer.getCharWriter(writer);){
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), charWriter);
        }
        finally {
            if (autoCloseWriter) {
                this.close(writer);
            }
        }
    }

    @FunctionalInterface
    public static interface Func<T> {
        public void call(Stat var1, Env var2, Scope var3, T var4);
    }
}

