/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.FileMap;
import com.oreilly.servlet.UploadedFile;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    protected Hashtable parameters = new Hashtable();
    protected FileMap files = new FileMap();

    public MultipartRequest(HttpServletRequest request, String saveDirectory) throws IOException {
        this(request, saveDirectory, 0x100000);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this(request, saveDirectory, maxPostSize, null, null);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, String encoding) throws IOException {
        this(request, saveDirectory, 0x100000, encoding, null);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, FileRenamePolicy policy) throws IOException {
        this(request, saveDirectory, maxPostSize, null, policy);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding) throws IOException {
        this(request, saveDirectory, maxPostSize, encoding, null);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding, FileRenamePolicy policy) throws IOException {
        try {
            this.parse(request, saveDirectory, maxPostSize, encoding, policy);
        }
        catch (IOException e) {
            this.files.deleteAllFiles();
            throw e;
        }
        catch (Exception e) {
            this.files.deleteAllFiles();
            throw new RuntimeException(e);
        }
    }

    public void parse(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding, FileRenamePolicy policy) throws IOException {
        Part part;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        File dir = new File(saveDirectory);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        MultipartParser parser = new MultipartParser(request, maxPostSize, true, true, encoding);
        if (request.getQueryString() != null) {
            Hashtable queryParameters = HttpUtils.parseQueryString((String)request.getQueryString());
            Enumeration queryParameterNames = queryParameters.keys();
            while (queryParameterNames.hasMoreElements()) {
                Object paramName = queryParameterNames.nextElement();
                String[] values = (String[])queryParameters.get(paramName);
                Vector<String> newValues = new Vector<String>();
                for (int i = 0; i < values.length; ++i) {
                    newValues.add(values[i]);
                }
                this.parameters.put(paramName, newValues);
            }
        }
        while ((part = parser.readNextPart()) != null) {
            String name = part.getName();
            if (name == null) {
                throw new IOException("Malformed input: parameter name missing (known Opera 7 bug)");
            }
            if (part.isParam()) {
                ParamPart paramPart = (ParamPart)part;
                String value = paramPart.getStringValue();
                Vector<String> existingValues = (Vector<String>)this.parameters.get(name);
                if (existingValues == null) {
                    existingValues = new Vector<String>();
                    this.parameters.put(name, existingValues);
                }
                existingValues.addElement(value);
                continue;
            }
            if (!part.isFile()) continue;
            FilePart filePart = (FilePart)part;
            String fileName = filePart.getFileName();
            if (fileName != null) {
                filePart.setRenamePolicy(policy);
                filePart.writeTo(dir);
                this.files.put(name, new UploadedFile(dir.toString(), filePart.getFileName(), fileName, filePart.getContentType()));
                continue;
            }
            this.files.put(name, new UploadedFile(null, null, null, null));
        }
    }

    public MultipartRequest(ServletRequest request, String saveDirectory) throws IOException {
        this((HttpServletRequest)request, saveDirectory);
    }

    public MultipartRequest(ServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this((HttpServletRequest)request, saveDirectory, maxPostSize);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public Set<String> getFileNameSet() {
        return this.files.getFileNameSet();
    }

    public String getParameter(String name) {
        try {
            Vector values = (Vector)this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            String value = (String)values.elementAt(values.size() - 1);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getParameterValues(String name) {
        try {
            Vector values = (Vector)this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            Object[] valuesArray = new String[values.size()];
            values.copyInto(valuesArray);
            return valuesArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFilesystemName(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getFilesystemName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOriginalFileName(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getOriginalFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            UploadedFile file = this.files.get(name);
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }
}

