/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet.multipart;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class LimitedServletInputStream
extends ServletInputStream {
    private ServletInputStream in;
    private long totalExpected;
    private long totalRead = 0L;

    public LimitedServletInputStream(ServletInputStream in, long totalExpected) {
        this.in = in;
        this.totalExpected = totalExpected;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        long left = this.totalExpected - this.totalRead;
        if (left <= 0L) {
            return -1;
        }
        int result = this.in.readLine(b, off, (int)Math.min(left, (long)len));
        if (result > 0) {
            this.totalRead += (long)result;
        }
        return result;
    }

    public int read() throws IOException {
        if (this.totalRead >= this.totalExpected) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            ++this.totalRead;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        long left = this.totalExpected - this.totalRead;
        if (left <= 0L) {
            return -1;
        }
        int result = this.in.read(b, off, (int)Math.min(left, (long)len));
        if (result > 0) {
            this.totalRead += (long)result;
        }
        return result;
    }

    public boolean isFinished() {
        return this.in.isFinished();
    }

    public boolean isReady() {
        return this.in.isReady();
    }

    public void setReadListener(ReadListener readListener) {
        this.in.setReadListener(readListener);
    }
}

