/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.kit.StrKit;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.FieldGetter;
import com.jfinal.template.expr.ast.MethodKit;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class FieldGetters {

    public static class ArrayLengthGetter
    extends FieldGetter {
        static final ArrayLengthGetter singleton = new ArrayLengthGetter();

        @Override
        public FieldGetter takeOver(Class<?> targetClass, String fieldName) {
            if ("length".equals(fieldName) && targetClass.isArray()) {
                return singleton;
            }
            return null;
        }

        @Override
        public Object get(Object target, String fieldName) throws Exception {
            return Array.getLength(target);
        }
    }

    public static class RealFieldGetter
    extends FieldGetter {
        protected Field field;

        public RealFieldGetter(Field field) {
            this.field = field;
        }

        @Override
        public FieldGetter takeOver(Class<?> targetClass, String fieldName) {
            Field[] fieldArray;
            for (Field field : fieldArray = targetClass.getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return new RealFieldGetter(field);
            }
            return null;
        }

        @Override
        public Object get(Object target, String fieldName) throws Exception {
            return this.field.get(target);
        }

        public String toString() {
            return this.field.toString();
        }
    }

    public static class MapFieldGetter
    extends FieldGetter {
        static final MapFieldGetter singleton = new MapFieldGetter();

        @Override
        public FieldGetter takeOver(Class<?> targetClass, String fieldName) {
            if (Map.class.isAssignableFrom(targetClass)) {
                return singleton;
            }
            return null;
        }

        @Override
        public Object get(Object target, String fieldName) throws Exception {
            return ((Map)target).get(fieldName);
        }
    }

    public static class IsMethodFieldGetter
    extends FieldGetter {
        protected Method isMethod;

        public IsMethodFieldGetter() {
        }

        public IsMethodFieldGetter(Method isMethod) {
            this.isMethod = isMethod;
        }

        @Override
        public FieldGetter takeOver(Class<?> targetClass, String fieldName) {
            Method[] methodArray;
            if (MethodKit.isForbiddenClass(targetClass)) {
                throw new RuntimeException("Forbidden class: " + targetClass.getName());
            }
            String isMethodName = "is" + StrKit.firstCharToUpperCase(fieldName);
            for (Method method : methodArray = targetClass.getMethods()) {
                Class<?> returnType;
                if (!method.getName().equals(isMethodName) || method.getParameterCount() != 0 || (returnType = method.getReturnType()) != Boolean.class && returnType != Boolean.TYPE) continue;
                return new IsMethodFieldGetter(method);
            }
            return null;
        }

        @Override
        public Object get(Object target, String fieldName) throws Exception {
            return this.isMethod.invoke(target, ExprList.NULL_OBJECT_ARRAY);
        }

        public String toString() {
            return this.isMethod.toString();
        }
    }

    public static class GetterMethodFieldGetter
    extends FieldGetter {
        protected Method getterMethod;

        public GetterMethodFieldGetter(Method getterMethod) {
            this.getterMethod = getterMethod;
        }

        @Override
        public FieldGetter takeOver(Class<?> targetClass, String fieldName) {
            Method[] methodArray;
            if (MethodKit.isForbiddenClass(targetClass)) {
                throw new RuntimeException("Forbidden class: " + targetClass.getName());
            }
            String getterName = "get" + StrKit.firstCharToUpperCase(fieldName);
            for (Method method : methodArray = targetClass.getMethods()) {
                if (!method.getName().equals(getterName) || method.getParameterCount() != 0) continue;
                return new GetterMethodFieldGetter(method);
            }
            return null;
        }

        @Override
        public Object get(Object target, String fieldName) throws Exception {
            return this.getterMethod.invoke(target, ExprList.NULL_OBJECT_ARRAY);
        }

        public String toString() {
            return this.getterMethod.toString();
        }
    }

    public static class NullFieldGetter
    extends FieldGetter {
        public static final NullFieldGetter me = new NullFieldGetter();

        @Override
        public boolean notNull() {
            return false;
        }

        @Override
        public FieldGetter takeOver(Class<?> targetClass, String fieldName) {
            throw new RuntimeException("The method takeOver(Class, String) of NullFieldGetter should not be invoked");
        }

        @Override
        public Object get(Object target, String fieldName) throws Exception {
            throw new RuntimeException("The method get(Object, String) of NullFieldGetter should not be invoked");
        }
    }
}

