/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat;

public class Compressor {
    protected char separator = (char)10;

    public Compressor() {
    }

    public Compressor(char separator) {
        if (separator > ' ') {
            throw new IllegalArgumentException("The parameter separator must be a separator character");
        }
        this.separator = separator;
    }

    public StringBuilder compress(StringBuilder content) {
        int len = content.length();
        StringBuilder ret = new StringBuilder(len);
        int begin = 0;
        int forward = 0;
        while (forward < len) {
            char ch;
            boolean hasLineFeed = false;
            while (forward < len && (ch = content.charAt(forward)) <= ' ') {
                if (ch == '\n') {
                    hasLineFeed = true;
                }
                ++forward;
            }
            if (begin != forward) {
                if (hasLineFeed) {
                    ret.append(this.separator);
                } else {
                    ret.append(' ');
                }
            }
            while (forward < len && (ch = content.charAt(forward)) > ' ') {
                ret.append(ch);
                ++forward;
            }
            begin = forward;
        }
        return ret;
    }
}

