/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.expr.Sym;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Scope;

public class Const
extends Expr {
    public static final Const TRUE = new Const(Sym.TRUE, Boolean.TRUE);
    public static final Const FALSE = new Const(Sym.FALSE, Boolean.FALSE);
    public static final Const NULL = new Const(Sym.NULL, null);
    private final Sym type;
    private final Object value;

    public Const(Sym type, Object value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public Object eval(Scope scope) {
        return this.value;
    }

    public boolean isStr() {
        return this.type == Sym.STR;
    }

    public boolean isTrue() {
        return this.type == Sym.TRUE;
    }

    public boolean isFalse() {
        return this.type == Sym.FALSE;
    }

    public boolean isBoolean() {
        return this.type == Sym.TRUE || this.type == Sym.FALSE;
    }

    public boolean isNull() {
        return this.type == Sym.NULL;
    }

    public boolean isInt() {
        return this.type == Sym.INT;
    }

    public boolean isLong() {
        return this.type == Sym.LONG;
    }

    public boolean isFloat() {
        return this.type == Sym.FLOAT;
    }

    public boolean isDouble() {
        return this.type == Sym.DOUBLE;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStr() {
        return (String)this.value;
    }

    public Boolean getBoolean() {
        return (Boolean)this.value;
    }

    public Integer getInt() {
        return (Integer)this.value;
    }

    public Long getLong() {
        return (Long)this.value;
    }

    public Float getFloat() {
        return (Float)this.value;
    }

    public Double getDouble() {
        return (Double)this.value;
    }

    public Number getNumber() {
        return (Number)this.value;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "null";
    }
}

