/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow;

import com.jfinal.server.undertow.UndertowKit;
import com.jfinal.server.undertow.hotswap.ClassLoaderKit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;

public class PropExt {
    protected Properties properties = null;
    static ClassLoaderKit classLoaderKit = null;

    private ClassLoader getClassLoader() {
        if (classLoaderKit == null) {
            classLoaderKit = new ClassLoaderKit(PropExt.class.getClassLoader(), null);
        }
        return classLoaderKit.getClassLoader();
    }

    public PropExt() {
        this.properties = new Properties();
    }

    public PropExt(Properties properties) {
        this.properties = properties;
    }

    public PropExt(String fileName) {
        this(fileName, "UTF-8");
    }

    public PropExt(String fileName, String encoding) {
        InputStream inputStream = null;
        try {
            inputStream = this.getClassLoader().getResourceAsStream(fileName);
            if (inputStream == null) {
                throw new FileNotFoundException("Properties file not found in classpath: " + fileName);
            }
            this.properties = new Properties();
            this.properties.load(new InputStreamReader(inputStream, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    UndertowKit.doNothing(e);
                }
            }
        }
    }

    public PropExt append(PropExt prop) {
        if (prop == null) {
            throw new IllegalArgumentException("prop can not be null");
        }
        this.properties.putAll((Map<?, ?>)prop.getProperties());
        return this;
    }

    public PropExt append(String fileName, String encoding) {
        return this.append(new PropExt(fileName, encoding));
    }

    public PropExt append(String fileName) {
        return this.append(fileName, "UTF-8");
    }

    public PropExt appendIfExists(String fileName, String encoding) {
        try {
            return this.append(new PropExt(fileName, encoding));
        }
        catch (Exception e) {
            return this;
        }
    }

    public PropExt appendIfExists(String fileName) {
        return this.appendIfExists(fileName, "UTF-8");
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Long.parseLong(value.trim());
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            if ("true".equals(value = value.toLowerCase().trim())) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new RuntimeException("The value can not parse to Boolean : " + value);
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean notEmpty() {
        return !this.properties.isEmpty();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static class FileNotFoundException
    extends RuntimeException {
        public FileNotFoundException(String msg) {
            super(msg);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

