/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import javax.websocket.server.ServerEndpoint;

public class WebSocketConfig {
    private WebSocketDeploymentInfo webSocketDeploymentInfo;

    public synchronized void addWebSocketEndpoint(Class<?> webSocketEndpoint) {
        if (webSocketEndpoint == null) {
            throw new IllegalArgumentException("webSocketEndpoint can not be null");
        }
        if (!webSocketEndpoint.isAnnotationPresent(ServerEndpoint.class)) {
            throw new IllegalArgumentException("webSocketEndpoint must annotated by @ServerEndpoint");
        }
        if (this.webSocketDeploymentInfo == null) {
            this.webSocketDeploymentInfo = new WebSocketDeploymentInfo();
        }
        this.webSocketDeploymentInfo.addEndpoint(webSocketEndpoint);
    }

    public void configWebSocket(DeploymentInfo deploymentInfo) {
        this.webSocketDeploymentInfo.setBuffers((ByteBufferPool)new DefaultByteBufferPool(true, 100));
        deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)this.webSocketDeploymentInfo);
    }
}

