/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.utils;

import com.jfinal.kit.LogKit;
import java.util.concurrent.Callable;

public class RetryUtils {
    public static <V extends ResultCheck> V retryOnException(int retryLimit, Callable<V> retryCallable) {
        ResultCheck v = null;
        for (int i = 0; i < retryLimit; ++i) {
            try {
                v = (ResultCheck)retryCallable.call();
            }
            catch (Exception e) {
                LogKit.warn((String)("retry on " + (i + 1) + " times v = " + (v == null ? null : v.getJson())), (Throwable)e);
            }
            if (null != v && v.matching()) break;
            LogKit.error((String)("retry on " + (i + 1) + " times but not matching v = " + (v == null ? null : v.getJson())));
        }
        return (V)v;
    }

    public static <V extends ResultCheck> V retryOnException(int retryLimit, long sleepMillis, Callable<V> retryCallable) throws InterruptedException {
        ResultCheck v = null;
        for (int i = 0; i < retryLimit; ++i) {
            try {
                v = (ResultCheck)retryCallable.call();
            }
            catch (Exception e) {
                LogKit.warn((String)("retry on " + (i + 1) + " times v = " + (v == null ? null : v.getJson())), (Throwable)e);
            }
            if (null != v && v.matching()) break;
            LogKit.error((String)("retry on " + (i + 1) + " times but not matching v = " + (v == null ? null : v.getJson())));
            Thread.sleep(sleepMillis);
        }
        return (V)v;
    }

    public static interface ResultCheck {
        public boolean matching();

        public String getJson();
    }
}

