/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.api;

import com.jfinal.kit.HashKit;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.encrypt.WxaBizDataCrypt;
import com.jfinal.weixin.sdk.kit.PaymentKit;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.wxaapp.WxaConfig;
import com.jfinal.wxaapp.WxaConfigKit;
import java.util.HashMap;

public class WxaUserApi {
    private static String jsCode2sessionUrl = "https://api.weixin.qq.com/sns/jscode2session";

    public ApiResult getSessionKey(String jsCode) {
        WxaConfig wc = WxaConfigKit.getWxaConfig();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", wc.getAppId());
        params.put("secret", wc.getAppSecret());
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        String para = PaymentKit.packageSign(params, false);
        String url = jsCode2sessionUrl + "?" + para;
        return new ApiResult(HttpUtils.get(url));
    }

    public ApiResult getUserInfo(String sessionKey, String encryptedData, String ivStr) {
        WxaBizDataCrypt dataCrypt = new WxaBizDataCrypt(sessionKey);
        String json = dataCrypt.decrypt(encryptedData, ivStr);
        return new ApiResult(json);
    }

    public boolean checkUserInfo(String sessionKey, String rawData, String signature) {
        StringBuffer sb = new StringBuffer(rawData).append(sessionKey);
        String encryData = HashKit.sha1((String)sb.toString());
        return encryData.equals(signature);
    }
}

