/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp;

import com.jfinal.kit.StrKit;
import com.jfinal.wxaapp.WxaConfig;
import com.jfinal.wxaapp.msg.IMsgParser;
import com.jfinal.wxaapp.msg.JsonMsgParser;
import com.jfinal.wxaapp.msg.XmlMsgParser;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WxaConfigKit {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, WxaConfig> CFG_MAP = new ConcurrentHashMap<String, WxaConfig>();
    private static final String DEFAULT_CFG_KEY = "_default_cfg_key_";
    static final XmlMsgParser MSG_PARSER_XML = new XmlMsgParser();
    static final JsonMsgParser MSG_PARSER_JSON = new JsonMsgParser();
    private static IMsgParser msgParser = MSG_PARSER_XML;
    private static boolean devMode = false;

    public static IMsgParser getMsgParser() {
        IMsgParser type = WxaConfigKit.getWxaConfig().getMsgParser();
        return null != type ? type : msgParser;
    }

    public static void useJsonMsgParser() {
        msgParser = MSG_PARSER_JSON;
    }

    public static void setDevMode(boolean devMode) {
        WxaConfigKit.devMode = devMode;
    }

    public static boolean isDevMode() {
        return devMode;
    }

    public static WxaConfig putWxaConfig(WxaConfig wxaConfig) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, wxaConfig);
        }
        return CFG_MAP.put(wxaConfig.getAppId(), wxaConfig);
    }

    public static void setWxaConfig(WxaConfig wxaConfig) {
        WxaConfigKit.putWxaConfig(wxaConfig);
    }

    public static String getAppId() {
        String appId = TL.get();
        if (StrKit.isBlank((String)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        return appId;
    }

    public static WxaConfig getWxaConfig() {
        String appId = WxaConfigKit.getAppId();
        return WxaConfigKit.getWxaConfig(appId);
    }

    public static WxaConfig getWxaConfig(String appId) {
        WxaConfig cfg = CFG_MAP.get(appId);
        if (cfg == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 WxaConfigKit.putWxaConfig(wxaConfig) \u5c06 appId\u5bf9\u5e94\u7684 WxaConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u5982JFinalConfig.onStart()\u4e2d\u8c03\u7528, \u624d\u53ef\u4ee5\u4f7f\u7528 WxaConfigKit.getWxaConfig() \u7cfb\u5217\u65b9\u6cd5");
        }
        return cfg;
    }

    public static WxaConfig removeApiConfig(WxaConfig wxaConfig) {
        return WxaConfigKit.removeApiConfig(wxaConfig.getAppId());
    }

    public static WxaConfig removeApiConfig(String appId) {
        return CFG_MAP.remove(appId);
    }

    public static void setThreadLocalAppId(String appId) {
        if (StrKit.isBlank((String)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        TL.set(appId);
    }

    public static void removeThreadLocalAppId() {
        TL.remove();
    }
}

