/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.api;

import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.wxaapp.api.WxaAccessTokenApi;
import java.io.File;
import java.util.Map;

public class WxaOcrApi {
    public static ApiResult ocrByUrl(OCR_TYPE type, String imgUrl) {
        String accessToken = WxaAccessTokenApi.getAccessTokenStr();
        Map<String, String> queryParas = ParaMap.create("img_url", imgUrl).getData();
        return new ApiResult(HttpUtils.get(type.get() + accessToken, queryParas));
    }

    public static ApiResult ocrByFile(OCR_TYPE type, File file) {
        String accessToken = WxaAccessTokenApi.getAccessTokenStr();
        String upload = HttpUtils.upload(type.get() + accessToken, file, null);
        return new ApiResult(upload);
    }

    public static enum OCR_TYPE {
        BANK_CARD("https://api.weixin.qq.com/cv/ocr/bankcard?access_token="),
        BUSINESS_LICENSE("https://api.weixin.qq.com/cv/ocr/bizlicense?access_token="),
        DRIVER_LICENSE("https://api.weixin.qq.com/cv/ocr/drivinglicense?access_token="),
        ID_CARD("https://api.weixin.qq.com/cv/ocr/idcard?access_token="),
        PRINTED_TEXT("https://api.weixin.qq.com/cv/ocr/comm?access_token="),
        VEHICLE_LICENSE("https://api.weixin.qq.com/cv/ocr/driving?access_token=");

        private final String url;

        private OCR_TYPE(String url) {
            this.url = url;
        }

        public String get() {
            return this.url;
        }
    }
}

