/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse;

import com.jfirer.fse.ClassRegistry;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.ObjectCollector;
import com.jfirer.fse.SerializerFactory;
import com.jfirer.fse.ShouldSupportCycleException;

public class FseContext {
    private SerializerFactory serializerFactory = new SerializerFactory();
    private ObjectCollector objectCollector = new ObjectCollector();
    private ClassRegistry classRegistry = new ClassRegistry(this.serializerFactory);
    private boolean withCycle = true;

    public void setWithCycle(boolean withCycle) {
        this.withCycle = withCycle;
    }

    public int collectObject(Object o) {
        if (!this.withCycle) {
            return -1;
        }
        return this.objectCollector.collect(o);
    }

    public void serialzeClass(InternalByteArray byteArray) {
        this.classRegistry.serializeClass(byteArray);
    }

    public void deSerializeClass(InternalByteArray byteArray) {
        this.classRegistry.deSerializeClass(byteArray);
    }

    public void clear() {
        this.objectCollector.clear();
        this.classRegistry.clear();
        this.withCycle = true;
    }

    public Object getObjectByIndex(int i) {
        return this.objectCollector.getObject(i);
    }

    public void registerClass(Class ckass) {
        this.classRegistry.register(ckass);
    }

    public void startSerilaize(Object o, InternalByteArray byteArray) {
        if (o == null) {
            byteArray.put((byte)0);
            return;
        }
        Class<?> ckass = o.getClass();
        ClassRegistry.Entry entry = this.classRegistry.getEntry(ckass);
        if (entry.getSerializer().needSupportCycle()) {
            this.withCycle = true;
            entry.getSerializer().writeToBytes(o, entry.getId(), byteArray, this, -1);
            byteArray.setByte(0, (byte)-63);
        } else {
            try {
                this.withCycle = false;
                entry.getSerializer().writeToBytes(o, entry.getId(), byteArray, this, 0);
                byteArray.setByte(0, (byte)-62);
            }
            catch (ShouldSupportCycleException | StackOverflowError e) {
                this.withCycle = true;
                entry.getSerializer().supportCycle();
                byteArray.setWritePosi(5);
                entry.getSerializer().writeToBytes(o, entry.getId(), byteArray, this, -1);
                byteArray.setByte(0, (byte)-63);
            }
        }
    }

    public void serialize(Object o, InternalByteArray byteArray, int depth) {
        if (o == null) {
            byteArray.put((byte)0);
            return;
        }
        Class<?> ckass = o.getClass();
        ClassRegistry.Entry entry = this.classRegistry.getEntry(ckass);
        entry.getSerializer().writeToBytes(o, entry.getId(), byteArray, this, depth);
    }

    public ClassRegistry.Entry getClassRegistry(Class ckass) {
        return this.classRegistry.getEntry(ckass);
    }

    public ClassRegistry.Entry getClassRegistry(int id) {
        return this.classRegistry.getEntry(id);
    }

    public void useCompile() {
        this.serializerFactory.setUseCompile(true);
    }

    public void registerFseSerializer(Class ckass, FseSerializer fseSerializer) {
        this.serializerFactory.register(ckass, fseSerializer);
    }
}

