/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse;

import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.serializer.ArraySerializer;
import com.jfirer.fse.serializer.CompileObjectSerializer;
import com.jfirer.fse.serializer.ObjectSerializer;
import com.jfirer.fse.serializer.array.BooleanArraySerializer;
import com.jfirer.fse.serializer.array.ByteArraySerializer;
import com.jfirer.fse.serializer.array.CharArraySerializer;
import com.jfirer.fse.serializer.array.DoubleArraySerializer;
import com.jfirer.fse.serializer.array.FloatArraySerializer;
import com.jfirer.fse.serializer.array.IntArraySerializer;
import com.jfirer.fse.serializer.array.LongArraySerializer;
import com.jfirer.fse.serializer.array.ShortArraySerializer;
import com.jfirer.fse.serializer.array.StringArraySerializer;
import com.jfirer.fse.serializer.base.BooleanSerializer;
import com.jfirer.fse.serializer.base.ByteSerializer;
import com.jfirer.fse.serializer.base.CharSserializer;
import com.jfirer.fse.serializer.base.DoubleSerializer;
import com.jfirer.fse.serializer.base.FloatSerializer;
import com.jfirer.fse.serializer.base.IntegerSerializer;
import com.jfirer.fse.serializer.base.LongSerializer;
import com.jfirer.fse.serializer.base.ShortSerializer;
import com.jfirer.fse.serializer.base.StringSerializer;
import com.jfirer.fse.serializer.extra.ArrayListSerializer;
import com.jfirer.fse.serializer.extra.CalendarSerializer;
import com.jfirer.fse.serializer.extra.ClassSerializer;
import com.jfirer.fse.serializer.extra.EnumSetSerialzer;
import com.jfirer.fse.serializer.extra.HashMapSerializer;
import com.jfirer.fse.serializer.extra.HashSetSerializer;
import com.jfirer.fse.serializer.extra.LinkedListSerializer;
import com.jfirer.fse.serializer.extra.MethodSerializer;
import com.jfirer.fse.serializer.extra.UtilDateSerializer;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;

public class SerializerFactory {
    private Map<Class, FseSerializer> serializerMap = new IdentityHashMap<Class, FseSerializer>();
    private boolean useCompile = false;

    public SerializerFactory() {
        this.serializerMap.put(int[].class, new IntArraySerializer(true));
        this.serializerMap.put(Integer[].class, new IntArraySerializer(false));
        this.serializerMap.put(short[].class, new ShortArraySerializer(true));
        this.serializerMap.put(Short[].class, new ShortArraySerializer(false));
        this.serializerMap.put(byte[].class, new ByteArraySerializer(true));
        this.serializerMap.put(Byte[].class, new ByteArraySerializer(false));
        this.serializerMap.put(float[].class, new FloatArraySerializer(true));
        this.serializerMap.put(Float[].class, new FloatArraySerializer(false));
        this.serializerMap.put(double[].class, new DoubleArraySerializer(true));
        this.serializerMap.put(Double[].class, new DoubleArraySerializer(false));
        this.serializerMap.put(long[].class, new LongArraySerializer(true));
        this.serializerMap.put(Long[].class, new LongArraySerializer(false));
        this.serializerMap.put(char[].class, new CharArraySerializer(true));
        this.serializerMap.put(Character[].class, new CharArraySerializer(false));
        this.serializerMap.put(boolean[].class, new BooleanArraySerializer(true));
        this.serializerMap.put(Boolean[].class, new BooleanArraySerializer(false));
        this.serializerMap.put(String[].class, new StringArraySerializer());
        this.serializerMap.put(Integer.class, new IntegerSerializer());
        this.serializerMap.put(Short.class, new ShortSerializer());
        this.serializerMap.put(Byte.class, new ByteSerializer());
        this.serializerMap.put(Long.class, new LongSerializer());
        this.serializerMap.put(Float.class, new FloatSerializer());
        this.serializerMap.put(Character.class, new CharSserializer());
        this.serializerMap.put(Double.class, new DoubleSerializer());
        this.serializerMap.put(Boolean.class, new BooleanSerializer());
        this.serializerMap.put(String.class, new StringSerializer());
        this.serializerMap.put(ArrayList.class, new ArrayListSerializer());
        this.serializerMap.put(Calendar.class, new CalendarSerializer());
        this.serializerMap.put(Class.class, new ClassSerializer());
        this.serializerMap.put(HashMap.class, new HashMapSerializer());
        this.serializerMap.put(HashSet.class, new HashSetSerializer());
        this.serializerMap.put(LinkedList.class, new LinkedListSerializer());
        this.serializerMap.put(java.util.Date.class, new UtilDateSerializer());
        this.serializerMap.put(Date.class, new UtilDateSerializer());
        this.serializerMap.put(Object.class, new ObjectSerializer());
        this.serializerMap.put(Calendar.getInstance().getClass(), new CalendarSerializer());
        this.serializerMap.put(Method.class, new MethodSerializer());
    }

    public FseSerializer getSerializer(Class type) {
        FseSerializer fseSerializer = this.serializerMap.get(type);
        if (fseSerializer != null) {
            return fseSerializer;
        }
        fseSerializer = EnumSet.class.isAssignableFrom(type) ? new EnumSetSerialzer() : (type.isArray() ? new ArraySerializer() : (this.useCompile ? new CompileObjectSerializer() : new ObjectSerializer()));
        this.serializerMap.put(type, fseSerializer);
        fseSerializer.init(type, this);
        return fseSerializer;
    }

    public void setUseCompile(boolean useCompile) {
        this.useCompile = useCompile;
    }

    public void register(Class ckass, FseSerializer fseSerializer) {
        this.serializerMap.put(ckass, fseSerializer);
    }
}

