/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse.serializer;

import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.baseutil.smc.SmcHelper;
import com.jfirer.baseutil.smc.compiler.CompileHelper;
import com.jfirer.baseutil.smc.model.ClassModel;
import com.jfirer.baseutil.smc.model.FieldModel;
import com.jfirer.baseutil.smc.model.MethodModel;
import com.jfirer.fse.CycleFlagSerializer;
import com.jfirer.fse.Fse;
import com.jfirer.fse.FseContext;
import com.jfirer.fse.FseIgnore;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.Helper;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.SerializerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CompileObjectSerializer
extends CycleFlagSerializer
implements FseSerializer {
    private Output output;

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        List<Field> allFields = this.getAllFields(type);
        ClassModel classModel = new ClassModel("output_" + type.getSimpleName());
        classModel.addImport(Helper.class);
        classModel.addImport(Fse.class);
        classModel.addInterface(Output.class);
        int count = 0;
        try {
            Method serialize = Output.class.getMethod("serialize", Object.class, InternalByteArray.class, FseContext.class, Integer.TYPE);
            Method deSerialize = Output.class.getMethod("deSerialize", InternalByteArray.class, FseContext.class);
            MethodModel serializeModel = new MethodModel(serialize, classModel);
            serializeModel.setParamterNames(new String[]{"o", "byteArray", "fseContext", "depth"});
            MethodModel deSerializeModel = new MethodModel(deSerialize, classModel);
            deSerializeModel.setParamterNames(new String[]{"byteArray", "fseContext"});
            classModel.putMethodModel(serializeModel);
            classModel.putMethodModel(deSerializeModel);
            StringBuilder serializeBody = new StringBuilder();
            StringBuilder deSerializeBody = new StringBuilder();
            String referenceName = SmcHelper.getReferenceName(type, (ClassModel)classModel);
            serializeBody.append(referenceName).append(" _target = (").append(referenceName).append(")o;\r\n");
            deSerializeBody.append(referenceName).append(" _target =new ").append(referenceName).append("();\r\n");
            deSerializeBody.append("fseContext.collectObject(_target);\r\n");
            for (Field each : allFields) {
                if (!this.isFieldGetAndSetMethodExist(each)) continue;
                if (each.getType().isPrimitive()) {
                    if (each.getType() == Integer.TYPE) {
                        serializeBody.append("byteArray.writeVarInt(_target.").append(this.buildGetMethodName(each)).append("());\r\n");
                        deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(byteArray.readVarInt());\r\n");
                        continue;
                    }
                    if (each.getType() == Byte.TYPE) {
                        serializeBody.append("byteArray.put(_target.").append(this.buildGetMethodName(each)).append("());\r\n");
                        deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(byteArray.get());\r\n");
                        continue;
                    }
                    if (each.getType() == Character.TYPE) {
                        serializeBody.append("byteArray.writeVarChar(_target.").append(this.buildGetMethodName(each)).append("());\r\n");
                        deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(byteArray.readVarChar());\r\n");
                        continue;
                    }
                    if (each.getType() == Long.TYPE) {
                        serializeBody.append("byteArray.writeVarLong(_target.").append(this.buildGetMethodName(each)).append("());\r\n");
                        deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(byteArray.readVarLong());\r\n");
                        continue;
                    }
                    if (each.getType() == Float.TYPE) {
                        serializeBody.append("byteArray.writeFloat(_target.").append(this.buildGetMethodName(each)).append("());\r\n");
                        deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(byteArray.readFloat());\r\n");
                        continue;
                    }
                    if (each.getType() == Short.TYPE) {
                        serializeBody.append("byteArray.writeShort(_target.").append(this.buildGetMethodName(each)).append("());\r\n");
                        deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(byteArray.readShort());\r\n");
                        continue;
                    }
                    if (each.getType() == Double.TYPE) {
                        serializeBody.append("byteArray.writeDouble(_target.").append(this.buildGetMethodName(each)).append("());\r\n");
                        deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(byteArray.readDouble());\r\n");
                        continue;
                    }
                    if (each.getType() != Boolean.TYPE) continue;
                    serializeBody.append("if(_target.").append(this.buildGetMethodName(each)).append("()){\r\n");
                    serializeBody.append("byteArray.put((byte)0);\r\n");
                    serializeBody.append("}else{\r\n");
                    serializeBody.append("byteArray.put((byte)1);\r\n");
                    serializeBody.append("}\r\n");
                    deSerializeBody.append("if(byteArray.get()==0){\r\n");
                    deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(true);\r\n");
                    deSerializeBody.append("}\r\n");
                    deSerializeBody.append("else{\r\n");
                    deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("(false);\r\n");
                    deSerializeBody.append("}\r\n");
                    continue;
                }
                int modifiers = each.getType().getModifiers();
                if (Modifier.isFinal(modifiers) || !Modifier.isAbstract(modifiers) && Modifier.isInterface(modifiers)) {
                    FseSerializer serializer = serializerFactory.getSerializer(each.getType());
                    Entry entry = new Entry();
                    entry.serializerName = "_s_" + count;
                    ++count;
                    entry.serializer = serializer;
                    FieldModel fieldModel = new FieldModel(entry.serializerName, FseSerializer.class, classModel);
                    classModel.addField(new FieldModel[]{fieldModel});
                    MethodModel setMethod = new MethodModel(classModel);
                    setMethod.setAccessLevel(MethodModel.AccessLevel.PUBLIC);
                    setMethod.setReturnType(Void.TYPE);
                    setMethod.setMethodName("set" + entry.serializerName);
                    setMethod.setParamterTypes(new Class[]{FseSerializer.class});
                    setMethod.setBody(entry.serializerName + "=$0;\r\n");
                    classModel.putMethodModel(setMethod);
                    entries.add(entry);
                    String propertyName = "_value_" + count;
                    ++count;
                    serializeBody.append("Object " + propertyName + " = _target." + this.buildGetMethodName(each) + "();\r\n");
                    serializeBody.append("if(" + propertyName + " == null ){byteArray.put(Fse.NULL);}");
                    if (Modifier.isFinal(modifiers)) {
                        serializeBody.append("else{\r\n");
                        serializeBody.append(entry.serializerName).append(".writeToBytes(").append(propertyName).append(",1,byteArray,fseContext,depth);\r\n");
                        serializeBody.append("}\r\n");
                    } else {
                        serializeBody.append("else if(" + propertyName + ".getClass()==" + SmcHelper.getReferenceName(each.getType(), (ClassModel)classModel) + ".class){\r\n");
                        serializeBody.append(entry.serializerName).append(".writeToBytes(").append(propertyName).append(",1,byteArray,fseContext,depth);\r\n");
                        serializeBody.append("}\r\n");
                        serializeBody.append("else{\r\n");
                        serializeBody.append("fseContext.serialize(" + propertyName + ",byteArray,depth);\r\n");
                        serializeBody.append("}\r\n");
                    }
                    String flagName = "_flag_" + count;
                    ++count;
                    deSerializeBody.append("int " + flagName + " = byteArray.readVarInt();\r\n");
                    deSerializeBody.append("if(" + flagName + "==0){\r\n_target.").append(this.buildSetMethodName(each)).append("(null);\r\n}\r\n");
                    deSerializeBody.append("else if(" + flagName + "==Fse.USE_FIELD_TYPE){\r\n");
                    deSerializeBody.append("_target." + this.buildSetMethodName(each) + "((" + SmcHelper.getReferenceName(each.getType(), (ClassModel)classModel) + ")" + entry.serializerName).append(".readBytes(byteArray,fseContext));\r\n");
                    deSerializeBody.append("}\r\n");
                    deSerializeBody.append("else if(" + flagName + "<0){\r\n");
                    deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("((" + SmcHelper.getReferenceName(each.getType(), (ClassModel)classModel) + ")fseContext.getObjectByIndex(0-" + flagName + "));\r\n");
                    deSerializeBody.append("}\r\n");
                    deSerializeBody.append("else{\r\n");
                    deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("((" + SmcHelper.getReferenceName(each.getType(), (ClassModel)classModel) + ")fseContext.getClassRegistry(" + flagName + ").getSerializer().readBytes(byteArray,fseContext));\r\n");
                    deSerializeBody.append("}\r\n");
                    continue;
                }
                serializeBody.append("fseContext.serialize(_target." + this.buildGetMethodName(each) + "(),byteArray,depth);\r\n");
                String flagName = "_flag_" + count;
                ++count;
                deSerializeBody.append("int " + flagName + " = byteArray.readVarInt();\r\n");
                deSerializeBody.append("if(" + flagName + "==0){\r\n_target.").append(this.buildSetMethodName(each)).append("(null);\r\n}\r\n");
                deSerializeBody.append("else if(" + flagName + "<0){\r\n");
                deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("((" + SmcHelper.getReferenceName(each.getType(), (ClassModel)classModel) + ")fseContext.getObjectByIndex(0-" + flagName + "));\r\n");
                deSerializeBody.append("}\r\n");
                deSerializeBody.append("else{\r\n");
                deSerializeBody.append("_target.").append(this.buildSetMethodName(each)).append("((" + SmcHelper.getReferenceName(each.getType(), (ClassModel)classModel) + ")fseContext.getClassRegistry(" + flagName + ").getSerializer().readBytes(byteArray,fseContext));\r\n");
                deSerializeBody.append("}\r\n");
            }
            serializeModel.setBody(serializeBody.toString());
            deSerializeBody.append("return _target;\r\n");
            deSerializeModel.setBody(deSerializeBody.toString());
            CompileHelper compileHelper = new CompileHelper();
            Class compile = compileHelper.compile(classModel);
            this.output = (Output)compile.newInstance();
            for (Entry entry : entries) {
                Method setMethod = compile.getMethod("set" + entry.serializerName, FseSerializer.class);
                setMethod.invoke((Object)this.output, entry.serializer);
            }
        }
        catch (Throwable e) {
            ReflectUtil.throwException((Throwable)e);
        }
    }

    private boolean isFieldGetAndSetMethodExist(Field field) {
        String getMethodName = this.buildGetMethodName(field);
        String setMethodName = this.buildSetMethodName(field);
        try {
            field.getDeclaringClass().getDeclaredMethod(getMethodName, new Class[0]);
            field.getDeclaringClass().getDeclaredMethod(setMethodName, field.getType());
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private String buildGetMethodName(Field field) {
        if (field.getType().isPrimitive()) {
            if (field.getType() == Boolean.TYPE) {
                return "is" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
            }
            return "get" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        }
        return "get" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
    }

    private String buildSetMethodName(Field field) {
        return "set" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
    }

    private List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> list = new ArrayList<Field>();
        while (type != Object.class) {
            for (Field each : type.getDeclaredFields()) {
                int modifiers;
                if (each.isAnnotationPresent(FseIgnore.class) || Modifier.isStatic(modifiers = each.getModifiers())) continue;
                list.add(each);
            }
            type = type.getSuperclass();
        }
        Collections.sort(list, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return list;
    }

    @Override
    public void doWriteToBytes(Object o, InternalByteArray byteArray, FseContext fseContext, int depth) {
        this.output.serialize(o, byteArray, fseContext, depth);
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        return this.output.deSerialize(byteArray, fseContext);
    }

    class Entry {
        String serializerName;
        FseSerializer serializer;

        Entry() {
        }
    }

    public static interface Output {
        public void serialize(Object var1, InternalByteArray var2, FseContext var3, int var4);

        public Object deSerialize(InternalByteArray var1, FseContext var2);
    }
}

