/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse.serializer.array;

import com.jfirer.fse.CycleFlagSerializer;
import com.jfirer.fse.FseContext;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.SerializerFactory;

public class ByteArraySerializer
extends CycleFlagSerializer
implements FseSerializer {
    private final boolean primitive;

    public ByteArraySerializer(boolean primitive) {
        this.primitive = primitive;
    }

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
    }

    @Override
    public void writeToBytes(Object o, int classIndex, InternalByteArray byteArray, FseContext fseContext, int depth) {
        byteArray.writeVarInt(classIndex);
        this.writeElement(o, byteArray);
    }

    private void writeElement(Object o, InternalByteArray byteArray) {
        if (this.primitive) {
            byte[] array = (byte[])o;
            byteArray.writePositive(array.length);
            for (byte i : array) {
                byteArray.put(i);
            }
        } else {
            Byte[] array = (Byte[])o;
            byteArray.writePositive(array.length);
            for (Byte each : array) {
                if (each == null) {
                    byteArray.put((byte)0);
                    continue;
                }
                byteArray.put((byte)1);
                byteArray.put(each);
            }
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        int len = byteArray.readPositive();
        return this.readElement(byteArray, len);
    }

    private Object readElement(InternalByteArray byteArray, int len) {
        if (this.primitive) {
            byte[] array = new byte[len];
            for (int i = 0; i < len; ++i) {
                array[i] = byteArray.get();
            }
            return array;
        }
        Byte[] array = new Byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = byteArray.get() == 0 ? null : Byte.valueOf(byteArray.get());
        }
        return array;
    }
}

