/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.fse.serializer.extra;

import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.fse.CycleFlagSerializer;
import com.jfirer.fse.FseContext;
import com.jfirer.fse.FseSerializer;
import com.jfirer.fse.InternalByteArray;
import com.jfirer.fse.SerializerFactory;
import java.lang.reflect.Field;
import java.util.EnumSet;

public class EnumSetSerialzer
extends CycleFlagSerializer
implements FseSerializer {
    Field elementType;

    @Override
    public void init(Class<?> type, SerializerFactory serializerFactory) {
        try {
            this.elementType = EnumSet.class.getDeclaredField("elementType");
            this.elementType.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToBytes(Object o, int classIndex, InternalByteArray byteArray, FseContext fseContext, int depth) {
        byteArray.writeVarInt(classIndex);
        Class type = null;
        try {
            type = (Class)this.elementType.get(o);
            byteArray.writeString(type.getName());
        }
        catch (IllegalAccessException e) {
            ReflectUtil.throwException((Throwable)e);
        }
        EnumSet enumSet = (EnumSet)o;
        int size = enumSet.size();
        byteArray.writePositive(size);
        for (Object each : enumSet) {
            byteArray.writeString(((Enum)each).name());
        }
    }

    @Override
    public Object readBytes(InternalByteArray byteArray, FseContext fseContext) {
        try {
            String s = byteArray.readString();
            Class<?> enumType = Class.forName(s);
            EnumSet<?> enums = EnumSet.noneOf(enumType);
            int size = byteArray.readPositive();
            for (int i = 0; i < size; ++i) {
                String enumName = byteArray.readString();
                enums.add(Enum.valueOf(enumType, enumName));
            }
            return enums;
        }
        catch (Throwable e) {
            ReflectUtil.throwException((Throwable)e);
            return null;
        }
    }
}

